/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.api.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.github.flemmli97.tenshilib.api.config.SimpleItemStackWrapper;
import io.github.flemmli97.tenshilib.platform.PlatformUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_6862;

public class ItemTagWrapper
extends SimpleItemStackWrapper {
    private List<class_1792> list = new ArrayList<class_1792>();
    private class_6862<class_1792> tag;

    public ItemTagWrapper(String item, int count) {
        super(item, count);
    }

    public ItemTagWrapper(class_6862<class_1792> tag) {
        this(tag, 1);
    }

    public ItemTagWrapper(class_6862<class_1792> tag, int count) {
        super("", count);
        this.tag = tag;
    }

    @Override
    public class_1792 getItem() {
        if (this.item == null) {
            if (!this.reg.isEmpty()) {
                return super.getItem();
            }
            if (this.tag == null) {
                this.item = class_1802.field_8162;
                return this.item;
            }
            Optional t = class_2378.field_11142.method_40266(this.tag);
            t.ifPresent(set -> set.forEach(holder -> this.list.add((class_1792)holder.comp_349())));
            this.item = !this.list.isEmpty() ? this.list.get(0) : class_1802.field_8162;
        }
        return this.item;
    }

    @Override
    public List<class_1792> getItemList() {
        this.getItem();
        return this.list;
    }

    @Override
    public boolean hasList() {
        return true;
    }

    @Override
    public boolean match(class_1799 stack) {
        if (this.tag == null) {
            return super.match(stack);
        }
        return stack.method_31573(this.tag);
    }

    @Override
    public ItemTagWrapper readFromString(String s) {
        String[] parts = s.split(",");
        if (parts[0].startsWith("#")) {
            this.tag = PlatformUtils.INSTANCE.itemTag(new class_2960(parts[0].substring(1)));
        } else {
            this.reg = parts[0];
        }
        this.count = parts.length < 2 ? 1 : Integer.parseInt(parts[1]);
        return this;
    }

    @Override
    public String writeToString() {
        if (this.tag != null) {
            return "#" + String.valueOf(this.tag.comp_327()) + (String)(this.count != 1 ? "," + this.count : "");
        }
        return super.writeToString();
    }

    public static String usage() {
        return "Usage: <#item-tag|item>,<amount>";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ItemTagWrapper) {
            ItemTagWrapper prop = (ItemTagWrapper)obj;
            return prop.writeToString().equals(this.toString());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.writeToString().hashCode();
    }

    public static class Serializer
    implements JsonDeserializer<ItemTagWrapper>,
    JsonSerializer<ItemTagWrapper> {
        public JsonElement serialize(ItemTagWrapper src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            if (src.tag != null) {
                obj.add("tag", (JsonElement)new JsonPrimitive(src.tag.comp_327().toString()));
            } else {
                obj.add("item", (JsonElement)new JsonPrimitive(src.reg));
            }
            if (src.count != 1) {
                obj.add("count", (JsonElement)new JsonPrimitive((Number)src.count));
            }
            return obj;
        }

        public ItemTagWrapper deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            int count = class_3518.method_15282((JsonObject)obj, (String)"count", (int)1);
            if (obj.has("tag")) {
                return new ItemTagWrapper(PlatformUtils.INSTANCE.itemTag(new class_2960(obj.get("tag").getAsString())), count);
            }
            return new ItemTagWrapper(obj.get("item").getAsString(), count);
        }
    }
}

