/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.api.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.github.flemmli97.tenshilib.api.config.ItemWrapper;
import java.lang.reflect.Type;
import net.minecraft.class_1799;
import net.minecraft.class_3518;

public class SimpleItemStackWrapper
extends ItemWrapper {
    protected int count;

    public SimpleItemStackWrapper(String s) {
        this(s, 1);
    }

    public SimpleItemStackWrapper(String s, int count) {
        super(s);
        this.count = count;
    }

    public SimpleItemStackWrapper setIgnoreAmount() {
        this.count = 1;
        return this;
    }

    @Override
    public class_1799 getStack() {
        class_1799 stack = super.getStack();
        if (!stack.method_7960()) {
            stack.method_7939(this.count);
        }
        return stack;
    }

    @Override
    public SimpleItemStackWrapper readFromString(String s) {
        String[] parts = s.split(",");
        super.readFromString(parts[0]);
        this.count = parts.length < 2 ? 1 : Integer.parseInt(parts[1]);
        return this;
    }

    @Override
    public String writeToString() {
        return super.writeToString() + (String)(this.count != 1 ? "," + this.count : "");
    }

    public static String usage() {
        return "Usage: registryname,<amount>. Leave empty for no item";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SimpleItemStackWrapper) {
            SimpleItemStackWrapper prop = (SimpleItemStackWrapper)obj;
            return prop.toString().equals(this.toString());
        }
        return false;
    }

    public static class Serializer
    implements JsonDeserializer<SimpleItemStackWrapper>,
    JsonSerializer<SimpleItemStackWrapper> {
        public JsonElement serialize(SimpleItemStackWrapper src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.add("item", (JsonElement)new JsonPrimitive(src.reg));
            if (src.count != 1) {
                obj.add("count", (JsonElement)new JsonPrimitive((Number)src.count));
            }
            return obj;
        }

        public SimpleItemStackWrapper deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            return new SimpleItemStackWrapper(obj.get("item").getAsString(), class_3518.method_15282((JsonObject)obj, (String)"count", (int)1));
        }
    }
}

