/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.api.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.class_3532;

public class AnimatedAction {
    private final float length;
    private final boolean shouldRunOut;
    private final String id;
    private final String clientIdentifier;
    private final float speed;
    private final int startTransition;
    private final int endTransition;
    private final Map<String, double[]> markerMap;
    private float offset;
    private float ticker;

    public AnimatedAction(double length, String id) {
        this(length, id, true);
    }

    public AnimatedAction(double length, String id, boolean seconds) {
        this((float)(seconds ? length * 20.0 : length), id, id, 0, 3, 1.0f, true, Map.of());
    }

    private AnimatedAction(float length, String id, String clientIdentifier, int startTransition, int endTransition, float speedMod, boolean shouldRunOut, Map<String, double[]> markerMap) {
        this.length = Math.max(1.0f, length);
        this.speed = speedMod;
        this.id = id;
        this.clientIdentifier = clientIdentifier;
        this.shouldRunOut = shouldRunOut;
        this.startTransition = Math.max(0, startTransition);
        this.endTransition = Math.max(0, endTransition);
        this.markerMap = markerMap;
    }

    public static AnimatedAction copyOf(AnimatedAction animatedAction, String id) {
        return new AnimatedAction(animatedAction.length, id, animatedAction.clientIdentifier, animatedAction.startTransition, animatedAction.endTransition, animatedAction.speed, animatedAction.shouldRunOut, animatedAction.markerMap);
    }

    public static Builder builder(double length, String id) {
        return AnimatedAction.builder(length, id, true);
    }

    public static Builder builder(double length, String id, boolean seconds) {
        return new Builder((float)(seconds ? length * 20.0 : length), id);
    }

    public AnimatedAction create() {
        return this.create(1.0f);
    }

    public AnimatedAction create(float speed) {
        return this.create(-1, -1, 0.0f, speed);
    }

    public AnimatedAction create(int startTransition, int endTransition, float offset, float speed) {
        AnimatedAction anim = new AnimatedAction(this.length, this.id, this.clientIdentifier, this.startTransition > 0 && startTransition == -1 ? this.startTransition : startTransition, this.endTransition > 0 && endTransition == -1 ? this.endTransition : endTransition, this.speed * speed, this.shouldRunOut, this.markerMap);
        anim.ticker = offset;
        anim.offset = offset;
        return anim;
    }

    public boolean tick() {
        return this.tick(1);
    }

    public boolean tick(int offset) {
        float f;
        this.ticker += this.speed;
        return f >= this.length + (float)this.startTransition + (float)offset && this.shouldRunOut;
    }

    public boolean done(int offset) {
        return this.ticker >= this.length + (float)this.startTransition + (float)offset;
    }

    public float getSpeed() {
        return this.speed;
    }

    public float progress(float partialTicks) {
        return this.progress(0.0f, this.length, partialTicks, 0);
    }

    public float progress(float start, float end, float partialTicks, int offset) {
        float tick = this.getTick(partialTicks) + (float)offset * this.speed;
        float length = end - start;
        return class_3532.method_15363((float)((tick - start) / length), (float)0.0f, (float)1.0f);
    }

    public float getStartTransitionProgress(float partialTicks) {
        if (this.startTransition == 0) {
            return 1.0f;
        }
        float tick = Math.max(0.0f, this.ticker - this.offset - 1.0f + partialTicks * this.speed);
        return class_3532.method_15363((float)(tick / (float)this.getStartTransition()), (float)0.0f, (float)1.0f);
    }

    public int getStartTransition() {
        return this.startTransition;
    }

    public int getEndTransitionTime() {
        return this.endTransition;
    }

    public float getTick(float partialTicks) {
        return Math.max(this.offset, this.ticker - (float)this.startTransition - 1.0f + partialTicks * this.speed);
    }

    public boolean isAt(double time) {
        return this.isAt(time, true);
    }

    public boolean isAt(double time, boolean seconds) {
        float tick = (float)(seconds ? time * 20.0 : time);
        float current = this.getTick(1.0f);
        float last = current - this.speed;
        return last < tick && current >= tick;
    }

    public boolean isPast(double time) {
        return this.isPast(time, true);
    }

    public boolean isPast(double time, boolean seconds) {
        float tick = (float)(seconds ? time * 20.0 : time);
        return this.getTick(1.0f) >= tick;
    }

    public boolean isBetween(double start, double end) {
        return this.isBetween(start, end, true);
    }

    public boolean isBetween(double start, double end, boolean seconds) {
        float startTick = (float)(seconds ? start * 20.0 : start);
        float endTick = (float)(seconds ? end * 20.0 : end);
        float tick = this.getTick(1.0f);
        return tick >= startTick && tick <= endTick;
    }

    public boolean isAt(String marker) {
        double[] times = this.markerMap.get(marker);
        if (times == null) {
            return false;
        }
        for (double time : times) {
            if (!this.isAt(time)) continue;
            return true;
        }
        return false;
    }

    public boolean isPast(String marker) {
        return this.isPast(marker, -1.0);
    }

    public boolean isPast(String marker, double max) {
        double[] times = this.markerMap.get(marker);
        if (times == null) {
            return false;
        }
        for (double time : times) {
            boolean matches;
            boolean bl = matches = max >= 0.0 ? this.isBetween(time, max) : this.isPast(time);
            if (!matches) continue;
            return true;
        }
        return false;
    }

    public float getLength() {
        return this.length;
    }

    public void reset() {
        this.ticker = 0.0f;
    }

    public String getID() {
        return this.id;
    }

    public double getMarker(String marker, int index) {
        double[] times = this.markerMap.get(marker);
        if (times == null || index >= times.length) {
            return -1.0;
        }
        return times[index];
    }

    public boolean is(AnimatedAction ... others) {
        for (AnimatedAction other : others) {
            if (other == null || !this.id.equals(other.id)) continue;
            return true;
        }
        return false;
    }

    public String getClientIdentifier() {
        return this.clientIdentifier;
    }

    public boolean shouldRunOut() {
        return this.shouldRunOut;
    }

    public String toString() {
        return String.format("ID: %s, length: %s, speed: %s", this.id, Float.valueOf(this.length), Float.valueOf(this.speed));
    }

    public boolean equals(Object o) {
        if (o instanceof AnimatedAction) {
            return this.toString().equals(o.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static class Builder {
        private final float length;
        private boolean shouldRunOut = true;
        private final String id;
        private String clientIdentifier;
        private float speed = 1.0f;
        private int startTransition;
        private int endTransition = 3;
        private final ImmutableMap.Builder<String, double[]> markerMap = new ImmutableMap.Builder();

        private Builder(float length, String id) {
            this.length = Math.max(1.0f, length);
            this.id = id;
            this.clientIdentifier = id;
        }

        public Builder withClientID(String id) {
            this.clientIdentifier = id;
            return this;
        }

        public Builder marker(String identifier, double ... time) {
            this.markerMap.put((Object)identifier, (Object)time);
            return this;
        }

        public Builder infinite() {
            this.shouldRunOut = false;
            return this;
        }

        public Builder speed(float speed) {
            this.speed = speed;
            return this;
        }

        public Builder withTransitionTime(int start, int end) {
            this.startTransition = start;
            this.endTransition = end;
            return this;
        }

        public AnimatedAction build() {
            return new AnimatedAction(this.length, this.id, this.clientIdentifier, this.startTransition, this.endTransition, this.speed, this.shouldRunOut, (Map<String, double[]>)this.markerMap.build());
        }
    }
}

