/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.gui.widget.list;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.flemmli97.tenshilib.client.gui.widget.list.SelectableEntry;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_6382;

public class SelectableListWidget
extends class_339 {
    private final class_327 font;
    private final List<SelectableEntry> entries;
    private final boolean[] selected;
    private int entryHeight;
    private int limit;
    private class_2960 background;
    private int paddingY = 4;
    private boolean canSelectMultiple;
    private int offset;
    private int hovered;
    private int lastSelect;

    public SelectableListWidget(int x, int y, int width, int height, class_327 font, List<SelectableEntry> entries) {
        super(x, y, width, height, (class_2561)new class_2585(""));
        this.font = font;
        this.entries = entries;
        this.selected = new boolean[this.entries.size()];
        Objects.requireNonNull(this.font);
        this.entryHeight = 9 + 3 + this.paddingY;
        this.entries.forEach(e -> e.updateDimensions(this.field_22758, this.entryHeight));
        this.limit = height / this.entryHeight;
    }

    public SelectableListWidget withPadding(int paddingY) {
        this.paddingY = paddingY;
        Objects.requireNonNull(this.font);
        this.entryHeight = 9 + 3 + this.paddingY;
        this.entries.forEach(e -> e.updateDimensions(this.field_22758, this.entryHeight));
        this.limit = this.field_22759 / this.entryHeight;
        return this;
    }

    public SelectableListWidget withTexture(class_2960 background) {
        this.background = background;
        return this;
    }

    public SelectableListWidget selectMultiple() {
        this.canSelectMultiple = true;
        return this;
    }

    public void method_25359(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.background != null) {
            RenderSystem.setShaderTexture((int)0, (class_2960)this.background);
            this.method_25302(poseStack, this.field_22760, this.field_22761, 0, 0, this.field_22758, this.field_22759);
        }
        this.hoverOver(this.field_22762 ? this.indexFromMouse(mouseY) : -1);
        for (int i = 0; i < this.entries.size(); ++i) {
            int idxx = (this.offset + i) % this.entries.size();
            if (i >= this.limit || idxx >= this.entries.size()) break;
            SelectableEntry entry = this.entries.get(idxx);
            boolean selected = this.selected[idxx];
            boolean hovered = this.hovered == idxx;
            int entryY = this.field_22761 + i * this.entryHeight;
            entry.render(this, poseStack, mouseX, mouseY, partialTick, this.field_22760, entryY, selected, hovered);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!super.method_25402(mouseX, mouseY, button)) {
            return false;
        }
        int i = this.indexFromMouse(mouseY);
        if (i != -1) {
            this.hoverOver(i);
            int entryX = this.field_22760;
            int entryY = this.field_22761 + i * this.entryHeight;
            double relMouseX = mouseX - (double)entryX;
            double relMouseY = mouseY - (double)entryY;
            if (!this.canSelectMultiple && this.lastSelect != this.hovered) {
                this.selected[this.lastSelect] = false;
                this.entries.get(this.lastSelect).unSelect();
            }
            this.lastSelect = this.hovered;
            boolean selected = this.selected[this.hovered];
            this.selected[this.hovered] = !this.selected[this.hovered];
            SelectableEntry entry = this.entries.get(this.hovered);
            if (selected && !this.selected[this.hovered]) {
                entry.unSelect();
            }
            if (!entry.onClick(relMouseX, relMouseY, this.selected[this.hovered])) {
                this.selected[this.hovered] = false;
            } else {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
            }
        }
        return true;
    }

    protected boolean method_25361(double mouseX, double mouseY) {
        return super.method_25361(mouseX, mouseY) && this.indexFromMouse(mouseY) != -1;
    }

    public void method_25354(class_1144 handler) {
    }

    private int indexFromMouse(double mouseY) {
        double relativePos = mouseY - (double)this.field_22761;
        if (relativePos < 0.0 || relativePos > (double)(this.field_22761 + this.field_22759)) {
            return -1;
        }
        int idx = (int)(relativePos / (double)this.entryHeight + (double)this.offset);
        if (idx >= this.entries.size() || idx >= this.offset + this.limit) {
            return -1;
        }
        return idx;
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        super.method_25401(mouseX, mouseY, delta);
        if (this.field_22762) {
            this.offset = class_3532.method_15340((int)((int)((double)this.offset - delta)), (int)0, (int)Math.max(this.entries.size() - this.limit, 0));
            return true;
        }
        return false;
    }

    public void method_37020(class_6382 output) {
    }

    public void hoverOver(int index) {
        this.hovered = index;
        if (this.hovered != -1) {
            if (this.hovered < 0) {
                this.hovered += this.entries.size();
            }
            if (this.hovered >= this.entries.size()) {
                this.hovered -= this.entries.size();
            }
        }
    }

    public class_327 getFont() {
        return this.font;
    }
}

