/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.gui.widget.list;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.tenshilib.client.gui.widget.TextureLocation;
import io.github.flemmli97.tenshilib.client.gui.widget.list.SelectableEntry;
import io.github.flemmli97.tenshilib.client.gui.widget.list.SelectableListWidget;
import java.util.function.BooleanSupplier;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4587;
import net.minecraft.class_5481;

public class SelectableText
implements SelectableEntry {
    private final class_2561 text;
    private int paddingX = 4;
    private SelectButton[] button;
    private Pair<TextureLocation, TextureLocation> entryTexture;
    private boolean selectable = true;
    private class_5481 sequence;
    private class_5481 blankSequence;
    private int lastWidth;
    private int width;
    private int height;

    public SelectableText(String text, class_124 ... chatFormattings) {
        this((class_2561)new class_2585(text).method_27695(chatFormattings));
    }

    public SelectableText(class_2561 text) {
        this.text = text;
    }

    public SelectableText padding(int padding) {
        this.paddingX = padding;
        return this;
    }

    public SelectableText with(SelectButton ... clickHandler) {
        return this.with(false, clickHandler);
    }

    public SelectableText with(boolean canSelect, SelectButton ... clickHandler) {
        this.selectable = canSelect;
        this.button = clickHandler;
        return this;
    }

    public SelectableText withTexture(class_2960 background, Pair<TextureLocation, TextureLocation> entryTexture) {
        this.entryTexture = entryTexture;
        return this;
    }

    public SelectableText noSelect() {
        this.selectable = false;
        return this;
    }

    @Override
    public void updateDimensions(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public void render(SelectableListWidget widget, class_4587 poseStack, int mouseX, int mouseY, float partialTick, int x, int y, boolean selected, boolean hovered) {
        if (this.entryTexture != null) {
            TextureLocation location = hovered ? (TextureLocation)this.entryTexture.getSecond() : (TextureLocation)this.entryTexture.getFirst();
            RenderSystem.setShaderTexture((int)0, (class_2960)location.texture());
            widget.method_25302(poseStack, x, y, location.uOffset(), location.vOffset(), this.width, this.height);
        } else if (selected || hovered) {
            class_332.method_25294((class_4587)poseStack, (int)x, (int)y, (int)(x + this.width), (int)(y + this.height), (int)-1609560048);
        }
        int textWidth = this.width - this.paddingX;
        if (this.getButtons() != null && this.getButtons().length > 0) {
            int skipped = 0;
            for (int idx = 0; idx < this.getButtons().length; ++idx) {
                SelectButton btn = this.getButtons()[this.getButtons().length - 1 - idx];
                if (!btn.shouldRender().getAsBoolean()) {
                    ++skipped;
                    continue;
                }
                int[] xY = this.getButtonStart(idx - skipped);
                int bX = xY[0] + x;
                int bY = xY[1] + y;
                textWidth = xY[0] - 2;
                RenderSystem.setShaderTexture((int)0, (class_2960)btn.texture());
                boolean over = mouseX >= bX && mouseY >= bY && mouseX < bX + 12 && mouseY < bY + 12;
                widget.method_25302(poseStack, bX, bY, btn.uOffset(), btn.vOffset() + (over ? 12 : 0), 12, 12);
            }
        }
        widget.getFont().method_27528(poseStack, this.getText(widget.getFont(), textWidth - this.paddingX, selected || hovered), (float)(x + this.paddingX), (float)(y + (int)(0.5 * (double)this.height - 3.5)), selected ? class_124.field_1076.method_532() : (hovered ? class_124.field_1054.method_532() : 0xFFFFFF));
    }

    @Override
    public boolean onClick(double relativeMouseX, double relativeMouseY, boolean selected) {
        if (this.getButtons() != null && this.getButtons().length > 0) {
            int skipped = 0;
            for (int idx = 0; idx < this.getButtons().length; ++idx) {
                int[] xY;
                boolean over;
                SelectButton btn = this.getButtons()[this.getButtons().length - 1 - idx];
                if (!btn.shouldRender().getAsBoolean()) {
                    ++skipped;
                }
                boolean bl = over = relativeMouseX >= (double)(xY = this.getButtonStart(idx - skipped))[0] && relativeMouseY >= (double)xY[1] && relativeMouseX < (double)(xY[0] + 12) && relativeMouseY < (double)(xY[1] + 12);
                if (!over) continue;
                btn.onClick().run();
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                return false;
            }
        }
        return this.selectable;
    }

    public class_5481 getText(class_327 font, int width, boolean highlight) {
        if (this.sequence == null || this.lastWidth != width) {
            this.sequence = SelectableEntry.dottedWith(font, this.text, width, false);
            this.blankSequence = SelectableEntry.dottedWith(font, this.text, width, true);
            this.lastWidth = width;
        }
        return highlight ? this.blankSequence : this.sequence;
    }

    public SelectButton[] getButtons() {
        return this.button;
    }

    private int[] getButtonStart(int position) {
        int btnX = this.width - this.paddingX - 12 - position * 14;
        int btnY = (int)(0.5 * (double)this.height) - 6;
        return new int[]{btnX, btnY};
    }

    public record SelectButton(class_2960 texture, int uOffset, int vOffset, Runnable onClick, BooleanSupplier shouldRender) {
        private static final BooleanSupplier ALWAYS = () -> true;

        public SelectButton(class_2960 texture, int uOffset, int vOffset, Runnable onClick) {
            this(texture, uOffset, vOffset, onClick, ALWAYS);
        }
    }
}

