/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.client.model.AnimationValue;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartHandler;
import io.github.flemmli97.tenshilib.common.utils.ArrayUtils;
import io.github.flemmli97.tenshilib.common.utils.mathParser.Expression;
import io.github.flemmli97.tenshilib.common.utils.mathParser.VariableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class BlockBenchAnimations {
    private final Map<String, Animation> animations = new HashMap<String, Animation>();
    private final VariableMap variables = new VariableMap();

    public void reload(JsonObject obj) {
        this.animations.clear();
        if (obj.has("animations")) {
            for (Map.Entry anims : obj.getAsJsonObject("animations").entrySet()) {
                if (!(anims.getValue() instanceof JsonObject)) continue;
                this.animations.put((String)anims.getKey(), new Animation((JsonObject)anims.getValue()));
            }
        }
    }

    public void doAnimation(ExtendedModel model, String name, int ticker, float partialTicks) {
        this.doAnimation(model, name, ticker, partialTicks, 1.0f);
    }

    public void doAnimation(ExtendedModel model, String name, int ticker, float partialTicks, float interpolation) {
        this.doAnimation(model, name, ticker, partialTicks, interpolation, false, false);
    }

    public boolean doAnimation(ExtendedModel model, String name, int ticker, float partialTicks, float interpolation, boolean mirror, boolean add) {
        return this.doAnimation(model, name, Math.max((float)(ticker - 1) + partialTicks, 0.0f), interpolation, mirror, add);
    }

    public boolean doAnimation(ExtendedModel model, AnimationHandler<?> handler, float partialTicks) {
        return this.doAnimation(model, handler, partialTicks, false);
    }

    public boolean doAnimation(ExtendedModel model, AnimationHandler<?> handler, float partialTicks, boolean mirror) {
        return this.doAnimation(model, handler, partialTicks, a -> mirror, null);
    }

    public boolean doAnimation(ExtendedModel model, AnimationHandler<?> handler, float partialTicks, @Nullable Predicate<AnimatedAction> mirror, @Nullable Function<AnimatedAction, String> animationID) {
        AnimatedAction current = handler.getAnimation();
        AnimatedAction last = handler.getLastAnimation();
        float interpolationLast = handler.getLastTransitionProgress(partialTicks);
        float interpolation = handler.getCurrentTransitionProgress(partialTicks);
        boolean changed = false;
        if (last != null && interpolationLast > 0.0f) {
            changed = this.doAnimation(model, animationID != null ? animationID.apply(last) : last.getClientIdentifier(), last.getTick(partialTicks), interpolationLast, mirror != null && mirror.test(last), false);
        }
        if (current != null && this.doAnimation(model, animationID != null ? animationID.apply(current) : current.getClientIdentifier(), current.getTick(partialTicks), interpolation, mirror != null && mirror.test(last), false) && !changed) {
            changed = true;
        }
        return changed;
    }

    public boolean doAnimation(ExtendedModel model, String name, float tick, float interpolation, boolean mirror, boolean add) {
        Animation animation = this.animations.get(name);
        if (animation != null && interpolation != 0.0f) {
            animation.animate(model, tick, class_3532.method_15363((float)interpolation, (float)0.0f, (float)1.0f), this.variables, mirror, add);
            return true;
        }
        return false;
    }

    public float animationLength(String name) {
        Animation animation = this.animations.get(name);
        return animation != null ? animation.length : 0.0f;
    }

    public void setVariable(String variable, DoubleSupplier value) {
        this.variables.setVariable(variable, value);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Animation: ");
        this.animations.forEach((key, anim) -> builder.append(String.format("\n%s = %s", key, anim)));
        return builder.toString();
    }

    public static class Animation {
        public final float length;
        public final boolean loop;
        private final List<AnimationComponent> components = new ArrayList<AnimationComponent>();

        public Animation(JsonObject json) {
            this.length = class_3518.method_15277((JsonObject)json, (String)"animation_length", (float)0.0f) * 20.0f;
            this.loop = class_3518.method_15258((JsonObject)json, (String)"loop", (boolean)false);
            JsonObject components = class_3518.method_15281((JsonObject)json, (String)"bones", (JsonObject)new JsonObject());
            components.entrySet().forEach(e -> this.components.add(new AnimationComponent((String)e.getKey(), ((JsonElement)e.getValue()).getAsJsonObject())));
        }

        public void animate(ExtendedModel model, float tick, float interpolation, VariableMap vars, boolean mirror, boolean add) {
            if (this.loop && this.length > 0.0f) {
                tick %= this.length;
            }
            for (AnimationComponent comp : this.components) {
                comp.animate(model, tick, vars, interpolation, mirror, add);
            }
        }

        public String toString() {
            return String.format("\nloop: %b, length: %s, components: %s", this.loop, Float.valueOf(this.length), this.components);
        }
    }

    public static class AnimationComponent {
        private final String name;
        private final String mirroredName;
        private AnimationValue[] rotations;
        private AnimationValue[] positions;
        private AnimationValue[] scales;

        public AnimationComponent(String name, JsonObject obj) {
            JsonArray arr2;
            Object v;
            this.name = name;
            this.mirroredName = name.toLowerCase(Locale.ROOT).contains("right") ? name.replace("Right", "Left").replace("right", "left") : name.replace("Left", "Right").replace("left", "right");
            int i = 0;
            if (obj.has("position")) {
                JsonObject position = this.tryGet(obj, "position");
                this.positions = new AnimationValue[position.size()];
                for (Map.Entry e : position.entrySet()) {
                    v = e.getValue();
                    if (!(v instanceof JsonArray)) continue;
                    arr2 = (JsonArray)v;
                    this.positions[i] = new AnimationValue(Float.parseFloat((String)e.getKey()) * 20.0f, Expression.of(arr2.get(0).getAsString()), Expression.of(arr2.get(1).getAsString()), Expression.of(arr2.get(2).getAsString()));
                    ++i;
                }
                Arrays.sort(this.positions, Comparator.comparingDouble(arr -> arr.startTick));
            }
            if (obj.has("rotation")) {
                JsonObject rotation = this.tryGet(obj, "rotation");
                this.rotations = new AnimationValue[rotation.size()];
                i = 0;
                for (Map.Entry e : rotation.entrySet()) {
                    v = e.getValue();
                    if (!(v instanceof JsonArray)) continue;
                    arr2 = (JsonArray)v;
                    this.rotations[i] = new AnimationValue(Float.parseFloat((String)e.getKey()) * 20.0f, Expression.of(arr2.get(0).getAsString()), Expression.of(arr2.get(1).getAsString()), Expression.of(arr2.get(2).getAsString()));
                    ++i;
                }
                Arrays.sort(this.rotations, Comparator.comparingDouble(arr -> arr.startTick));
            }
            if (obj.has("scale")) {
                JsonObject scale = this.tryGet(obj, "scale");
                this.scales = new AnimationValue[scale.size()];
                i = 0;
                for (Map.Entry e : scale.entrySet()) {
                    v = e.getValue();
                    if (!(v instanceof JsonArray)) continue;
                    arr2 = (JsonArray)v;
                    this.scales[i] = new AnimationValue(Float.parseFloat((String)e.getKey()) * 20.0f, Expression.of(arr2.get(0).getAsString()), Expression.of(arr2.get(1).getAsString()), Expression.of(arr2.get(2).getAsString()));
                    ++i;
                }
                Arrays.sort(this.scales, Comparator.comparingDouble(arr -> arr.startTick));
            }
        }

        private JsonObject tryGet(JsonObject obj, String name) {
            JsonElement el = obj.get(name);
            if (el.isJsonObject()) {
                return (JsonObject)el;
            }
            if (el.isJsonArray()) {
                JsonObject val = new JsonObject();
                val.add("0", el);
                return val;
            }
            if (el.isJsonPrimitive()) {
                JsonObject val = new JsonObject();
                JsonArray arr = new JsonArray();
                arr.add((Number)el.getAsDouble());
                arr.add((Number)el.getAsDouble());
                arr.add((Number)el.getAsDouble());
                val.add("0", (JsonElement)arr);
                return val;
            }
            return null;
        }

        public void animate(ExtendedModel model, float actualTick, VariableMap vars, float interpolation, boolean mirror, boolean add) {
            float dZ;
            float dY;
            float dX;
            float z;
            float y;
            float x;
            float prog;
            float dZ2;
            float dY2;
            float dX2;
            float z2;
            float y2;
            float x2;
            ModelPartHandler.ModelPartExtended mirrored;
            ModelPartHandler.ModelPartExtended modelPart = model.getHandler().getPartNullable(this.name);
            if (mirror && (mirrored = model.getHandler().getPartNullable(this.mirroredName)) != null) {
                modelPart = mirrored;
            }
            if (modelPart == null) {
                return;
            }
            vars.setVariable("query.anim_time", () -> (double)actualTick * 0.05);
            float mirrorMult = mirror ? -1 : 1;
            if (this.positions != null) {
                if (this.positions.length == 1) {
                    x2 = this.positions[0].getXVal(vars) * mirrorMult;
                    y2 = this.positions[0].getYVal(vars);
                    z2 = this.positions[0].getZVal(vars);
                    dX2 = add ? 0.0f : modelPart.x - modelPart.getDefaultPose().x;
                    modelPart.x += (x2 - dX2) * interpolation;
                    dY2 = add ? 0.0f : modelPart.y - modelPart.getDefaultPose().y;
                    modelPart.y -= (y2 + dY2) * interpolation;
                    dZ2 = add ? 0.0f : modelPart.z - modelPart.getDefaultPose().z;
                    modelPart.z += (z2 - dZ2) * interpolation;
                } else {
                    int id = 1;
                    AnimationValue pos = this.positions[id];
                    while (pos.startTick < actualTick && ++id < this.positions.length) {
                        pos = this.positions[id];
                    }
                    AnimationValue posPrev = this.positions[id - 1];
                    prog = class_3532.method_15363((float)((actualTick - posPrev.startTick) / (pos.startTick - posPrev.startTick)), (float)0.0f, (float)1.0f);
                    x = this.interpolate(posPrev.getXVal(vars), pos.getXVal(vars), prog) * mirrorMult;
                    y = this.interpolate(posPrev.getYVal(vars), pos.getYVal(vars), prog);
                    z = this.interpolate(posPrev.getZVal(vars), pos.getZVal(vars), prog);
                    dX = add ? 0.0f : modelPart.x - modelPart.getDefaultPose().x;
                    modelPart.x += (x - dX) * interpolation;
                    dY = add ? 0.0f : modelPart.y - modelPart.getDefaultPose().y;
                    modelPart.y -= (y + dY) * interpolation;
                    dZ = add ? 0.0f : modelPart.z - modelPart.getDefaultPose().z;
                    modelPart.z += (z - dZ) * interpolation;
                }
            }
            if (this.rotations != null) {
                if (this.rotations.length == 1) {
                    x2 = AnimationComponent.wrapDegrees(this.rotations[0].getXVal(vars));
                    y2 = AnimationComponent.wrapDegrees(this.rotations[0].getYVal(vars)) * mirrorMult;
                    z2 = AnimationComponent.wrapDegrees(this.rotations[0].getZVal(vars)) * mirrorMult;
                    dX2 = add ? 0.0f : AnimationComponent.wrapDegrees(57.295776f * (modelPart.xRot - modelPart.getDefaultPose().xRot));
                    modelPart.xRot += (float)Math.PI / 180 * AnimationComponent.degreeDiff(dX2, x2) * interpolation;
                    dY2 = add ? 0.0f : AnimationComponent.wrapDegrees(57.295776f * (modelPart.yRot - modelPart.getDefaultPose().yRot));
                    modelPart.yRot += (float)Math.PI / 180 * AnimationComponent.degreeDiff(dY2, y2) * interpolation;
                    dZ2 = add ? 0.0f : AnimationComponent.wrapDegrees(57.295776f * (modelPart.zRot - modelPart.getDefaultPose().zRot));
                    modelPart.zRot += (float)Math.PI / 180 * AnimationComponent.degreeDiff(dZ2, z2) * interpolation;
                } else {
                    int id = 1;
                    AnimationValue rot = this.rotations[id];
                    while (rot.startTick < actualTick && ++id < this.rotations.length) {
                        rot = this.rotations[id];
                    }
                    AnimationValue rotPrev = this.rotations[id - 1];
                    prog = class_3532.method_15363((float)((actualTick - rotPrev.startTick) / (rot.startTick - rotPrev.startTick)), (float)0.0f, (float)1.0f);
                    x = add ? 0.0f : AnimationComponent.wrapDegrees(this.interpolate(rotPrev.getXVal(vars), rot.getXVal(vars), prog));
                    y = add ? 0.0f : AnimationComponent.wrapDegrees(this.interpolate(rotPrev.getYVal(vars), rot.getYVal(vars), prog)) * mirrorMult;
                    z = add ? 0.0f : AnimationComponent.wrapDegrees(this.interpolate(rotPrev.getZVal(vars), rot.getZVal(vars), prog)) * mirrorMult;
                    dX = AnimationComponent.wrapDegrees(57.295776f * (modelPart.xRot - modelPart.getDefaultPose().xRot));
                    modelPart.xRot += (float)Math.PI / 180 * AnimationComponent.degreeDiff(dX, x) * interpolation;
                    dY = AnimationComponent.wrapDegrees(57.295776f * (modelPart.yRot - modelPart.getDefaultPose().yRot));
                    modelPart.yRot += (float)Math.PI / 180 * AnimationComponent.degreeDiff(dY, y) * interpolation;
                    dZ = AnimationComponent.wrapDegrees(57.295776f * (modelPart.zRot - modelPart.getDefaultPose().zRot));
                    modelPart.zRot += (float)Math.PI / 180 * AnimationComponent.degreeDiff(dZ, z) * interpolation;
                }
            }
            if (this.scales != null) {
                if (this.scales.length == 1) {
                    float x3 = this.scales[0].getXVal(vars) - modelPart.getDefaultPose().xScale;
                    float y3 = this.scales[0].getYVal(vars) - modelPart.getDefaultPose().yScale;
                    float z3 = this.scales[0].getZVal(vars) - modelPart.getDefaultPose().zScale;
                    dX2 = add ? 0.0f : modelPart.xScale - modelPart.getDefaultPose().xScale;
                    modelPart.xScale += (x3 - dX2) * interpolation;
                    dY2 = add ? 0.0f : modelPart.yScale - modelPart.getDefaultPose().yScale;
                    modelPart.yScale += (y3 - dY2) * interpolation;
                    dZ2 = add ? 0.0f : modelPart.zScale - modelPart.getDefaultPose().zScale;
                    modelPart.zScale += (z3 - dZ2) * interpolation;
                } else {
                    int id = 1;
                    AnimationValue scale = this.scales[id];
                    while (scale.startTick < actualTick && ++id < this.scales.length) {
                        scale = this.scales[id];
                    }
                    AnimationValue scalePrev = this.scales[id - 1];
                    prog = class_3532.method_15363((float)((actualTick - scalePrev.startTick) / (scale.startTick - scalePrev.startTick)), (float)0.0f, (float)1.0f);
                    x = this.interpolate(scalePrev.getXVal(vars), scale.getXVal(vars), prog) - modelPart.getDefaultPose().xScale;
                    y = this.interpolate(scalePrev.getYVal(vars), scale.getYVal(vars), prog) - modelPart.getDefaultPose().yScale;
                    z = this.interpolate(scalePrev.getZVal(vars), scale.getZVal(vars), prog) - modelPart.getDefaultPose().zScale;
                    dX = add ? 0.0f : modelPart.xScale - modelPart.getDefaultPose().xScale;
                    modelPart.xScale += (x - dX) * interpolation;
                    dY = add ? 0.0f : modelPart.yScale - modelPart.getDefaultPose().yScale;
                    modelPart.yScale += (y - dY) * interpolation;
                    dZ = add ? 0.0f : modelPart.zScale - modelPart.getDefaultPose().zScale;
                    modelPart.zScale += (z - dZ) * interpolation;
                }
            }
        }

        public static float wrapDegrees(float value) {
            float f = value % 360.0f;
            if (f < 0.0f) {
                f += 360.0f;
            }
            return f;
        }

        public static float degreeDiff(float current, float target) {
            float diff = target - current;
            if (diff > 180.0f) {
                diff -= 360.0f;
            } else if (diff < -180.0f) {
                diff += 360.0f;
            }
            return diff;
        }

        private float interpolate(float start, float end, float progress) {
            return start + (end - start) * progress;
        }

        public String toString() {
            return String.format("%s rot: {%s}; pos: {%s}; scale: {%s}", this.name, ArrayUtils.arrayToString(this.rotations), ArrayUtils.arrayToString(this.positions), ArrayUtils.arrayToString(this.scales));
        }
    }
}

