/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.model;

import io.github.flemmli97.tenshilib.client.model.PoseExtended;
import io.github.flemmli97.tenshilib.mixin.ModelPartAccessor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.class_1160;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5603;
import net.minecraft.class_630;

public class ModelPartHandler {
    private final ModelPartExtended mainPart;
    private final Map<String, ModelPartExtended> childrenToName = new HashMap<String, ModelPartExtended>();

    public ModelPartHandler(class_630 main, String mainID) {
        this.mainPart = new ModelPartExtended(main);
        this.childrenToName.put(mainID, this.mainPart);
        this.mainPart.getMappedParts(this.childrenToName);
    }

    public ModelPartHandler(class_630 root) {
        this.mainPart = new ModelPartExtended(root);
        this.childrenToName.put("root", this.mainPart);
        this.mainPart.getMappedParts(this.childrenToName);
    }

    public ModelPartExtended getPart(String name) {
        ModelPartExtended modelPart = this.childrenToName.get(name);
        if (modelPart == null) {
            throw new NoSuchElementException("Can't find part " + name);
        }
        return modelPart;
    }

    protected ModelPartExtended getPartNullable(String name) {
        return this.childrenToName.get(name);
    }

    public void resetPoses() {
        this.mainPart.resetAll();
    }

    public ModelPartExtended getMainPart() {
        return this.mainPart;
    }

    public static class ModelPartExtended {
        public float x;
        public float y;
        public float z;
        public float xRot;
        public float yRot;
        public float zRot;
        public float xScale = 1.0f;
        public float yScale = 1.0f;
        public float zScale = 1.0f;
        public boolean visible = true;
        private final List<class_630.class_628> cubes;
        private final Map<String, ModelPartExtended> children;
        private PoseExtended defaultPose;

        public ModelPartExtended(class_630 orig) {
            this.cubes = ((ModelPartAccessor)orig).getCubes();
            this.children = ((ModelPartAccessor)orig).getChildren().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new ModelPartExtended((class_630)e.getValue())));
            this.updateDefaultPose(new PoseExtended(orig.method_32084()));
        }

        public class_5603 storePose() {
            return class_5603.method_32091((float)this.x, (float)this.y, (float)this.z, (float)this.xRot, (float)this.yRot, (float)this.zRot);
        }

        public void loadPose(class_5603 partPose) {
            this.setPos(partPose.field_27702, partPose.field_27703, partPose.field_27704);
            this.setRotation(partPose.field_27705, partPose.field_27706, partPose.field_27707);
        }

        public void loadPose(PoseExtended pose) {
            this.setPos(pose.x, pose.y, pose.z);
            this.setRotation(pose.xRot, pose.yRot, pose.zRot);
            this.setScale(pose.xScale, pose.yScale, pose.zScale);
        }

        public void loadPoseRecursive(PoseExtended pose) {
            this.setPos(pose.x, pose.y, pose.z);
            this.setRotation(pose.xRot, pose.yRot, pose.zRot);
            this.setScale(pose.xScale, pose.yScale, pose.zScale);
            this.children.values().forEach(m -> m.loadPoseRecursive(pose));
        }

        public ModelPartExtended getChild(String string) {
            ModelPartExtended modelPart = this.children.get(string);
            if (modelPart == null) {
                throw new NoSuchElementException("Can't find part " + string);
            }
            return modelPart;
        }

        public void setPos(float f, float g, float h) {
            this.x = f;
            this.y = g;
            this.z = h;
        }

        public void setRotation(float f, float g, float h) {
            this.xRot = f;
            this.yRot = g;
            this.zRot = h;
        }

        public void setScale(float x, float y, float z) {
            this.xScale = x;
            this.yScale = y;
            this.zScale = z;
        }

        public void reset() {
            this.loadPose(this.getDefaultPose());
        }

        public void resetAll() {
            this.reset();
            this.children.values().forEach(ModelPartExtended::resetAll);
        }

        public void setAllVisible(boolean visible) {
            this.visible = visible;
            this.children.values().forEach(m -> m.setAllVisible(visible));
        }

        public void render(class_4587 poseStack, class_4588 vertexConsumer, int i, int j) {
            this.render(poseStack, vertexConsumer, i, j, 1.0f, 1.0f, 1.0f, 1.0f);
        }

        public void render(class_4587 poseStack, class_4588 vertexConsumer, int i, int j, float f, float g, float h, float k) {
            if (!(!this.visible || this.xScale == 0.0f || this.yScale == 0.0f || this.zScale == 0.0f || this.cubes.isEmpty() && this.children.isEmpty())) {
                poseStack.method_22903();
                this.translateAndRotate(poseStack);
                this.compile(poseStack.method_23760(), vertexConsumer, i, j, f, g, h, k);
                for (ModelPartExtended modelPart : this.children.values()) {
                    modelPart.render(poseStack, vertexConsumer, i, j, f, g, h, k);
                }
                poseStack.method_22909();
            }
        }

        public void visit(class_4587 poseStack, class_630.class_6229 visitor) {
            this.visit(poseStack, visitor, "");
        }

        private void visit(class_4587 poseStack, class_630.class_6229 visitor, String string) {
            if (!this.cubes.isEmpty() || !this.children.isEmpty()) {
                poseStack.method_22903();
                this.translateAndRotate(poseStack);
                class_4587.class_4665 pose = poseStack.method_23760();
                for (int i = 0; i < this.cubes.size(); ++i) {
                    visitor.method_35748(pose, string, i, this.cubes.get(i));
                }
                String string2 = string + "/";
                this.children.forEach((string2x, modelPart) -> modelPart.visit(poseStack, visitor, string2 + string2x));
                poseStack.method_22909();
            }
        }

        public void translateAndRotate(class_4587 poseStack) {
            poseStack.method_22904((double)(this.x / 16.0f), (double)(this.y / 16.0f), (double)(this.z / 16.0f));
            if (this.zRot != 0.0f) {
                poseStack.method_22907(class_1160.field_20707.method_23626(this.zRot));
            }
            if (this.yRot != 0.0f) {
                poseStack.method_22907(class_1160.field_20705.method_23626(this.yRot));
            }
            if (this.xRot != 0.0f) {
                poseStack.method_22907(class_1160.field_20703.method_23626(this.xRot));
            }
            if (this.xScale != 1.0f || this.yScale != 1.0f || this.zScale != 1.0f) {
                poseStack.method_22905(this.xScale, this.yScale, this.zScale);
            }
        }

        private void compile(class_4587.class_4665 pose, class_4588 vertexConsumer, int i, int j, float f, float g, float h, float k) {
            for (class_630.class_628 cube : this.cubes) {
                cube.method_32089(pose, vertexConsumer, i, j, f, g, h, k);
            }
        }

        public class_630.class_628 getRandomCube(Random random) {
            return this.cubes.get(random.nextInt(this.cubes.size()));
        }

        public boolean isEmpty() {
            return this.cubes.isEmpty();
        }

        public void getMappedParts(Map<String, ModelPartExtended> map) {
            this.children.forEach((key, value) -> {
                map.put((String)key, (ModelPartExtended)value);
                value.getMappedParts(map);
            });
        }

        public PoseExtended getDefaultPose() {
            return this.defaultPose;
        }

        public void updateDefaultPose(PoseExtended defaultPose) {
            this.defaultPose = defaultPose;
        }
    }
}

