/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.render;

import io.github.flemmli97.tenshilib.api.entity.IBeamEntity;
import io.github.flemmli97.tenshilib.common.utils.MathUtils;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5498;
import net.minecraft.class_5617;
import net.minecraft.class_897;

public abstract class RenderBeam<T extends class_1297>
extends class_897<T> {
    protected final float radius;
    private int red = 255;
    private int green = 255;
    private int blue = 255;
    protected int alpha = 255;
    protected final float[][] points;
    protected final float[][] pointsGlow;

    public RenderBeam(class_5617.class_5618 ctx, float width) {
        this(ctx, width, 4);
    }

    public RenderBeam(class_5617.class_5618 ctx, float width, int polygon) {
        this(ctx, width, width - 0.25f, polygon);
    }

    public RenderBeam(class_5617.class_5618 ctx, float glowWidth, float innerWidth, int polygon) {
        super(ctx);
        this.radius = glowWidth;
        this.points = MathUtils.createRegularPolygonPointsF(polygon, innerWidth);
        this.pointsGlow = MathUtils.createRegularPolygonPointsF(polygon, glowWidth);
    }

    public void setColor(int hexColor) {
        this.setColorAndAlpha(hexColor >> 16 & 0xFF, hexColor >> 8 & 0xFF, hexColor & 0xFF, hexColor >> 24 & 0xFF);
    }

    public void setColor(int red, int green, int blue) {
        this.red = red;
        this.blue = blue;
        this.green = green;
    }

    public void setColorAndAlpha(int red, int green, int blue, int alpha) {
        this.red = red;
        this.blue = blue;
        this.green = green;
        this.alpha = alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public void method_3936(T entity, float entityYaw, float partialTicks, class_4587 matrixStack, class_4597 buffer, int packedLight) {
        boolean playerView;
        ((IBeamEntity)entity).updateYawPitch();
        float dist = (float)((IBeamEntity)entity).hitVec().method_1022(((IBeamEntity)entity).startVec());
        float width = this.widthFunc(entity);
        matrixStack.method_22903();
        matrixStack.method_22907(class_1160.field_20704.method_23214(class_3532.method_16439((float)partialTicks, (float)((class_1297)entity).field_5982, (float)entity.method_36454()) + 90.0f));
        matrixStack.method_22907(class_1160.field_20707.method_23214(-class_3532.method_16439((float)partialTicks, (float)((class_1297)entity).field_6004, (float)entity.method_36455())));
        boolean bl = playerView = !((IBeamEntity)entity).firstPerson3d(class_310.method_1551().field_1719) && class_310.method_1551().field_1690.method_31044() != class_5498.field_26665;
        if (playerView) {
            matrixStack.method_22907(class_1160.field_20703.method_23214(30.0f));
            matrixStack.method_22904(0.0, -0.1, 0.0);
            matrixStack.method_22907(class_1160.field_20703.method_23214(60.0f));
        } else {
            matrixStack.method_22905(1.0f, width, width);
        }
        this.renderBeam(entity, dist, width, matrixStack, buffer, packedLight, playerView);
        matrixStack.method_22909();
        super.method_3936(entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    protected void renderBeam(T entity, float dist, float width, class_4587 matrixStack, class_4597 buffer, int packedLight, boolean playerView) {
        int d;
        float[] fArray;
        int alphaPre;
        float startLength = 0.0f;
        if (this.startTexture(entity) != null) {
            startLength = Math.min(this.startTexture(entity).size(), dist * 0.5f);
            if (playerView) {
                this.renderBeam(matrixStack, buffer.getBuffer(this.getRenderLayer(entity, this.startTexture(entity).res())), 0.0f, startLength, width, -width, this.currentAnimation(entity, BeamPart.START), this.animationFrames(BeamPart.START), packedLight, true);
            } else {
                this.render3dBeam(matrixStack, buffer.getBuffer(this.getRenderLayer(entity, this.startTexture(entity).res())), this.points, 0.0f, startLength, this.currentAnimation(entity, BeamPart.MIDDLE), this.animationFrames(BeamPart.MIDDLE), packedLight);
                alphaPre = this.alpha;
                this.setAlpha(this.glowAlpha(entity));
                this.render3dBeam(matrixStack, buffer.getBuffer(this.getGlowingRenderLayer(entity, this.startTexture(entity).res())), this.pointsGlow, 0.0f, startLength, this.currentAnimation(entity, BeamPart.MIDDLE), this.animationFrames(BeamPart.MIDDLE), packedLight);
                this.setAlpha(alphaPre);
            }
        }
        float length = dist - startLength;
        if (this.endTexture(entity) != null) {
            float endLength = Math.min(this.endTexture(entity).size(), length);
            length -= endLength;
            if (playerView) {
                this.renderBeam(matrixStack, buffer.getBuffer(this.getRenderLayer(entity, this.endTexture(entity).res())), startLength + length, endLength, width, -width, this.currentAnimation(entity, BeamPart.END), this.animationFrames(BeamPart.END), packedLight, true);
            } else {
                this.render3dBeam(matrixStack, buffer.getBuffer(this.getRenderLayer(entity, this.startTexture(entity).res())), this.points, startLength + length, endLength, this.currentAnimation(entity, BeamPart.MIDDLE), this.animationFrames(BeamPart.MIDDLE), packedLight);
                alphaPre = this.alpha;
                this.setAlpha(this.glowAlpha(entity));
                this.render3dBeam(matrixStack, buffer.getBuffer(this.getGlowingRenderLayer(entity, this.startTexture(entity).res())), this.pointsGlow, startLength + length, endLength, this.currentAnimation(entity, BeamPart.MIDDLE), this.animationFrames(BeamPart.MIDDLE), packedLight);
                this.setAlpha(alphaPre);
            }
        }
        class_4588 builder = buffer.getBuffer(this.getRenderLayer(entity, this.method_3931((class_1297)entity)));
        if (this.segmentLength() == 0.0f) {
            float[] fArray2 = new float[1];
            fArray = fArray2;
            fArray2[0] = length;
        } else {
            fArray = this.split(length);
        }
        float[] segments = fArray;
        for (d = 0; d < segments.length; ++d) {
            if (playerView) {
                this.renderBeam(matrixStack, builder, startLength + (float)d * this.segmentLength(), segments[d], width, -width, this.currentAnimation(entity, BeamPart.MIDDLE), this.animationFrames(BeamPart.MIDDLE), packedLight, true);
                continue;
            }
            this.render3dBeam(matrixStack, builder, this.points, startLength + (float)d * this.segmentLength(), segments[d], this.currentAnimation(entity, BeamPart.MIDDLE), this.animationFrames(BeamPart.MIDDLE), packedLight);
        }
        if (!playerView) {
            alphaPre = this.alpha;
            this.setAlpha(this.glowAlpha(entity));
            builder = buffer.getBuffer(this.getGlowingRenderLayer(entity, this.method_3931((class_1297)entity)));
            for (d = 0; d < segments.length; ++d) {
                this.render3dBeam(matrixStack, builder, this.pointsGlow, startLength + (float)d * this.segmentLength(), segments[d], this.currentAnimation(entity, BeamPart.MIDDLE), this.animationFrames(BeamPart.MIDDLE), packedLight);
            }
            this.setAlpha(alphaPre);
        }
    }

    protected void render3dBeam(class_4587 stack, class_4588 build, float[][] corners, float minX, float length, int animationFrame, float maxFrames, int light) {
        class_1159 matrix4f = stack.method_23760().method_23761();
        class_4581 mat3f = stack.method_23760().method_23762();
        float vMin = (float)(animationFrame - 1) / maxFrames;
        float vMax = (float)animationFrame / maxFrames;
        for (int i = 0; i < corners.length; ++i) {
            float[] point = corners[i];
            float[] next = i + 1 < corners.length ? corners[i + 1] : corners[0];
            this.buildQuad(matrix4f, mat3f, build, minX, length, point[0], next[0], point[1], next[1], vMin, vMax, light, true);
        }
    }

    protected void renderBeam(class_4587 stack, class_4588 build, float minX, float length, float minY, float maxY, int animationFrame, float maxFrames, int light, boolean bothSided) {
        class_1159 matrix4f = stack.method_23760().method_23761();
        class_4581 mat3f = stack.method_23760().method_23762();
        this.buildQuad(matrix4f, mat3f, build, minX, length, minY, maxY, 0.0f, 0.0f, (float)(animationFrame - 1) / maxFrames, (float)animationFrame / maxFrames, light, bothSided);
    }

    protected void buildQuad(class_1159 matrix4f, class_4581 mat3f, class_4588 build, float minX, float length, float minY, float maxY, float minZ, float maxZ, float vMin, float vMax, int light, boolean bothSided) {
        this.buildVertex(matrix4f, mat3f, build, minX, minY, minZ, 0.0f, Math.max(0.0f, vMin), 0.0f, 0.0f, 1.0f, light);
        this.buildVertex(matrix4f, mat3f, build, minX + length, minY, minZ, 1.0f, Math.max(0.0f, vMin), 0.0f, 0.0f, 1.0f, light);
        this.buildVertex(matrix4f, mat3f, build, minX + length, maxY, maxZ, 1.0f, Math.min(1.0f, vMax), 0.0f, 0.0f, 1.0f, light);
        this.buildVertex(matrix4f, mat3f, build, minX, maxY, maxZ, 0.0f, Math.min(1.0f, vMax), 0.0f, 0.0f, 1.0f, light);
        if (bothSided) {
            this.buildVertex(matrix4f, mat3f, build, minX, maxY, maxZ, 0.0f, Math.min(1.0f, vMax), 0.0f, 0.0f, 1.0f, light);
            this.buildVertex(matrix4f, mat3f, build, minX + length, maxY, maxZ, 1.0f, Math.min(1.0f, vMax), 0.0f, 0.0f, 1.0f, light);
            this.buildVertex(matrix4f, mat3f, build, minX + length, minY, minZ, 1.0f, Math.max(0.0f, vMin), 0.0f, 0.0f, 1.0f, light);
            this.buildVertex(matrix4f, mat3f, build, minX, minY, minZ, 0.0f, Math.max(0.0f, vMin), 0.0f, 0.0f, 1.0f, light);
        }
    }

    protected void buildVertex(class_1159 matrix4f, class_4581 matrix3f, class_4588 builder, float x, float y, float z, float u, float v, float nX, float nY, float nZ, int light) {
        builder.method_22918(matrix4f, x, y, z).method_1336(this.red, this.green, this.blue, this.alpha).method_22913(u, v).method_22922(class_4608.field_21444).method_22916(light).method_23763(matrix3f, nX, nY, nZ).method_1344();
    }

    public abstract ResourcePair startTexture(T var1);

    public abstract ResourcePair endTexture(T var1);

    public float widthFunc(T entity) {
        return (float)((double)(((IBeamEntity)entity).radius() * 2.0f) * Math.sin(Math.sqrt((float)((class_1297)entity).field_6012 / (float)((IBeamEntity)entity).livingTickMax()) * Math.PI));
    }

    public float segmentLength() {
        return 0.0f;
    }

    public int animationFrames(BeamPart part) {
        return 1;
    }

    public int currentAnimation(T entity, BeamPart part) {
        return ((class_1297)entity).field_6012 % this.animationFrames(part) + 1;
    }

    protected float[] split(float length) {
        int arrL = (int)Math.ceil(length / this.segmentLength());
        float[] arr = new float[arrL];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = Math.max(0.0f, length - (float)i * this.segmentLength());
        }
        return arr;
    }

    protected class_1921 getRenderLayer(T entity, class_2960 loc) {
        return class_1921.method_23592((class_2960)loc, (boolean)false);
    }

    protected class_1921 getGlowingRenderLayer(T entity, class_2960 loc) {
        return class_1921.method_23592((class_2960)loc, (boolean)true);
    }

    protected int glowAlpha(T entity) {
        return 35;
    }

    public record ResourcePair(class_2960 res, float size) {
    }

    public static enum BeamPart {
        START,
        END,
        MIDDLE;

    }
}

