/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.render;

import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import java.util.Random;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_490;
import net.minecraft.class_761;

public class RenderUtils {
    public static final int DEFAULT_COLOR = -1;
    private static final float TRIANGLE_MULT = (float)(Math.sqrt(3.0) / 2.0);
    private static final Random RANDOM = new Random(432L);

    public static void renderBlockOutline(class_4587 poseStack, class_4597 buffer, class_1657 player, class_2338 pos, float partialTicks, boolean drawImmediately) {
        RenderUtils.renderBlockOutline(poseStack, buffer, player, pos, partialTicks, 0.0f, 0.0f, 0.0f, 1.0f, drawImmediately);
    }

    public static void renderBlockOutline(class_4587 poseStack, class_4597 buffer, class_1657 player, class_2338 pos, float partialTicks, float red, float green, float blue, float alpha, boolean drawImmediately) {
        class_2680 state = player.field_6002.method_8320(pos);
        class_1921 renderType = class_1921.method_23594();
        class_243 vec = class_310.method_1551().field_1773.method_19418().method_19326();
        RenderUtils.renderShape(poseStack, buffer.getBuffer(renderType), state.method_26172((class_1922)player.field_6002, pos, class_3726.method_16195((class_1297)player)), (double)pos.method_10263() - vec.field_1352, (double)pos.method_10264() - vec.field_1351, (double)pos.method_10260() - vec.field_1350, red, green, blue, alpha);
        if (drawImmediately && buffer instanceof class_4597.class_4598) {
            ((class_4597.class_4598)buffer).method_22994(renderType);
        }
    }

    public static void renderShape(class_4587 poseStack, class_4588 consumer, class_265 shape, double x, double y, double z, float red, float green, float blue, float alpha) {
        class_4587.class_4665 pose = poseStack.method_23760();
        shape.method_1104((k, l, m, n, o, p) -> {
            float q = (float)(n - k);
            float r = (float)(o - l);
            float s = (float)(p - m);
            float t = class_3532.method_15355((float)(q * q + r * r + s * s));
            consumer.method_22918(pose.method_23761(), (float)(k + x), (float)(l + y), (float)(m + z)).method_22915(red, green, blue, alpha).method_23763(pose.method_23762(), q /= t, r /= t, s /= t).method_1344();
            consumer.method_22918(pose.method_23761(), (float)(n + x), (float)(o + y), (float)(p + z)).method_22915(red, green, blue, alpha).method_23763(pose.method_23762(), q, r, s).method_1344();
        });
    }

    public static void renderAreaAround(class_4587 poseStack, class_4597 buffer, class_2338 pos, float radius, boolean drawImmediately) {
        RenderUtils.renderBoundingBox(poseStack, buffer, new class_238(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).method_1014((double)radius).method_996(pos.method_10074()), drawImmediately);
    }

    public static void renderAreaAround(class_4587 poseStack, class_4597 buffer, class_2338 pos, float radius, float red, float green, float blue, float alpha, boolean ignoreDepth, boolean drawImmediately) {
        RenderUtils.renderBoundingBox(poseStack, buffer, new class_238(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).method_1014((double)radius).method_996(pos.method_10074()), red, green, blue, alpha, drawImmediately);
    }

    public static void renderBoundingBox(class_4587 poseStack, class_4597 buffer, class_238 aabb, boolean drawImmediately) {
        RenderUtils.renderBoundingBox(poseStack, buffer, aabb, 1.0f, 0.5f, 0.5f, 1.0f, drawImmediately);
    }

    public static void renderBoundingBox(class_4587 poseStack, class_4597 buffer, class_238 aabb, float red, float green, float blue, float alpha, boolean drawImmediately) {
        class_243 vec = class_310.method_1551().field_1773.method_19418().method_19326();
        class_1921 renderType = class_1921.method_23594();
        poseStack.method_22903();
        poseStack.method_22904(-vec.field_1352, -vec.field_1351, -vec.field_1350);
        class_761.method_22982((class_4587)poseStack, (class_4588)buffer.getBuffer(renderType), (class_238)aabb.method_1014(0.002), (float)red, (float)green, (float)blue, (float)alpha);
        if (drawImmediately && buffer instanceof class_4597.class_4598) {
            ((class_4597.class_4598)buffer).method_22993();
        }
        poseStack.method_22909();
    }

    public static void renderOBB(class_4587 stack, class_4597 buffer, OrientedBoundingBox obb, float red, float green, float blue, float alpha, boolean drawImmediately) {
        class_243 second;
        class_243 first;
        int b;
        class_243 vec = class_310.method_1551().field_1773.method_19418().method_19326();
        stack.method_22903();
        stack.method_22904(-vec.field_1352, -vec.field_1351, -vec.field_1350);
        class_1921 renderType = class_1921.method_23594();
        class_4588 consumer = buffer.getBuffer(renderType);
        class_1159 matrix4f = stack.method_23760().method_23761();
        class_4581 matrix3f = stack.method_23760().method_23762();
        for (b = 0; b < 4; ++b) {
            first = obb.getVertices()[b];
            second = obb.getVertices()[(b + 1) % 4];
            consumer.method_22918(matrix4f, (float)first.method_10216(), (float)first.method_10214(), (float)first.method_10215()).method_22915(red, green, blue, alpha).method_23763(matrix3f, 1.0f, 0.0f, 0.0f).method_1344();
            consumer.method_22918(matrix4f, (float)second.method_10216(), (float)second.method_10214(), (float)second.method_10215()).method_22915(red, green, blue, alpha).method_23763(matrix3f, 1.0f, 0.0f, 0.0f).method_1344();
            class_243 top = obb.getVertices()[4 + b];
            consumer.method_22918(matrix4f, (float)first.method_10216(), (float)first.method_10214(), (float)first.method_10215()).method_22915(red, green, blue, alpha).method_23763(matrix3f, 1.0f, 0.0f, 0.0f).method_1344();
            consumer.method_22918(matrix4f, (float)top.method_10216(), (float)top.method_10214(), (float)top.method_10215()).method_22915(red, green, blue, alpha).method_23763(matrix3f, 1.0f, 0.0f, 0.0f).method_1344();
        }
        for (b = 4; b < 8; ++b) {
            first = obb.getVertices()[b];
            second = obb.getVertices()[4 + (b + 1) % 4];
            consumer.method_22918(matrix4f, (float)first.method_10216(), (float)first.method_10214(), (float)first.method_10215()).method_22915(red, green, blue, alpha).method_23763(matrix3f, 1.0f, 0.0f, 0.0f).method_1344();
            consumer.method_22918(matrix4f, (float)second.method_10216(), (float)second.method_10214(), (float)second.method_10215()).method_22915(red, green, blue, alpha).method_23763(matrix3f, 1.0f, 0.0f, 0.0f).method_1344();
        }
        if (drawImmediately && buffer instanceof class_4597.class_4598) {
            ((class_4597.class_4598)buffer).method_22993();
        }
        stack.method_22909();
    }

    public static void applyYawPitch(class_4587 stack, float yaw, float pitch) {
        stack.method_22907(class_1160.field_20705.method_23214(yaw));
        stack.method_22907(class_1160.field_20707.method_23214(pitch));
    }

    public static void renderTexture(class_4587 stack, class_4588 builder, float xSize, float ySize, TextureBuilder textureBuilder) {
        class_1159 matrix4f = stack.method_23760().method_23761();
        class_4581 mat3f = stack.method_23760().method_23762();
        builder.method_22918(matrix4f, -(xSize /= 2.0f), ySize /= 2.0f, 0.0f).method_1336(textureBuilder.red, textureBuilder.green, textureBuilder.blue, textureBuilder.alpha).method_22913(textureBuilder.u, textureBuilder.v).method_22922(textureBuilder.overlay).method_22916(textureBuilder.light).method_23763(mat3f, 0.0f, 0.0f, 1.0f).method_1344();
        builder.method_22918(matrix4f, xSize, ySize, 0.0f).method_1336(textureBuilder.red, textureBuilder.green, textureBuilder.blue, textureBuilder.alpha).method_22913(textureBuilder.u + textureBuilder.uLength, textureBuilder.v).method_22922(textureBuilder.overlay).method_22916(textureBuilder.light).method_23763(mat3f, 0.0f, 0.0f, 1.0f).method_1344();
        builder.method_22918(matrix4f, xSize, -ySize, 0.0f).method_1336(textureBuilder.red, textureBuilder.green, textureBuilder.blue, textureBuilder.alpha).method_22913(textureBuilder.u + textureBuilder.uLength, textureBuilder.v + textureBuilder.vLength).method_22922(textureBuilder.overlay).method_22916(textureBuilder.light).method_23763(mat3f, 0.0f, 0.0f, 1.0f).method_1344();
        builder.method_22918(matrix4f, -xSize, -ySize, 0.0f).method_1336(textureBuilder.red, textureBuilder.green, textureBuilder.blue, textureBuilder.alpha).method_22913(textureBuilder.u, textureBuilder.v + textureBuilder.vLength).method_22922(textureBuilder.overlay).method_22916(textureBuilder.light).method_23763(mat3f, 0.0f, 0.0f, 1.0f).method_1344();
    }

    public static void renderGradientBeams3d(class_4587 stack, class_4597 renderTypeBuffer, float length, float width, int ticks, float partialTicks, float rotationPerTick, int amount, BeamBuilder builder) {
        stack.method_22903();
        RANDOM.setSeed(432L);
        for (int i = 0; i < amount; ++i) {
            float ticker = (float)ticks + partialTicks;
            stack.method_22907(class_1160.field_20703.method_23214(RANDOM.nextFloat() * 360.0f));
            stack.method_22907(class_1160.field_20705.method_23214(RANDOM.nextFloat() * 360.0f));
            stack.method_22907(class_1160.field_20707.method_23214(RANDOM.nextFloat() * 360.0f + ticker * rotationPerTick));
            RenderUtils.renderGradientBeam3d(stack, renderTypeBuffer, length, width, builder);
        }
        stack.method_22909();
    }

    public static void renderGradientBeam3d(class_4587 stack, class_4597 renderTypeBuffer, float length, float width, BeamBuilder builder) {
        float heightHalf = TRIANGLE_MULT * width * 0.5f;
        float widthHalf = width * 0.5f;
        class_1159 matrix4f = stack.method_23760().method_23761();
        class_4588 buffer = renderTypeBuffer.getBuffer(builder.renderType);
        buffer.method_22918(matrix4f, 0.0f, 0.0f, 0.0f).method_1336(builder.red, builder.green, builder.blue, builder.alpha).method_1344();
        buffer.method_22918(matrix4f, 0.0f, 0.0f, 0.0f).method_1336(builder.red, builder.green, builder.blue, builder.alpha).method_1344();
        buffer.method_22918(matrix4f, -widthHalf, length, -heightHalf).method_1336(builder.endRed, builder.endGreen, builder.endBlue, builder.endAlpha).method_1344();
        buffer.method_22918(matrix4f, widthHalf, length, -heightHalf).method_1336(builder.endRed, builder.endGreen, builder.endBlue, builder.endAlpha).method_1344();
        buffer.method_22918(matrix4f, 0.0f, 0.0f, 0.0f).method_1336(builder.red, builder.green, builder.blue, builder.alpha).method_1344();
        buffer.method_22918(matrix4f, 0.0f, 0.0f, 0.0f).method_1336(builder.red, builder.green, builder.blue, builder.alpha).method_1344();
        buffer.method_22918(matrix4f, widthHalf, length, -heightHalf).method_1336(builder.endRed, builder.endGreen, builder.endBlue, builder.endAlpha).method_1344();
        buffer.method_22918(matrix4f, 0.0f, length, heightHalf).method_1336(builder.endRed, builder.endGreen, builder.endBlue, builder.endAlpha).method_1344();
        buffer.method_22918(matrix4f, 0.0f, 0.0f, 0.0f).method_1336(builder.red, builder.green, builder.blue, builder.alpha).method_1344();
        buffer.method_22918(matrix4f, 0.0f, 0.0f, 0.0f).method_1336(builder.red, builder.green, builder.blue, builder.alpha).method_1344();
        buffer.method_22918(matrix4f, 0.0f, length, heightHalf).method_1336(builder.endRed, builder.endGreen, builder.endBlue, builder.endAlpha).method_1344();
        buffer.method_22918(matrix4f, -widthHalf, length, -heightHalf).method_1336(builder.endRed, builder.endGreen, builder.endBlue, builder.endAlpha).method_1344();
    }

    public static void renderGradientBeams(class_4587 poseStack, class_4597 renderTypeBuffer, float length, float width, int ticks, float partialTicks, float rotationPerTick, int amount, BeamBuilder builder) {
        poseStack.method_22903();
        RANDOM.setSeed(432L);
        for (int i = 0; i < amount; ++i) {
            float ticker = (float)ticks + partialTicks;
            poseStack.method_22907(class_1160.field_20703.method_23214(RANDOM.nextFloat() * 360.0f));
            poseStack.method_22907(class_1160.field_20705.method_23214(RANDOM.nextFloat() * 360.0f));
            poseStack.method_22907(class_1160.field_20707.method_23214(RANDOM.nextFloat() * 360.0f + ticker * rotationPerTick));
            RenderUtils.renderGradientBeam(poseStack, renderTypeBuffer, length, width, builder);
        }
        poseStack.method_22909();
    }

    public static void renderGradientBeam(class_4587 poseStack, class_4597 renderTypeBuffer, float length, float width, BeamBuilder builder) {
        float widthHalf = width * 0.5f;
        class_1159 matrix4f = poseStack.method_23760().method_23761();
        class_4588 buffer = renderTypeBuffer.getBuffer(builder.renderType);
        buffer.method_22918(matrix4f, 0.0f, 0.0f, 0.0f).method_1336(builder.red, builder.green, builder.blue, builder.alpha).method_1344();
        buffer.method_22918(matrix4f, 0.0f, 0.0f, 0.0f).method_1336(builder.red, builder.green, builder.blue, builder.alpha).method_1344();
        buffer.method_22918(matrix4f, -widthHalf, length, 0.0f).method_1336(builder.endRed, builder.endGreen, builder.endBlue, builder.endAlpha).method_1344();
        buffer.method_22918(matrix4f, widthHalf, length, 0.0f).method_1336(builder.endRed, builder.endGreen, builder.endBlue, builder.endAlpha).method_1344();
        buffer.method_22918(matrix4f, 0.0f, 0.0f, 0.0f).method_1336(builder.red, builder.green, builder.blue, builder.alpha).method_1344();
        buffer.method_22918(matrix4f, 0.0f, 0.0f, 0.0f).method_1336(builder.red, builder.green, builder.blue, builder.alpha).method_1344();
        buffer.method_22918(matrix4f, widthHalf, length, 0.0f).method_1336(builder.endRed, builder.endGreen, builder.endBlue, builder.endAlpha).method_1344();
        buffer.method_22918(matrix4f, -widthHalf, length, 0.0f).method_1336(builder.endRed, builder.endGreen, builder.endBlue, builder.endAlpha).method_1344();
    }

    public static void renderScaledEntityGui(int x, int y, int scale, float maxWidth, float maxHeight, float mouseX, float mouseY, class_1309 entity) {
        int sizeX = (int)(maxWidth * (float)scale);
        int sizeY = (int)(maxHeight * (float)scale);
        float scaleMult = 1.0f;
        if (entity.method_17681() > maxWidth) {
            scaleMult = maxWidth / entity.method_17681();
        }
        if (entity.method_17682() > maxHeight) {
            scaleMult = Math.min(scaleMult, maxHeight / entity.method_17682());
        }
        float xPos = (float)(x + x + sizeX) / 2.0f;
        float yPos = (float)(y + y + sizeY) / 2.0f + entity.method_17682() * 0.5f * scaleMult * (float)scale;
        float eyePos = yPos - entity.method_5751() * scaleMult * (float)scale;
        class_490.method_2486((int)((int)xPos), (int)((int)yPos), (int)((int)((float)scale * scaleMult)), (float)(xPos - mouseX), (float)(eyePos - mouseY), (class_1309)entity);
    }

    public static class TextureBuilder {
        private int red = 255;
        private int green = 255;
        private int blue = 255;
        private int alpha = 255;
        private float u;
        private float v;
        private float uLength = 1.0f;
        private float vLength = 1.0f;
        private int light = 0xF000F0;
        private int overlay = class_4608.field_21444;

        public void setUV(float u, float v) {
            this.u = u;
            this.v = v;
        }

        public void setUVLength(float uLength, float vLength) {
            this.uLength = uLength;
            this.vLength = vLength;
        }

        public void setColor(int hexColor) {
            int red = hexColor >> 16 & 0xFF;
            int green = hexColor >> 8 & 0xFF;
            int blue = hexColor & 0xFF;
            int alpha = hexColor >> 24 & 0xFF;
            this.setColor(red, green, blue, alpha);
        }

        public void setColor(int red, int green, int blue, int alpha) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
        }

        public void setColor(float red, float green, float blue, float alpha) {
            this.setColor((int)red * 255, (int)green * 255, (int)blue * 255, (int)alpha * 255);
        }

        public void setOverlay(int overlay) {
            this.overlay = overlay;
        }

        public void setLight(int light) {
            this.light = light;
        }
    }

    public static class BeamBuilder {
        private int red = 255;
        private int green = 255;
        private int blue = 255;
        private int alpha = 255;
        private int endRed = 255;
        private int endGreen = 0;
        private int endBlue = 255;
        private int endAlpha = 0;
        private class_1921 renderType = class_1921.method_23593();

        public void setStartColor(int hexColor) {
            int red = hexColor >> 16 & 0xFF;
            int green = hexColor >> 8 & 0xFF;
            int blue = hexColor & 0xFF;
            int alpha = hexColor >> 24 & 0xFF;
            this.setStartColor(red, green, blue, alpha);
        }

        public void setStartColor(int red, int green, int blue, int alpha) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
        }

        public void setEndColor(int hexColor) {
            int red = hexColor >> 16 & 0xFF;
            int green = hexColor >> 8 & 0xFF;
            int blue = hexColor & 0xFF;
            int alpha = hexColor >> 24 & 0xFF;
            this.setEndColor(red, green, blue, alpha);
        }

        public void setEndColor(int red, int green, int blue, int alpha) {
            this.endRed = red;
            this.endGreen = green;
            this.endBlue = blue;
            this.endAlpha = alpha;
        }

        public void setRenderType(class_1921 renderType) {
            this.renderType = renderType;
        }
    }
}

