/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity;

import io.github.flemmli97.tenshilib.api.entity.IBeamEntity;
import io.github.flemmli97.tenshilib.common.entity.EntityUtil;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import io.github.flemmli97.tenshilib.common.utils.RayTraceUtils;
import io.github.flemmli97.tenshilib.platform.EventCalls;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3966;
import org.jetbrains.annotations.Nullable;

public abstract class EntityBeam
extends class_1297
implements IBeamEntity {
    protected static final class_2940<Optional<UUID>> SHOOTER_UUID = class_2945.method_12791(EntityBeam.class, (class_2941)class_2943.field_13313);
    private class_1297 shooter;
    protected int livingTicks;
    protected class_239 hit;
    protected class_243 hitVec;
    protected OrientedBoundingBox hitObb;

    public EntityBeam(class_1299<? extends EntityBeam> type, class_1937 world) {
        super(type, world);
        this.field_5985 = true;
    }

    public EntityBeam(class_1299<? extends EntityBeam> type, class_1937 world, double x, double y, double z) {
        this(type, world);
        this.method_5814(x, y, z);
    }

    public EntityBeam(class_1299<? extends EntityBeam> type, class_1937 world, class_1309 shooter) {
        this(type, world, shooter.method_23317(), shooter.method_23318() + (double)shooter.method_5751() - 0.1, shooter.method_23321());
        this.shooter = shooter;
        this.field_6011.method_12778(SHOOTER_UUID, Optional.of(shooter.method_5667()));
        this.method_5710(shooter.field_6241, shooter.method_36455());
    }

    public void setRotationTo(class_1297 target, float inaccuracy) {
        class_243 targetPos = EntityUtil.getStraightProjectileTarget(this.method_19538(), target);
        this.setRotationTo(targetPos.method_10216(), targetPos.method_10214(), targetPos.method_10215(), inaccuracy);
    }

    public void setRotationTo(double x, double y, double z, float inaccuracy) {
        double dx = x - this.method_23317();
        double dy = y - this.method_23318();
        double dz = z - this.method_23321();
        this.setRotationToDir(dx, dy, dz, inaccuracy);
    }

    public void setRotationToDir(double x, double y, double z, float inaccuracy) {
        double dis = Math.sqrt((x += this.field_5974.nextGaussian() * (double)inaccuracy) * x + (y += this.field_5974.nextGaussian() * (double)inaccuracy) * y + (z += this.field_5974.nextGaussian() * (double)inaccuracy) * z);
        this.method_36456((float)(class_3532.method_15349((double)z, (double)x) * 180.0 / Math.PI) - 90.0f);
        this.method_36457((float)(Math.acos(y / dis) * 180.0 / Math.PI) - 90.0f);
    }

    @Override
    public class_243 startVec() {
        return this.method_19538();
    }

    @Override
    public class_243 hitVec() {
        return this.hit != null ? this.hitVec : this.startVec();
    }

    public float getRange() {
        return 32.0f;
    }

    @Override
    public float radius() {
        return 1.0f;
    }

    public boolean piercing() {
        return false;
    }

    @Override
    public int livingTickMax() {
        return 20;
    }

    @Override
    public void updateYawPitch() {
        if (this.getHitVecFromShooter() && this.method_35057() != null) {
            class_1297 e = this.method_35057();
            this.method_36457(e.method_36455());
            this.method_36456(e.method_36454());
            this.field_6004 = e.field_6004;
            this.field_5982 = e.field_5982;
            this.method_5814(e.method_23317(), e.method_23318() + (double)e.method_5751() - (double)0.1f, e.method_23321());
        }
    }

    public boolean getHitVecFromShooter() {
        return false;
    }

    public boolean method_5640(double distance) {
        return distance < (double)Math.max(1048.0f, (this.getRange() + 2.0f) * (this.getRange() + 2.0f));
    }

    protected void method_5693() {
        this.field_6011.method_12784(SHOOTER_UUID, Optional.empty());
    }

    public void updateHitDetectBox() {
        double dist = this.hitVec != null ? this.hitVec.method_1020(this.method_19538()).method_1033() : 0.0;
        this.hitObb = new OrientedBoundingBox(OrientedBoundingBox.baseBox(this.radius() * 2.0f, this.radius() * 2.0f, dist + 1.5), this.method_36454(), -this.method_36455(), this.method_19538());
    }

    public void method_5773() {
        this.updateYawPitch();
        if (this.hit == null || this.getHitVecFromShooter()) {
            this.hit = this.getHitRay();
            this.hitVec = this.hit.method_17784();
            if (this.hit.method_17783() == class_239.class_240.field_1332) {
                class_243 dir = this.hitVec.method_1020(this.method_19538()).method_1029();
                this.hitVec = this.hitVec.method_1020(dir.method_1021((double)this.radius() * 0.3));
            }
            this.updateHitDetectBox();
        }
        super.method_5773();
        ++this.livingTicks;
        if (!this.field_6002.field_9236) {
            if (this.livingTicks > this.livingTickMax()) {
                this.method_5650(class_1297.class_5529.field_26998);
                return;
            }
            if (this.hit != null && this.canStartDamage() && this.method_5805()) {
                List list = this.field_6002.method_8335((class_1297)this, new class_238(this.method_23317(), this.method_23318(), this.method_23321(), this.hitVec.field_1352, this.hitVec.field_1351, this.hitVec.field_1350).method_1014((double)(1.0f + this.radius())));
                Predicate<class_238> collisionCheck = aabb -> {
                    if (this.radius() == 0.0f) {
                        Optional ray = aabb.method_992(this.method_19538(), this.hitVec);
                        return ray.isPresent() || aabb.method_1006(this.method_19538());
                    }
                    return this.hitObb.intersects((class_238)aabb);
                };
                for (class_1297 entity : list) {
                    class_3966 raytraceresult;
                    if (entity.equals((Object)this.method_35057()) || !this.canHitEntity(entity) || !this.check(entity, collisionCheck) || EventCalls.INSTANCE.beamHitCall(this, (class_239)(raytraceresult = new class_3966(entity)))) continue;
                    this.onImpact(raytraceresult);
                    if (this.piercing()) continue;
                    return;
                }
            }
        }
    }

    protected boolean canHitEntity(class_1297 target) {
        if (target.method_7325() || !target.method_5805() || !target.method_5863()) {
            return false;
        }
        class_1297 entity = this.method_35057();
        if (entity == null) {
            return true;
        }
        return target != entity && !EntityUtil.isSameMultipart(target, entity) && !entity.method_5794(target);
    }

    public class_239 getHitRay() {
        return RayTraceUtils.entityRayTrace(this, this.getRange(), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, !this.piercing(), true, this::canHitEntity);
    }

    protected boolean check(class_1297 e, Predicate<class_238> intersects) {
        if (e.method_7325() || !e.method_5805() || !e.method_5863()) {
            return false;
        }
        class_238 aabb = e.method_5829();
        return intersects.test(aabb);
    }

    public abstract void onImpact(class_3966 var1);

    public int livingTicks() {
        return this.livingTicks;
    }

    public boolean canStartDamage() {
        return (this.livingTicks - 1) % 20 == 0;
    }

    public void method_5749(class_2487 compound) {
        if (compound.method_25928("Shooter")) {
            this.field_6011.method_12778(SHOOTER_UUID, Optional.of(compound.method_25926("Shooter")));
        }
        this.shooter = this.method_35057();
        this.livingTicks = compound.method_10550("LivingTicks");
    }

    public void method_5652(class_2487 compound) {
        ((Optional)this.field_6011.method_12789(SHOOTER_UUID)).ifPresent(uuid -> compound.method_25927("Shooter", uuid));
        compound.method_10569("LivingTicks", this.livingTicks);
    }

    public UUID method_6139() {
        return ((Optional)this.field_6011.method_12789(SHOOTER_UUID)).orElse(null);
    }

    @Nullable
    public class_1297 method_35057() {
        if (this.shooter != null && !this.shooter.method_31481()) {
            return this.shooter;
        }
        ((Optional)this.field_6011.method_12789(SHOOTER_UUID)).ifPresent(uuid -> {
            this.shooter = EntityUtil.findFromUUID(class_1297.class, this.field_6002, uuid);
        });
        return this.shooter;
    }

    public class_2596<?> method_18002() {
        return new class_2604((class_1297)this);
    }
}

