/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity.ai.animated;

import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.IAnimated;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.utils.MathUtils;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_243;
import net.minecraft.class_6008;
import net.minecraft.class_6011;
import org.jetbrains.annotations.Nullable;

public class AnimatedAttackGoal<T extends class_1314>
extends class_1352 {
    public final T attacker;
    protected final List<class_6008.class_6010<GoalAttackAction<T>>> actions;
    protected final List<class_6008.class_6010<IdleAction<T>>> idleActions;
    protected final boolean checkRestriction;
    protected class_1309 target;
    @Nullable
    public GoalAttackAction.ActiveAction<T> current;
    protected GoalAttackAction.ActiveAction<T> previous;
    protected List<GoalAttackAction.ChainedAction> chained;
    private ActionRun<T> onIdle;
    private boolean reset;
    protected class_243 lastPathTargetPos;
    protected int idleTime;
    protected int prepare;
    protected int chainSelect;
    public double distanceToTargetSq;
    public boolean canSee;

    public AnimatedAttackGoal(T entity, List<class_6008.class_6010<GoalAttackAction<T>>> actions, List<class_6008.class_6010<IdleAction<T>>> idleActions) {
        this(entity, actions, idleActions, true);
    }

    public AnimatedAttackGoal(T entity, List<class_6008.class_6010<GoalAttackAction<T>>> actions, List<class_6008.class_6010<IdleAction<T>>> idleActions, boolean checkRestriction) {
        this.attacker = entity;
        this.actions = actions;
        this.idleActions = idleActions;
        this.checkRestriction = checkRestriction;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        class_1309 living = this.attacker.method_5968();
        return !this.actions.isEmpty() && living != null && living.method_5805() && (!this.checkRestriction || this.attacker.method_18407(living.method_24515()));
    }

    public boolean method_6266() {
        return this.method_6264();
    }

    public void method_6270() {
        this.current = null;
        this.previous = null;
        this.chained = null;
        this.target = null;
        this.reset = false;
        this.lastPathTargetPos = null;
        this.idleTime = 0;
        this.prepare = 0;
        this.attacker.method_5942().method_6340();
        this.attacker.method_5930(0.0f);
        this.attacker.method_5938(0.0f);
    }

    protected void resetAttack() {
        this.current = null;
        this.reset = false;
        this.onIdle = null;
        this.lastPathTargetPos = null;
        this.chained = null;
        this.chainSelect = 0;
    }

    public boolean method_38846() {
        return true;
    }

    public void setupValues() {
        this.target = this.attacker.method_5968();
        if (((class_1314)this.attacker).field_6012 % 10 != 0) {
            return;
        }
        this.distanceToTargetSq = this.attacker.method_5858((class_1297)this.target);
        this.canSee = this.attacker.method_5985().method_6369((class_1297)this.target);
    }

    protected void selectNextAction() {
        this.resetAttack();
        List<class_6008.class_6010> idles = this.idleActions.stream().filter(d -> ((IdleAction)d.method_34983()).test(this, this.target)).toList();
        IdleAction idle = class_6011.method_34986((Random)this.attacker.method_6051(), idles).map(class_6008.class_6010::method_34983).orElse(null);
        ActionRun actionRun = this.onIdle = idle != null ? idle.runner.create() : null;
        if (idle != null) {
            this.onIdle = idle.runner.create();
            this.idleTime = idle.getDuration().getInt(this.attacker);
        } else {
            this.idleTime = 20;
        }
        List<class_6008.class_6010> selectables = this.actions.stream().filter(d -> ((GoalAttackAction)d.method_34983()).test(this, this.target, this.previous != null ? this.previous.anim().getID() : "")).toList();
        GoalAttackAction action = class_6011.method_34986((Random)this.attacker.method_6051(), selectables).map(class_6008.class_6010::method_34983).orElse(null);
        GoalAttackAction.ActiveAction activeAction = this.current = action != null ? action.createActive() : null;
        if (action != null) {
            this.prepare = this.current.start().timeout().getInt(this.attacker);
            this.idleTime = action.getCooldown().getInt(this.attacker);
            if (action.getChainedAction() != null) {
                this.chained = action.getChainedAction().get(this.attacker);
            }
        }
    }

    public void method_6268() {
        if (this.attacker.method_5968() == null) {
            return;
        }
        this.setupValues();
        AnimatedAction anim = ((IAnimated)this.attacker).getAnimationHandler().getAnimation();
        if (anim != null) {
            if (this.current != null && this.current.anim().is(anim)) {
                this.current.runner().run(this, this.target, anim);
            }
            return;
        }
        if (this.reset) {
            this.reset = false;
            this.current = null;
        }
        if (this.current == null) {
            if (this.chained != null) {
                GoalAttackAction.ChainedAction action = this.chained.get(this.chainSelect);
                ((IAnimated)this.attacker).getAnimationHandler().setAnimation(action.anim(), action.transitionTime(), -1, action.offset());
                ++this.chainSelect;
                if (this.chainSelect >= this.chained.size()) {
                    this.chained = null;
                }
                return;
            }
            if (--this.idleTime > 0) {
                if (this.onIdle != null) {
                    this.onIdle.run(this, this.target, null);
                }
                return;
            }
        }
        if (this.current == null) {
            this.selectNextAction();
            return;
        }
        if (--this.prepare >= 0) {
            boolean done = this.current.start().start(this, this.target);
            if (done) {
                this.prepare = -1;
            } else if (this.prepare == 0) {
                this.resetAttack();
                return;
            }
        }
        if (this.prepare == -1) {
            ((IAnimated)this.attacker).getAnimationHandler().setAnimation(this.current.anim());
            this.reset = true;
            this.previous = this.current;
        }
    }

    public void resetCooldown() {
        this.idleTime = 0;
    }

    public void moveToTargetPosition(double x, double y, double z, double speed) {
        if (this.lastPathTargetPos == null || this.attacker.method_5942().method_6357() || this.lastPathTargetPos.method_1028(x, y, z) > 4.0) {
            this.lastPathTargetPos = new class_243(x, y, z);
            class_11 path = this.attacker.method_5942().method_6352(x, y, z, 0);
            if (path != null) {
                this.attacker.method_5942().method_6334(path, speed);
            }
        }
    }

    public void moveToTarget(double speed) {
        this.moveToTargetPosition(this.target.method_23317(), this.target.method_23318(), this.target.method_23321(), speed);
    }

    public void circleAround(double posX, double posZ, float radius, boolean clockWise, float speed) {
        double z;
        double x = this.attacker.method_23317() - posX;
        double r = x * x + (z = this.attacker.method_23321() - posZ) * z;
        if (r < ((double)radius - 1.5) * ((double)radius - 1.5) || r > ((double)radius + 1.5) * ((double)radius + 1.5)) {
            double[] c = MathUtils.closestOnCircle(posX, posZ, this.attacker.method_23317(), this.attacker.method_23321(), radius);
            this.attacker.method_5942().method_6337(c[0], this.attacker.method_23318(), c[1], (double)speed);
        } else {
            double angle = MathUtils.phiFromPoint(posX, posZ, this.attacker.method_23317(), this.attacker.method_23321()) + (double)(clockWise ? MathUtils.degToRad(15.0f) : -MathUtils.degToRad(15.0f));
            double nPosX = (double)radius * Math.cos(angle);
            double nPosZ = (double)radius * Math.sin(angle);
            this.attacker.method_5942().method_6337(posX + nPosX, this.attacker.method_23318(), posZ + nPosZ, (double)speed);
        }
    }
}

