/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity.ai.animated;

import com.google.common.collect.ImmutableList;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionStart;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.WrappedRunner;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_6008;
import net.minecraft.class_6011;
import org.jetbrains.annotations.Nullable;

public class GoalAttackAction<T extends class_1314> {
    private final AnimatedAction action;
    private Condition<T> condition = (executor, target, previous) -> true;
    private ActionStart.Factory<T> preparation = () -> new WrappedRunner(new DoNothingRunner());
    private ActionRun.Factory<T> runner = DoNothingRunner::new;
    private IntProvider<T> cooldown = e -> 20;
    private ChainedActions<T> chained;

    public GoalAttackAction(AnimatedAction action) {
        this.action = action;
    }

    public GoalAttackAction<T> withCondition(Condition<T> condition) {
        this.condition = condition;
        return this;
    }

    public GoalAttackAction<T> prepare(ActionStart.Factory<T> preparation) {
        this.preparation = preparation;
        return this;
    }

    public GoalAttackAction<T> runAction(ActionRun.Factory<T> runner) {
        this.runner = runner;
        return this;
    }

    public GoalAttackAction<T> cooldown(IntProvider<T> cooldown) {
        this.cooldown = cooldown;
        return this;
    }

    public GoalAttackAction<T> chain(ChainedActions.Builder<T> chained) {
        this.chained = chained.build();
        return this;
    }

    public boolean test(AnimatedAttackGoal<T> goal, class_1309 target, String previous) {
        return this.condition.test(goal, target, previous);
    }

    public IntProvider<T> getCooldown() {
        return this.cooldown;
    }

    public ChainedActions<T> getChainedAction() {
        return this.chained;
    }

    public ActiveAction<T> createActive() {
        if (this.action == null) {
            return null;
        }
        return new ActiveAction<T>(this.action, this.preparation.create(), this.runner.create());
    }

    public static <T extends class_1314> ChainedActions.Builder<T> chainBuilder(AnimatedAction anim) {
        return GoalAttackAction.chainBuilder(anim, e -> true);
    }

    public static <T extends class_1314> ChainedActions.Builder<T> chainBuilder(AnimatedAction anim, Predicate<T> delay) {
        return GoalAttackAction.chainBuilder(anim, -1, 0.0f, 1, delay);
    }

    public static <T extends class_1314> ChainedActions.Builder<T> chainBuilder(AnimatedAction anim, int transitionTime, float offset, int weight) {
        return GoalAttackAction.chainBuilder(anim, transitionTime, offset, weight, e -> true);
    }

    public static <T extends class_1314> ChainedActions.Builder<T> chainBuilder(AnimatedAction anim, int transitionTime, float offset, int weight, Predicate<T> predicate) {
        return new ChainedActions.Builder<T>(anim, transitionTime, offset, weight, predicate);
    }

    public static interface Condition<T extends class_1314> {
        public boolean test(AnimatedAttackGoal<T> var1, class_1309 var2, String var3);
    }

    public static interface IntProvider<T extends class_1314> {
        public int getInt(T var1);
    }

    public static class ChainedActions<T extends class_1314> {
        private final List<class_6008.class_6010<ChainList<T>>> chains;
        private final float chance;

        private ChainedActions(List<class_6008.class_6010<ChainList<T>>> chains, float chance) {
            this.chains = chains;
            this.chance = chance;
        }

        @Nullable
        public List<ChainedAction> get(T mob) {
            if (mob.method_6051().nextFloat() >= this.chance) {
                return null;
            }
            List<class_6008.class_6010> filtered = this.chains.stream().filter(d -> ((ChainList)d.method_34983()).predicate().test((class_1314)mob)).toList();
            return class_6011.method_34986((Random)mob.method_6051(), filtered).map(d -> ((ChainList)d.method_34983()).chains()).orElse(null);
        }

        public static class Builder<T extends class_1314> {
            private final List<ChainList.ChainListBuilder<T>> anims = new ArrayList<ChainList.ChainListBuilder<T>>();
            private float chance = 1.0f;

            private Builder(AnimatedAction anim, int transitionTime, float offset, int weight, Predicate<T> predicate) {
                this.anims.add(new ChainList.ChainListBuilder<T>(new ChainedAction(anim, transitionTime, offset * 20.0f), weight, predicate));
            }

            public Builder<T> withChance(float chance) {
                this.chance = chance;
                return this;
            }

            public Builder<T> chain(AnimatedAction anim) {
                return this.chain(anim, -1, 0.0f);
            }

            public Builder<T> chain(AnimatedAction anim, int transitionTime, float offset) {
                this.anims.get(this.anims.size() - 1).add(new ChainedAction(anim, transitionTime, offset * 20.0f));
                return this;
            }

            public Builder<T> or(AnimatedAction anim) {
                return this.or(anim, e -> true);
            }

            public Builder<T> or(AnimatedAction anim, Predicate<T> predicate) {
                return this.or(anim, -1, 0.0f, 1, predicate);
            }

            public Builder<T> or(AnimatedAction anim, int transitionTime, float offset, int weight) {
                return this.or(anim, -1, 0.0f, 1, e -> true);
            }

            public Builder<T> or(AnimatedAction anim, int transitionTime, float offset, int weight, Predicate<T> predicate) {
                this.anims.add(new ChainList.ChainListBuilder<T>(new ChainedAction(anim, transitionTime, offset * 20.0f), weight, predicate));
                return this;
            }

            public ChainedActions<T> build() {
                return new ChainedActions(this.anims.stream().map(ChainList.ChainListBuilder::build).toList(), this.chance);
            }
        }
    }

    public record ActiveAction<T extends class_1314>(AnimatedAction anim, ActionStart<T> start, ActionRun<T> runner) {
    }

    public record ChainedAction(AnimatedAction anim, int transitionTime, float offset) {
    }

    private record ChainList<T extends class_1314>(List<ChainedAction> chains, Predicate<T> predicate) {

        private static class ChainListBuilder<T extends class_1314> {
            private final ImmutableList.Builder<ChainedAction> chains = new ImmutableList.Builder();
            private final int weight;
            private final Predicate<T> predicate;

            private ChainListBuilder(ChainedAction action, int weight, Predicate<T> predicate) {
                this.weight = weight;
                this.chains.add((Object)action);
                this.predicate = predicate;
            }

            public void add(ChainedAction action) {
                this.chains.add((Object)action);
            }

            public class_6008.class_6010<ChainList<T>> build() {
                return class_6008.method_34980(new ChainList<T>((List<ChainedAction>)this.chains.build(), this.predicate), (int)this.weight);
            }
        }
    }
}

