/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity.ai.animated.impl;

import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.ActionUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5532;

public class KeepDistanceRunner<T extends class_1314>
implements ActionRun<T> {
    private final double speed;
    private final double maxDistSqr;
    private final double minDistSqr;
    private final int dist;
    private final boolean needsLoS;
    private int moveType;
    private ActionUtils.PathDistance pathDist;

    public KeepDistanceRunner(double minDist, double maxDist) {
        this(minDist, maxDist, 1.0, true);
    }

    public KeepDistanceRunner(double minDist, double maxDist, double speed) {
        this(minDist, maxDist, speed, true);
    }

    public KeepDistanceRunner(double minDist, double maxDist, double speed, boolean needsLoS) {
        this.speed = speed;
        this.maxDistSqr = maxDist * maxDist;
        this.minDistSqr = minDist * minDist;
        this.dist = class_3532.method_15384((double)(maxDist - minDist));
        this.needsLoS = needsLoS;
    }

    @Override
    public boolean run(AnimatedAttackGoal<T> goal, class_1309 target, AnimatedAction anim) {
        switch (this.moveType) {
            case 0: {
                if (goal.distanceToTargetSq > this.maxDistSqr || !this.canSee(goal)) {
                    goal.moveToTarget(this.speed);
                    this.moveType = 1;
                    break;
                }
                if (!(goal.distanceToTargetSq < this.minDistSqr)) break;
                for (int i = 0; i < 10; ++i) {
                    class_243 posAway = class_5532.method_31511(goal.attacker, (int)this.dist, (int)4, (class_243)target.method_19538());
                    if (posAway == null) continue;
                    goal.moveToTargetPosition(posAway.method_10216(), posAway.method_10214(), posAway.method_10215(), this.speed);
                    break;
                }
                this.moveType = 2;
                break;
            }
            case 1: {
                if (goal.distanceToTargetSq < this.maxDistSqr && this.canSee(goal)) {
                    goal.attacker.method_5942().method_6340();
                    return true;
                }
                goal.moveToTarget(this.speed);
                break;
            }
            case 2: {
                if (((class_1314)goal.attacker).field_6012 % 3 == 0) {
                    ActionUtils.PathDistance lastCheck = this.pathDist;
                    this.pathDist = ActionUtils.distanceToNavTargetSqr(goal.attacker);
                    if (lastCheck != null && this.pathDist != null && lastCheck.index() == this.pathDist.index() && lastCheck.dist() + 2.0 <= this.pathDist.dist()) {
                        this.moveType = 0;
                        return false;
                    }
                }
                if (!this.canSee(goal)) {
                    this.moveType = 0;
                    return false;
                }
                if (!(goal.distanceToTargetSq > this.maxDistSqr)) break;
                goal.attacker.method_5942().method_6340();
                return true;
            }
        }
        goal.attacker.method_5951((class_1297)target, 30.0f, 30.0f);
        return goal.attacker.method_5942().method_6357() && this.canSee(goal);
    }

    private boolean canSee(AnimatedAttackGoal<T> goal) {
        return !this.needsLoS || goal.canSee;
    }
}

