/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity.ai.animated.impl;

import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;

public class StrafingRunner<T extends class_1314>
implements ActionRun<T> {
    private final float radiusSq;
    private final float minRadiusSq;
    private final float speed;
    private final float directionSwitchChance;
    private boolean start;
    private boolean clockWise;
    private int strafingTime;
    private int seeTime = 10;
    private boolean strafingBackwards;

    public StrafingRunner(float radius, float speed) {
        this(radius, speed, 0.3f);
    }

    public StrafingRunner(float radius, float speed, float directionSwitchChance) {
        this(radius, radius * 0.5f, speed, directionSwitchChance);
    }

    public StrafingRunner(float radius, float minRadius, float speed, float directionSwitchChance) {
        this.radiusSq = radius * radius;
        this.minRadiusSq = minRadius * minRadius;
        this.speed = speed;
        this.directionSwitchChance = directionSwitchChance;
    }

    @Override
    public boolean run(AnimatedAttackGoal<T> goal, class_1309 target, AnimatedAction anim) {
        boolean saw;
        if (!this.start) {
            this.start = true;
            this.clockWise = goal.attacker.method_6051().nextBoolean();
        }
        boolean bl = saw = this.seeTime > 0;
        if (goal.canSee != saw) {
            this.seeTime = 0;
        }
        this.seeTime = goal.canSee ? ++this.seeTime : --this.seeTime;
        if (goal.distanceToTargetSq <= (double)(this.radiusSq * this.radiusSq) && this.seeTime >= 20) {
            goal.attacker.method_5942().method_6340();
            ++this.strafingTime;
        } else {
            goal.moveToTarget(this.speed);
            this.strafingTime = -1;
        }
        if (this.strafingTime >= 20) {
            if (goal.attacker.method_6051().nextFloat() < this.directionSwitchChance) {
                this.clockWise = !this.clockWise;
            }
            this.strafingTime = 0;
        }
        if (this.strafingTime > -1) {
            if (goal.distanceToTargetSq > (double)this.radiusSq * 0.75) {
                this.strafingBackwards = false;
            } else if (goal.distanceToTargetSq < (double)this.minRadiusSq) {
                this.strafingBackwards = true;
            }
            goal.attacker.method_5962().method_6243(this.strafingBackwards ? -0.5f : 0.5f, this.clockWise ? this.speed : -this.speed);
        }
        goal.attacker.method_5951((class_1297)target, 30.0f, 30.0f);
        return false;
    }
}

