/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import io.github.flemmli97.tenshilib.platform.EventCalls;
import io.github.flemmli97.tenshilib.platform.PlatformUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1838;
import net.minecraft.class_1917;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_239;
import net.minecraft.class_2404;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3468;
import net.minecraft.class_3730;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public class SpawnEgg
extends class_1826 {
    private static final Map<Supplier<? extends class_1299<?>>, SpawnEgg> EGGS_SUP = Maps.newIdentityHashMap();
    private static final Map<class_1299<?>, SpawnEgg> EGGS = Maps.newIdentityHashMap();
    private static final Map<class_1299<? extends class_1308>, class_1826> BY_ID = SpawnEgg.fetchMapFromSpawnEgg();
    private static boolean resolved;
    protected static final class_2357 DEF;
    private final Supplier<? extends class_1299<?>> type;
    private final boolean mob;

    public SpawnEgg(Supplier<? extends class_1299<?>> type, int primary, int secondary, class_1792.class_1793 props) {
        super(null, primary, secondary, props);
        BY_ID.remove(null);
        this.type = type;
        this.mob = false;
        this.onInit(type);
    }

    public SpawnEgg(EntityTypeHolder<?> type, int primary, int secondary, class_1792.class_1793 props) {
        super(null, primary, secondary, props);
        BY_ID.remove(null);
        this.type = type.type;
        this.mob = class_1308.class.isAssignableFrom(type.clss);
        this.onInit(type.type);
    }

    private static Map<class_1299<? extends class_1308>, class_1826> fetchMapFromSpawnEgg() {
        for (Field f : class_1826.class.getDeclaredFields()) {
            if (!Modifier.isStatic(f.getModifiers()) || !Map.class.isAssignableFrom(f.getType())) continue;
            try {
                f.setAccessible(true);
                Object obj = f.get(null);
                if (!(obj instanceof IdentityHashMap)) continue;
                return (Map)f.get(null);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        throw new RuntimeException("Couldn't find spawnegg map");
    }

    public static void resolveEggs() {
        if (resolved) {
            return;
        }
        resolved = true;
        EGGS_SUP.forEach((type, egg) -> {
            if (egg.addToDefaultSpawneggs() && egg.mob) {
                BY_ID.put((class_1299<? extends class_1308>)((class_1299)type.get()), (class_1826)egg);
            }
            EGGS.put((class_1299<?>)((class_1299)type.get()), (SpawnEgg)((Object)egg));
        });
    }

    protected void onInit(Supplier<? extends class_1299<?>> type) {
        EGGS_SUP.put(type, this);
    }

    public static Iterable<SpawnEgg> getEggs() {
        return Iterables.unmodifiableIterable(EGGS_SUP.values());
    }

    public static Optional<SpawnEgg> fromType(class_1299<?> type) {
        SpawnEgg.resolveEggs();
        return Optional.ofNullable(EGGS.get(type));
    }

    public static Optional<SpawnEgg> fromID(class_2960 id) {
        return PlatformUtils.INSTANCE.entities().getOptionalFromId(id).flatMap(SpawnEgg::fromType);
    }

    public boolean onEntitySpawned(class_1297 e, class_1799 stack, @Nullable class_1657 player) {
        return true;
    }

    public class_2561 getEntityName(class_1799 stack) {
        return stack.method_7938() ? stack.method_7964() : null;
    }

    public class_2357 dispenser() {
        return DEF;
    }

    public boolean addToDefaultSpawneggs() {
        return true;
    }

    public class_2561 method_7864(class_1799 stack) {
        return new class_2588(this.method_7866(stack), new Object[]{new class_2588(this.method_8015(stack.method_7969()).method_5882())});
    }

    public class_1269 method_7884(class_1838 ctx) {
        class_2586 tile;
        class_1937 world = ctx.method_8045();
        if (!(world instanceof class_3218)) {
            return class_1269.field_5812;
        }
        class_1799 stack = ctx.method_8041();
        class_2338 blockpos = ctx.method_8037();
        class_2350 direction = ctx.method_8038();
        class_2680 blockstate = world.method_8320(blockpos);
        class_1269 onBlock = this.onBlockUse(stack, blockpos, blockstate, tile = world.method_8321(blockpos));
        if (onBlock != class_1269.field_5811) {
            return onBlock;
        }
        if (tile instanceof class_2636) {
            class_1917 abstractspawner = ((class_2636)tile).method_11390();
            class_1299<?> entitytype1 = this.method_8015(stack.method_7969());
            abstractspawner.method_8274(entitytype1);
            tile.method_5431();
            world.method_8413(blockpos, blockstate, blockstate, 3);
            stack.method_7934(1);
            return class_1269.field_21466;
        }
        class_2338 blockpos1 = blockstate.method_26220((class_1922)world, blockpos).method_1110() ? blockpos : blockpos.method_10093(direction);
        class_1297 e = SpawnEgg.spawnEntity((class_3218)world, ctx.method_8036(), stack, blockpos1, class_3730.field_16465, true, true, !Objects.equals(blockpos, blockpos1) && direction == class_2350.field_11036);
        if (e != null) {
            stack.method_7934(1);
        }
        return class_1269.field_21466;
    }

    public class_1269 onBlockUse(class_1799 stack, class_2338 pos, class_2680 state, @Nullable class_2586 tile) {
        return class_1269.field_5811;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        class_3965 raytraceresult = SpawnEgg.method_7872((class_1937)world, (class_1657)player, (class_3959.class_242)class_3959.class_242.field_1345);
        if (raytraceresult.method_17783() != class_239.class_240.field_1332) {
            return class_1271.method_22430((Object)stack);
        }
        if (!(world instanceof class_3218)) {
            return class_1271.method_22427((Object)stack);
        }
        class_2338 blockpos = raytraceresult.method_17777();
        if (!(world.method_8320(blockpos).method_26204() instanceof class_2404)) {
            return class_1271.method_22430((Object)stack);
        }
        if (world.method_8505(player, blockpos) && player.method_7343(blockpos, raytraceresult.method_17780(), stack)) {
            class_1297 e = SpawnEgg.spawnEntity((class_3218)world, player, stack, blockpos, class_3730.field_16465, true, true, false);
            if (e != null) {
                if (!player.method_7337()) {
                    stack.method_7934(1);
                }
                player.method_7259(class_3468.field_15372.method_14956((Object)this));
                return class_1271.method_22428((Object)stack);
            }
            return class_1271.method_22430((Object)stack);
        }
        return class_1271.method_22431((Object)stack);
    }

    public static class_1297 spawnEntity(class_3218 world, class_1657 player, class_1799 stack, class_2338 pos, class_3730 reason, boolean forgeCheck, boolean updateLocation, boolean doCollisionOffset) {
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof SpawnEgg)) {
            return null;
        }
        SpawnEgg item = (SpawnEgg)class_17922;
        class_1299<?> type = item.method_8015(stack.method_7969());
        class_1297 e = type.method_5888(world, stack.method_7969(), item.getEntityName(stack), player, pos, reason, updateLocation, doCollisionOffset);
        if (e != null) {
            if (!item.onEntitySpawned(e, stack, player) || forgeCheck && e instanceof class_1308 && EventCalls.INSTANCE.specialSpawnCall((class_1308)e, (class_1937)world, pos.method_10263(), pos.method_10264(), pos.method_10260(), null, reason)) {
                return null;
            }
            world.method_30771(e);
        }
        return e;
    }

    public int getColor(class_1799 stack, int i) {
        return super.method_8016(i);
    }

    public class_1299<?> method_8015(@Nullable class_2487 nbt) {
        class_2487 compoundnbt;
        if (nbt != null && nbt.method_10573("EntityTag", 10) && (compoundnbt = nbt.method_10562("EntityTag")).method_10573("id", 8)) {
            class_1299<?> type = PlatformUtils.INSTANCE.entities().getFromId(new class_2960(compoundnbt.method_10558("id")));
            return type != null ? type : this.type.get();
        }
        return this.type.get();
    }

    static {
        DEF = (blockSource, stack) -> {
            class_2350 direction = (class_2350)blockSource.method_10120().method_11654((class_2769)class_2315.field_10918);
            SpawnEgg.spawnEntity(blockSource.method_10207(), null, stack, blockSource.method_10122().method_10093(direction), class_3730.field_16470, false, direction != class_2350.field_11036, false);
            stack.method_7934(1);
            return stack;
        };
    }

    public record EntityTypeHolder<T extends class_1297>(Class<T> clss, Supplier<? extends class_1299<? extends T>> type) {
    }
}

