/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.utils;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.tenshilib.platform.PlatformUtils;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_2378;
import net.minecraft.class_5321;

public class CodecUtils {
    public static <T extends Enum<T>> Codec<T> stringEnumCodec(Class<T> clss, T fallback) {
        return Codec.STRING.flatXmap(s -> {
            try {
                return DataResult.success(Enum.valueOf(clss, s));
            }
            catch (IllegalArgumentException e) {
                if (fallback != null) {
                    return DataResult.success((Object)fallback);
                }
                return DataResult.error((String)("No such enum constant " + s + " for class " + String.valueOf(clss)));
            }
        }, e -> DataResult.success((Object)e.name()));
    }

    public static <T extends Enum<T>> Codec<T> ordinalEnumCodec(Class<T> clss, T fallback) {
        return Codec.INT.flatXmap(s -> {
            try {
                return DataResult.success((Object)((Enum[])clss.getEnumConstants())[s]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (fallback != null) {
                    return DataResult.success((Object)fallback);
                }
                return DataResult.error((String)("No such enum ordinal " + s + " for class " + String.valueOf(clss)));
            }
        }, e -> DataResult.success((Object)e.ordinal()));
    }

    public static <E> Codec<E> jsonCodecBuilder(Gson gson, Class<E> clss, String name) {
        return CodecUtils.jsonCodecBuilder(arg_0 -> ((Gson)gson).toJsonTree(arg_0), (JsonElement e) -> gson.fromJson(e, clss), name);
    }

    public static <E> Codec<E> jsonCodecBuilder(final Function<E, JsonElement> encode, final Function<JsonElement, E> decode, final String name) {
        return new Codec<E>(){

            public <T> DataResult<T> encode(E input, DynamicOps<T> ops, T prefix) {
                try {
                    JsonElement e = (JsonElement)encode.apply(input);
                    return DataResult.success((Object)NullableJsonOps.INSTANCE.convertTo(ops, e));
                }
                catch (JsonParseException err) {
                    return DataResult.error((String)("Couldn't encode value " + String.valueOf(input) + " error: " + String.valueOf((Object)err)));
                }
            }

            public <T> DataResult<Pair<E, T>> decode(DynamicOps<T> ops, T input) {
                JsonElement element = (JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, input);
                try {
                    Object result = decode.apply(element);
                    return DataResult.success((Object)Pair.of(result, input));
                }
                catch (JsonParseException err) {
                    return DataResult.error((String)("Couldn't decode value " + String.valueOf((Object)err)));
                }
            }

            public String toString() {
                return name;
            }
        };
    }

    public static <T> Codec<T> registryCodec(class_5321<? extends class_2378<T>> key) {
        Supplier reg = Suppliers.memoize(() -> PlatformUtils.INSTANCE.registry(key).byNameCodec());
        return new Codec<T>((java.util.function.Supplier)reg){
            final /* synthetic */ java.util.function.Supplier val$reg;
            {
                this.val$reg = supplier;
            }

            public <O> DataResult<O> encode(T input, DynamicOps<O> ops, O prefix) {
                return ((Codec)this.val$reg.get()).encode(input, ops, prefix);
            }

            public <I> DataResult<Pair<T, I>> decode(DynamicOps<I> ops, I input) {
                return ((Codec)this.val$reg.get()).decode(ops, input);
            }

            public String toString() {
                return ((Codec)this.val$reg.get()).toString();
            }
        };
    }

    public static <V, T> Codec<V> registryCodec(class_5321<? extends class_2378<T>> key, Function<Codec<T>, Codec<V>> cons) {
        Supplier reg = Suppliers.memoize(() -> (Codec)cons.apply(PlatformUtils.INSTANCE.registry(key).byNameCodec()));
        return new Codec<V>((java.util.function.Supplier)reg){
            final /* synthetic */ java.util.function.Supplier val$reg;
            {
                this.val$reg = supplier;
            }

            public <O> DataResult<O> encode(V input, DynamicOps<O> ops, O prefix) {
                return ((Codec)this.val$reg.get()).encode(input, ops, prefix);
            }

            public <I> DataResult<Pair<V, I>> decode(DynamicOps<I> ops, I input) {
                return ((Codec)this.val$reg.get()).decode(ops, input);
            }

            public String toString() {
                return ((Codec)this.val$reg.get()).toString();
            }
        };
    }

    public static class NullableJsonOps
    extends JsonOps {
        public static final JsonOps INSTANCE = new NullableJsonOps(false);

        protected NullableJsonOps(boolean compressed) {
            super(compressed);
        }

        public <U> U convertMap(DynamicOps<U> ops, JsonElement e) {
            DataResult mapLike = DataResult.success(e.getAsJsonObject().entrySet().stream().filter(entry -> !(entry.getValue() instanceof JsonNull)).map(entry -> Pair.of((Object)new JsonPrimitive((String)entry.getKey()), (Object)((JsonElement)entry.getValue()))));
            return (U)ops.createMap(mapLike.result().orElse(Stream.empty()).map(entry -> Pair.of((Object)this.convertTo(ops, (JsonElement)entry.getFirst()), (Object)this.convertTo(ops, (JsonElement)entry.getSecond()))));
        }
    }
}

