/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1950;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_265;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_5575;
import org.jetbrains.annotations.Nullable;

public class OrientedBoundingBox {
    private class_238 baseBox;
    private class_238 outerBox;
    private float yRot;
    private float xRot;
    private class_243 offset;
    private final class_243[] vertices = new class_243[8];
    private class_243 axisX;
    private class_243 axisY;
    private class_243 axisZ;

    public OrientedBoundingBox(class_238 box) {
        this(box, 0.0f, 0.0f, class_243.field_1353);
    }

    public OrientedBoundingBox(class_238 box, float yRot, float xRot) {
        this(box, yRot, xRot, class_243.field_1353);
    }

    public OrientedBoundingBox(class_238 box, class_243 offset) {
        this(box, 0.0f, 0.0f, offset);
    }

    public OrientedBoundingBox(class_238 box, float yRot, float xRot, class_243 offset) {
        this.baseBox = box;
        this.yRot = yRot;
        this.xRot = xRot;
        this.offset = offset;
        this.compute();
    }

    public static class_238 baseBox(double width, double height, double length) {
        return new class_238(-width * 0.5, -height * 0.5, 0.0, width * 0.5, height * 0.5, length);
    }

    public static class_238 originAABB(class_1297 entity) {
        return entity.method_5829().method_997(entity.method_19538().method_1021(-1.0));
    }

    public static OrientedBoundingBox fromBuffer(class_2540 buf) {
        return new OrientedBoundingBox(new class_238(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble()), buf.readFloat(), buf.readFloat(), new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble()));
    }

    private static boolean collides(class_243[] firstBoxVertices, class_243[] secondBoxVertices, class_243[] axes) {
        for (class_243 axis : axes) {
            Projection second;
            Projection first = OrientedBoundingBox.projectOntoAxis(firstBoxVertices, axis);
            if (OrientedBoundingBox.overlap(first, second = OrientedBoundingBox.projectOntoAxis(secondBoxVertices, axis))) continue;
            return false;
        }
        return true;
    }

    private static Projection projectOntoAxis(class_243[] vertices, class_243 axis) {
        double min;
        double max = min = axis.method_1026(vertices[0]);
        for (class_243 vertex : vertices) {
            double projection = axis.method_1026(vertex);
            if (projection < min) {
                min = projection;
            }
            if (!(projection > max)) continue;
            max = projection;
        }
        return new Projection(min, max);
    }

    private static boolean overlap(Projection first, Projection second) {
        return first.max >= second.min && second.max >= first.min;
    }

    public OrientedBoundingBox rotate(float yRot, float xRot) {
        this.yRot = yRot;
        this.xRot = xRot;
        this.compute();
        return this;
    }

    public OrientedBoundingBox move(double x, double y, double z) {
        return this.move(new class_243(x, y, z));
    }

    public OrientedBoundingBox move(class_243 offset) {
        this.offset = this.offset.method_1019(offset);
        this.compute();
        return this;
    }

    public OrientedBoundingBox setPos(double x, double y, double z) {
        return this.move(new class_243(x, y, z));
    }

    public OrientedBoundingBox setPos(class_243 offset) {
        this.offset = offset;
        this.compute();
        return this;
    }

    public OrientedBoundingBox inflate(double val) {
        return this.inflate(val, val, val);
    }

    public OrientedBoundingBox inflate(double x, double y, double z) {
        this.baseBox = this.baseBox.method_1009(x, y, z);
        this.compute();
        return this;
    }

    public OrientedBoundingBox apply(Function<class_238, class_238> func) {
        this.baseBox = func.apply(this.baseBox);
        this.compute();
        return this;
    }

    public boolean intersects(OrientedBoundingBox box) {
        class_243[] axis = new class_243[]{this.axisX, this.axisY, this.axisZ, box.axisX, box.axisY, box.axisZ};
        return OrientedBoundingBox.collides(this.vertices, box.vertices, axis);
    }

    public boolean intersects(class_238 aabb) {
        if (this.xRot == 0.0f && this.yRot == 0.0f) {
            return this.baseBox.method_997(this.offset).method_994(aabb);
        }
        class_243[] axis = new class_243[]{this.axisX, this.axisY, this.axisZ, new class_243(1.0, 0.0, 0.0), new class_243(0.0, 1.0, 0.0), new class_243(0.0, 0.0, 1.0)};
        class_243[] verticesAABB = new class_243[]{new class_243(aabb.field_1323, aabb.field_1322, aabb.field_1321), new class_243(aabb.field_1320, aabb.field_1322, aabb.field_1321), new class_243(aabb.field_1320, aabb.field_1322, aabb.field_1324), new class_243(aabb.field_1323, aabb.field_1322, aabb.field_1324), new class_243(aabb.field_1323, aabb.field_1325, aabb.field_1321), new class_243(aabb.field_1320, aabb.field_1325, aabb.field_1321), new class_243(aabb.field_1320, aabb.field_1325, aabb.field_1324), new class_243(aabb.field_1323, aabb.field_1325, aabb.field_1324)};
        return OrientedBoundingBox.collides(this.vertices, verticesAABB, axis);
    }

    public <T extends class_1297> List<T> intersectingEntities(class_1937 level, class_1309 entity, boolean ignoreBlocks, class_5575<class_1297, T> typeTest, Predicate<T> pred) {
        BlockCollisionDetector collisionDetector = ignoreBlocks ? null : new BlockCollisionDetector(level, this, (class_1297)entity);
        return this.intersectingEntities(level, collisionDetector, typeTest, pred);
    }

    public <T extends class_1297> List<T> intersectingEntities(class_1937 level, BlockCollisionDetector collisionDetector, class_5575<class_1297, T> typeTest, Predicate<T> pred) {
        class_238 box = this.getEncompassingBox();
        List list = level.method_18023(typeTest, box, pred);
        list.removeIf(e -> !this.intersects(e.method_5829()) || collisionDetector != null && !collisionDetector.noBlockCollide((class_1297)e));
        return list;
    }

    public boolean collidesBlocks(class_1937 level, @Nullable class_1297 entity) {
        for (class_265 shape : level.method_20812(entity, this.getEncompassingBox())) {
            if (!this.intersects(shape.method_1107())) continue;
            return true;
        }
        return false;
    }

    public class_238 getBaseBox() {
        return this.baseBox;
    }

    public class_238 getEncompassingBox() {
        return this.outerBox;
    }

    public float getXRot() {
        return this.xRot;
    }

    public float getYRot() {
        return this.yRot;
    }

    public class_243[] getVertices() {
        return this.vertices;
    }

    public class_243 getOffset() {
        return this.offset;
    }

    public void toBuffer(class_2540 buf) {
        buf.writeDouble(this.baseBox.field_1320);
        buf.writeDouble(this.baseBox.field_1325);
        buf.writeDouble(this.baseBox.field_1324);
        buf.writeDouble(this.baseBox.field_1323);
        buf.writeDouble(this.baseBox.field_1322);
        buf.writeDouble(this.baseBox.field_1321);
        buf.writeFloat(this.yRot);
        buf.writeFloat(this.xRot);
        buf.writeDouble(this.offset.field_1352);
        buf.writeDouble(this.offset.field_1351);
        buf.writeDouble(this.offset.field_1350);
    }

    private void compute() {
        float xRotRad = (float)Math.PI / 180 * this.xRot;
        float yRotRad = (float)(-Math.PI) / 180 * this.yRot;
        this.vertices[0] = new class_243(this.baseBox.field_1323, this.baseBox.field_1322, this.baseBox.field_1321).method_1037(xRotRad).method_1024(yRotRad).method_1019(this.offset);
        this.vertices[1] = new class_243(this.baseBox.field_1320, this.baseBox.field_1322, this.baseBox.field_1321).method_1037(xRotRad).method_1024(yRotRad).method_1019(this.offset);
        this.vertices[2] = new class_243(this.baseBox.field_1320, this.baseBox.field_1322, this.baseBox.field_1324).method_1037(xRotRad).method_1024(yRotRad).method_1019(this.offset);
        this.vertices[3] = new class_243(this.baseBox.field_1323, this.baseBox.field_1322, this.baseBox.field_1324).method_1037(xRotRad).method_1024(yRotRad).method_1019(this.offset);
        this.vertices[4] = new class_243(this.baseBox.field_1323, this.baseBox.field_1325, this.baseBox.field_1321).method_1037(xRotRad).method_1024(yRotRad).method_1019(this.offset);
        this.vertices[5] = new class_243(this.baseBox.field_1320, this.baseBox.field_1325, this.baseBox.field_1321).method_1037(xRotRad).method_1024(yRotRad).method_1019(this.offset);
        this.vertices[6] = new class_243(this.baseBox.field_1320, this.baseBox.field_1325, this.baseBox.field_1324).method_1037(xRotRad).method_1024(yRotRad).method_1019(this.offset);
        this.vertices[7] = new class_243(this.baseBox.field_1323, this.baseBox.field_1325, this.baseBox.field_1324).method_1037(xRotRad).method_1024(yRotRad).method_1019(this.offset);
        this.axisX = new class_243(1.0, 0.0, 0.0).method_1037(xRotRad).method_1024(yRotRad);
        this.axisY = new class_243(0.0, 1.0, 0.0).method_1037(xRotRad).method_1024(yRotRad);
        this.axisZ = new class_243(0.0, 0.0, 1.0).method_1037(xRotRad).method_1024(yRotRad);
        double minX = this.vertices[0].method_10216();
        double minY = this.vertices[0].method_10214();
        double minZ = this.vertices[0].method_10215();
        double maxX = this.vertices[0].method_10216();
        double maxY = this.vertices[0].method_10214();
        double maxZ = this.vertices[0].method_10215();
        for (class_243 vertices : this.vertices) {
            if (vertices.field_1352 < minX) {
                minX = vertices.field_1352;
            } else if (vertices.field_1352 > maxX) {
                maxX = vertices.field_1352;
            }
            if (vertices.field_1351 < minY) {
                minY = vertices.field_1351;
            } else if (vertices.field_1351 > maxY) {
                maxY = vertices.field_1351;
            }
            if (vertices.field_1350 < minZ) {
                minZ = vertices.field_1350;
                continue;
            }
            if (!(vertices.field_1350 > maxZ)) continue;
            maxZ = vertices.field_1350;
        }
        this.outerBox = new class_238(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public String toString() {
        return String.format("OBB[aabb=%s, yRot=%s, xRot=%s, offset=%s]", this.baseBox, Float.valueOf(this.yRot), Float.valueOf(this.xRot), this.offset);
    }

    private record Projection(double min, double max) {
    }

    public static class BlockCollisionDetector {
        private final class_1922 blockGetter;
        private final class_243 from;
        private final class_1297 source;

        public BlockCollisionDetector(class_1937 level, OrientedBoundingBox obb, class_1297 source) {
            class_238 box = obb.getEncompassingBox();
            class_2338 first = new class_2338(box.field_1323, box.field_1322, box.field_1321);
            class_2338 second = new class_2338(class_3532.method_15384((double)box.field_1320), class_3532.method_15384((double)box.field_1325), class_3532.method_15384((double)box.field_1324));
            this.blockGetter = new class_1950(level, first, second);
            this.from = obb.getOffset();
            this.source = source;
        }

        /*
         * WARNING - void declaration
         */
        public boolean noBlockCollide(class_1297 entity) {
            int ySplit;
            class_238 aabb = entity.method_5829();
            if (this.blockGetter.method_17742(new class_3959(this.from, entity.method_19538(), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, this.source)).method_17783() == class_239.class_240.field_1333) {
                return true;
            }
            ArrayList<Object> points = new ArrayList<Object>();
            ArrayList<class_243> maxYs = new ArrayList<class_243>();
            points.add(new class_243(aabb.field_1323, aabb.field_1322, aabb.field_1321));
            points.add(new class_243(aabb.field_1320, aabb.field_1322, aabb.field_1321));
            points.add(new class_243(aabb.field_1320, aabb.field_1322, aabb.field_1324));
            points.add(new class_243(aabb.field_1323, aabb.field_1322, aabb.field_1324));
            maxYs.add(new class_243(aabb.field_1323, aabb.field_1325, aabb.field_1321));
            maxYs.add(new class_243(aabb.field_1320, aabb.field_1325, aabb.field_1321));
            maxYs.add(new class_243(aabb.field_1320, aabb.field_1325, aabb.field_1324));
            maxYs.add(new class_243(aabb.field_1323, aabb.field_1325, aabb.field_1324));
            int xSplit = (int)((double)entity.method_17681() / 0.4);
            if (xSplit > 0) {
                void var8_9;
                double xStep = entity.method_17681() / (float)(++xSplit);
                boolean bl = true;
                while (var8_9 < xSplit) {
                    points.add(new class_243(aabb.field_1323 + (double)var8_9 * xStep, aabb.field_1322, aabb.field_1321));
                    points.add(new class_243(aabb.field_1323 + (double)var8_9 * xStep, aabb.field_1322, aabb.field_1324));
                    points.add(new class_243(aabb.field_1323, aabb.field_1322, aabb.field_1321 + (double)var8_9 * xStep));
                    points.add(new class_243(aabb.field_1320, aabb.field_1322, aabb.field_1321 + (double)var8_9 * xStep));
                    maxYs.add(new class_243(aabb.field_1323 + (double)var8_9 * xStep, aabb.field_1325, aabb.field_1321));
                    maxYs.add(new class_243(aabb.field_1323 + (double)var8_9 * xStep, aabb.field_1325, aabb.field_1324));
                    maxYs.add(new class_243(aabb.field_1323, aabb.field_1325, aabb.field_1321 + (double)var8_9 * xStep));
                    maxYs.add(new class_243(aabb.field_1320, aabb.field_1325, aabb.field_1321 + (double)var8_9 * xStep));
                    ++var8_9;
                }
            }
            if ((ySplit = (int)((double)entity.method_17682() / 0.5)) > 0) {
                double yStep = entity.method_17682() / (float)(++ySplit);
                ArrayList<class_243> verticals = new ArrayList<class_243>();
                for (int y = 1; y < ySplit; ++y) {
                    for (class_243 class_2432 : points) {
                        verticals.add(new class_243(class_2432.method_10216(), aabb.field_1322 + (double)y * yStep, class_2432.method_10215()));
                    }
                }
                points.addAll(verticals);
            }
            points.addAll(maxYs);
            for (class_243 class_2433 : points) {
                if (this.blockGetter.method_17742(new class_3959(this.from, class_2433, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, this.source)).method_17783() != class_239.class_240.field_1333) continue;
                return true;
            }
            return false;
        }
    }
}

