/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.patreon;

import io.github.flemmli97.tenshilib.patreon.PatreonDataManager;
import io.github.flemmli97.tenshilib.patreon.RenderLocation;
import io.github.flemmli97.tenshilib.patreon.effects.PatreonEffectConfig;
import io.github.flemmli97.tenshilib.patreon.effects.PatreonEffects;
import io.github.flemmli97.tenshilib.patreon.pkts.C2SEffectUpdatePkt;
import net.minecraft.class_1657;
import net.minecraft.class_2487;

public class PatreonPlayerSetting {
    private PatreonEffectConfig conf;
    private RenderLocation renderLocation = RenderLocation.HAT;
    private boolean render = true;
    private int color;
    private final class_1657 player;
    private boolean newSetting = true;

    public PatreonPlayerSetting(class_1657 player) {
        this.player = player;
    }

    public void setToDefault(boolean forced) {
        if (forced || this.newSetting) {
            PatreonDataManager.PatreonPlayerInfo info = PatreonDataManager.get(this.player.method_5667().toString());
            if (info.tier() > 0) {
                this.setEffect(PatreonEffects.get(info.defaultEffect()));
                if (info.defaultRenderLocation() != null) {
                    this.renderLocation = info.defaultRenderLocation();
                }
                this.color = info.color();
            } else {
                this.conf = null;
            }
        }
    }

    public void setEffect(PatreonEffectConfig conf) {
        this.conf = conf;
        if (this.conf != null) {
            this.renderLocation = this.conf.defaultLoc();
            this.color = this.conf.defaultColor();
        }
    }

    public PatreonEffectConfig effect() {
        return this.conf;
    }

    public boolean shouldRender() {
        return this.render;
    }

    public RenderLocation getRenderLocation() {
        return this.renderLocation;
    }

    public int getColor() {
        return this.color;
    }

    public void tick(class_1657 player) {
        if (this.effect() != null && this.render) {
            this.effect().tick(player);
        }
    }

    public class_2487 save(class_2487 tag) {
        if (this.conf != null) {
            tag.method_10582("Effect", this.conf.id());
        }
        tag.method_10569("Location", this.renderLocation.ordinal());
        tag.method_10556("ShouldRender", this.render);
        tag.method_10569("Color", this.color);
        return tag;
    }

    public void read(class_2487 tag) {
        if (tag.method_10545("Effect")) {
            this.setEffect(PatreonEffects.get(tag.method_10558("Effect")));
        }
        RenderLocation loc = RenderLocation.values()[tag.method_10550("Location")];
        if (this.conf != null) {
            this.renderLocation = this.conf.locationAllowed(loc) ? loc : this.conf.defaultLoc();
        }
        this.render = tag.method_10577("ShouldRender");
        this.color = tag.method_10550("Color");
        this.newSetting = false;
    }

    public void read(C2SEffectUpdatePkt pkt, String id) {
        this.conf = PatreonEffects.get(id);
        RenderLocation loc = pkt.location;
        if (this.conf != null) {
            this.renderLocation = this.conf.locationAllowed(loc) ? loc : this.conf.defaultLoc();
        }
        this.render = pkt.render;
        this.color = pkt.color;
    }

    public void update(PatreonEffectConfig effect, RenderLocation location, boolean render, int color) {
        this.conf = effect;
        if (this.conf != null) {
            this.renderLocation = this.conf.locationAllowed(location) ? location : this.conf.defaultLoc();
        }
        this.render = render;
        this.color = color;
    }
}

