/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.platform.registry;

import io.github.flemmli97.tenshilib.platform.registry.CustomRegistryEntry;
import io.github.flemmli97.tenshilib.platform.registry.PlatformRegistry;
import io.github.flemmli97.tenshilib.platform.registry.RegistryEntrySupplier;
import io.github.flemmli97.tenshilib.platform.registry.VanillaEntrySupplier;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public class VanillaRegistryHandler<T>
implements PlatformRegistry<T> {
    private final class_5321<? extends class_2378<T>> key;
    private final String modid;
    private final Map<VanillaEntrySupplier<T>, Supplier<? extends T>> entries = new LinkedHashMap<VanillaEntrySupplier<T>, Supplier<? extends T>>();
    private final Set<VanillaEntrySupplier<T>> entriesView = Collections.unmodifiableSet(this.entries.keySet());
    private class_2378<T> registry;

    public VanillaRegistryHandler(class_5321<? extends class_2378<T>> key, String modid) {
        this.key = key;
        this.modid = modid;
    }

    @Override
    public <I extends T> RegistryEntrySupplier<I> register(String name, Supplier<? extends I> sup) {
        class_2960 id = new class_2960(this.modid, name);
        VanillaEntrySupplier v = new VanillaEntrySupplier(id);
        this.entries.putIfAbsent(v, sup);
        return v;
    }

    @Override
    public void registerContent() {
        class_2378 registry = this.registryFrom();
        this.entries.forEach((v, s) -> {
            Object val = s.get();
            if (val instanceof CustomRegistryEntry) {
                CustomRegistryEntry entry = (CustomRegistryEntry)val;
                entry.setRegistryName(v.getID());
            }
            class_2378.method_10230((class_2378)registry, (class_2960)v.getID(), val);
            v.updateValue(registry);
        });
    }

    protected class_2378<T> registryFrom() {
        if (this.registry == null) {
            class_2378 reg = (class_2378)class_2378.field_11144.method_10223(this.key.method_29177());
            if (reg == null) {
                throw new NullPointerException("Failed to get a corresponding registry for " + String.valueOf(this.key));
            }
            this.registry = reg;
        }
        return this.registry;
    }

    @Override
    public Collection<? extends RegistryEntrySupplier<T>> getEntries() {
        return this.entriesView;
    }
}

