/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1309;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4168;

public class BrainActivityGroup<T extends class_1309> {
    private final class_4168 activity;
    private int priorityStart = 0;
    private final List<class_4097<? super T>> behaviours = new ObjectArrayList();
    private final Set<Pair<class_4140<?>, class_4141>> activityStartMemoryConditions = new ObjectOpenHashSet();
    private Set<class_4140<?>> wipedMemoriesOnFinish = null;

    public BrainActivityGroup(class_4168 activity) {
        this.activity = activity;
    }

    public BrainActivityGroup<T> priority(int priorityStart) {
        this.priorityStart = priorityStart;
        return this;
    }

    public BrainActivityGroup<T> behaviours(class_4097<? super T> ... behaviours) {
        this.behaviours.addAll((Collection<class_4097<T>>)new ObjectArrayList((Object[])behaviours));
        return this;
    }

    public BrainActivityGroup<T> onlyStartWithMemoryStatus(class_4140<?> memory, class_4141 status) {
        this.activityStartMemoryConditions.add(Pair.of(memory, (Object)status));
        return this;
    }

    public BrainActivityGroup<T> wipeMemoriesWhenFinished(class_4140<?> ... memories) {
        if (this.wipedMemoriesOnFinish == null) {
            this.wipedMemoriesOnFinish = new ObjectOpenHashSet((Object[])memories);
        } else {
            this.wipedMemoriesOnFinish.addAll((Collection<class_4140<?>>)new ObjectOpenHashSet((Object[])memories));
        }
        return this;
    }

    public BrainActivityGroup<T> requireAndWipeMemoriesOnUse(class_4140<?> ... memories) {
        for (class_4140<?> memory : memories) {
            this.onlyStartWithMemoryStatus(memory, class_4141.field_18456);
        }
        this.wipeMemoriesWhenFinished(memories);
        return this;
    }

    public class_4168 getActivity() {
        return this.activity;
    }

    public List<class_4097<? super T>> getBehaviours() {
        return this.behaviours;
    }

    public int getPriorityStart() {
        return this.priorityStart;
    }

    public Set<Pair<class_4140<?>, class_4141>> getActivityStartMemoryConditions() {
        return this.activityStartMemoryConditions;
    }

    public Set<class_4140<?>> getWipedMemoriesOnFinish() {
        return this.wipedMemoriesOnFinish != null ? this.wipedMemoriesOnFinish : Set.of();
    }

    public ImmutableList<Pair<Integer, class_4097<? super T>>> pairBehaviourPriorities() {
        int priority = this.priorityStart;
        ImmutableList.Builder pairedBehaviours = ImmutableList.builder();
        for (class_4097<? super T> class_40972 : this.behaviours) {
            pairedBehaviours.add((Object)Pair.of((Object)priority++, class_40972));
        }
        return pairedBehaviours.build();
    }

    public static <T extends class_1309> BrainActivityGroup<T> empty() {
        return new BrainActivityGroup<T>(class_4168.field_18597);
    }

    public static <T extends class_1309> BrainActivityGroup<T> coreTasks(class_4097<? super T> ... behaviours) {
        return new BrainActivityGroup<T>(class_4168.field_18594).priority(0).behaviours(behaviours);
    }

    public static <T extends class_1309> BrainActivityGroup<T> idleTasks(class_4097<? super T> ... behaviours) {
        return new BrainActivityGroup<T>(class_4168.field_18595).priority(10).behaviours(behaviours);
    }

    public static <T extends class_1309> BrainActivityGroup<T> fightTasks(class_4097<? super T> ... behaviours) {
        return new BrainActivityGroup<T>(class_4168.field_22396).priority(10).behaviours(behaviours).requireAndWipeMemoriesOnUse(class_4140.field_22355);
    }
}

