/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4103;
import net.minecraft.class_4140;
import net.minecraft.class_4168;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrain;
import net.tslat.smartbrainlib.api.core.behaviour.GroupBehaviour;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;

public class SmartBrainProvider<E extends class_1309>
extends class_4095.class_5303<E> {
    private static final Map<class_1299<? extends class_1309>, ImmutableList<class_4140<?>>> BRAIN_MEMORY_CACHE = new Object2ObjectOpenHashMap();
    private final E owner;
    private final boolean saveMemories;
    private final boolean nonStaticMemories;

    public SmartBrainProvider(E owner) {
        this(owner, false);
    }

    public SmartBrainProvider(E owner, boolean nonStaticMemories) {
        this(owner, false, nonStaticMemories);
    }

    public SmartBrainProvider(E owner, boolean saveMemories, boolean nonStaticMemories) {
        super(List.of(), List.of());
        this.owner = owner;
        this.saveMemories = saveMemories;
        this.nonStaticMemories = nonStaticMemories;
    }

    public final SmartBrain<E> makeBrain(Dynamic<?> codecLoader) {
        Object memories;
        List sensors = ((SmartBrainOwner)this.owner).getSensors();
        List<BrainActivityGroup<E>> taskList = this.compileTasks();
        if (!this.nonStaticMemories && BRAIN_MEMORY_CACHE.containsKey(this.owner.method_5864())) {
            memories = BRAIN_MEMORY_CACHE.get(this.owner.method_5864());
        } else {
            memories = this.createMemoryList(taskList, sensors);
            if (!this.nonStaticMemories) {
                BRAIN_MEMORY_CACHE.put((class_1299<class_1309>)((class_1299<? extends class_1309>)this.owner.method_5864()), (ImmutableList<class_4140<?>>)memories);
            }
        }
        SmartBrain brain = new SmartBrain((List<class_4140<?>>)memories, sensors, taskList, this.saveMemories);
        this.finaliseBrain(brain);
        return brain;
    }

    private ImmutableList<class_4140<?>> createMemoryList(List<BrainActivityGroup<E>> taskList, List<? extends ExtendedSensor<?>> sensors) {
        ObjectOpenHashSet memoryTypes = new ObjectOpenHashSet();
        taskList.forEach(arg_0 -> this.lambda$createMemoryList$1((Set)memoryTypes, arg_0));
        sensors.forEach(arg_0 -> SmartBrainProvider.lambda$createMemoryList$2((Set)memoryTypes, arg_0));
        return ImmutableList.copyOf((Collection)memoryTypes);
    }

    private void collectMemoriesFromTask(Set<class_4140<?>> memories, class_4097<?> behaviour) {
        if (behaviour instanceof class_4103) {
            class_4103 gateBehaviour = (class_4103)behaviour;
            gateBehaviour.field_18347.method_35094().forEach(subBehaviour -> this.collectMemoriesFromTask(memories, (class_4097<?>)subBehaviour));
        } else if (behaviour instanceof GroupBehaviour) {
            GroupBehaviour groupBehaviour = (GroupBehaviour)behaviour;
            groupBehaviour.getBehaviours().forEachRemaining(subBehaviour -> this.collectMemoriesFromTask(memories, (class_4097<?>)subBehaviour));
        } else {
            memories.addAll(behaviour.field_19291.keySet());
        }
    }

    private List<BrainActivityGroup<E>> compileTasks() {
        ObjectArrayList tasks = new ObjectArrayList();
        BrainActivityGroup activityGroup = ((SmartBrainOwner)this.owner).getCoreTasks();
        if (!activityGroup.getBehaviours().isEmpty()) {
            tasks.add(activityGroup);
        }
        if (!(activityGroup = ((SmartBrainOwner)this.owner).getIdleTasks()).getBehaviours().isEmpty()) {
            tasks.add(activityGroup);
        }
        if (!(activityGroup = ((SmartBrainOwner)this.owner).getFightTasks()).getBehaviours().isEmpty()) {
            tasks.add(activityGroup);
        }
        tasks.addAll(((SmartBrainOwner)this.owner).getAdditionalTasks().values());
        return tasks;
    }

    private void finaliseBrain(SmartBrain<E> brain) {
        brain.method_18890(((SmartBrainOwner)this.owner).getAlwaysRunningActivities());
        brain.method_18897(((SmartBrainOwner)this.owner).getDefaultActivity());
        brain.method_24536();
        brain.setSchedule(((SmartBrainOwner)this.owner).getSchedule());
        ((SmartBrainOwner)this.owner).handleAdditionalBrainSetup(brain);
    }

    @Deprecated(forRemoval=true)
    protected void addActivity(SmartBrain<E> brain, class_4168 activity, BrainActivityGroup<E> activityGroup) {
        brain.field_18326.put(activity, activityGroup.getActivityStartMemoryConditions());
        if (!activityGroup.getWipedMemoriesOnFinish().isEmpty()) {
            brain.field_22282.put(activity, activityGroup.getWipedMemoriesOnFinish());
        }
        for (Pair pair : activityGroup.pairBehaviourPriorities()) {
            brain.addBehaviour((Integer)pair.getFirst(), activity, (class_4097)pair.getSecond());
        }
    }

    private static /* synthetic */ void lambda$createMemoryList$2(Set memoryTypes, ExtendedSensor sensor) {
        memoryTypes.addAll(sensor.memoriesUsed());
    }

    private /* synthetic */ void lambda$createMemoryList$1(Set memoryTypes, BrainActivityGroup activityGroup) {
        activityGroup.getBehaviours().forEach(behavior -> this.collectMemoriesFromTask(memoryTypes, (class_4097<?>)behavior));
    }
}

