/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.sensor.vanilla;

import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_11;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_4140;
import net.minecraft.class_4149;
import net.minecraft.class_4153;
import net.minecraft.class_4158;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.registry.SBLSensors;
import net.tslat.smartbrainlib.util.BrainUtils;

public class NearestHomeSensor<E extends class_1308>
extends PredicateSensor<E, E> {
    private static final List<class_4140<?>> MEMORIES = ObjectArrayList.of((Object[])new class_4140[]{class_4140.field_19007});
    protected int radius = 48;
    private final Object2LongOpenHashMap<class_2338> homesMap = new Object2LongOpenHashMap(5);
    private int tries = 0;

    public NearestHomeSensor() {
        super((brainOwner, entity) -> brainOwner.method_6109());
    }

    public NearestHomeSensor<E> setRadius(int radius) {
        this.radius = radius;
        return this;
    }

    @Override
    public List<class_4140<?>> memoriesUsed() {
        return MEMORIES;
    }

    @Override
    public class_4149<? extends ExtendedSensor<?>> type() {
        return SBLSensors.NEAREST_HOME.get();
    }

    protected void doTick(class_3218 level, E entity) {
        if (!this.predicate().test(entity, entity)) {
            return;
        }
        this.tries = 0;
        long nodeExpiryTime = level.method_8510() + (long)level.method_8409().nextInt(20);
        class_4153 poiManager = level.method_19494();
        Predicate<class_2338> predicate = pos -> {
            if (this.homesMap.containsKey(pos)) {
                return false;
            }
            if (++this.tries >= 5) {
                return false;
            }
            this.homesMap.put(pos, nodeExpiryTime + 40L);
            return true;
        };
        Set poiLocations = poiManager.method_21647(poiType -> poiType.equals(class_4158.field_18517), predicate, entity.method_24515(), this.radius, class_4153.class_4155.field_18489).collect(Collectors.toSet());
        class_11 pathToHome = entity.method_5942().method_29934(poiLocations, class_4158.field_18517.method_21648());
        if (pathToHome != null && pathToHome.method_21655()) {
            class_2338 targetPos = pathToHome.method_48();
            poiManager.method_19132(targetPos).ifPresent(poiType -> BrainUtils.setMemory((class_1309)entity, class_4140.field_19007, targetPos));
        } else if (this.tries < 5) {
            this.homesMap.object2LongEntrySet().removeIf(pos -> pos.getLongValue() < nodeExpiryTime);
        }
    }
}

