/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.util;

import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RandomUtil {
    public static final EasyRandom RANDOM = new EasyRandom(ThreadLocalRandom.current());

    public static ThreadLocalRandom getRandomInstance() {
        return ThreadLocalRandom.current();
    }

    public static boolean fiftyFifty() {
        return RANDOM.fiftyFifty();
    }

    public static boolean oneInNChance(int n) {
        return RANDOM.oneInNChance(n);
    }

    public static boolean percentChance(double percentChance) {
        return RANDOM.percentChance(percentChance);
    }

    public static boolean percentChance(float percentChance) {
        return RANDOM.percentChance(percentChance);
    }

    public static int randomNumberUpTo(int upperBound) {
        return RANDOM.randomNumberUpTo(upperBound);
    }

    public static float randomValueUpTo(float upperBound) {
        return RANDOM.randomValueUpTo(upperBound);
    }

    public static double randomValueUpTo(double upperBound) {
        return RANDOM.randomValueUpTo(upperBound);
    }

    public static double randomGaussianValue() {
        return RANDOM.randomGaussianValue();
    }

    public static double randomScaledGaussianValue(double scale) {
        return RANDOM.randomScaledGaussianValue(scale);
    }

    public static int randomNumberBetween(int min, int max) {
        return RANDOM.randomNumberBetween(min, max);
    }

    public static double randomValueBetween(double min, double max) {
        return RANDOM.randomValueBetween(min, max);
    }

    public static <T> T getRandomSelection(T ... options) {
        return RANDOM.getRandomSelection(options);
    }

    public static <T> T getRandomSelection(@NotNull List<T> options) {
        return RANDOM.getRandomSelection(options);
    }

    @NotNull
    public static class_2338 getRandomPositionWithinRange(class_2338 centerPos, int xRadius, int yRadius, int zRadius) {
        return RANDOM.getRandomPositionWithinRange(centerPos, xRadius, yRadius, zRadius);
    }

    @NotNull
    public static class_2338 getRandomPositionWithinRange(class_2338 centerPos, int xRadius, int yRadius, int zRadius, boolean safeSurfacePlacement, class_1937 world) {
        return RANDOM.getRandomPositionWithinRange(centerPos, xRadius, yRadius, zRadius, safeSurfacePlacement, world);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static class_2338 getRandomPositionWithinRange(class_2338 centerPos, int xRadius, int yRadius, int zRadius, int minSpreadX, int minSpreadY, int minSpreadZ, boolean safeSurfacePlacement, class_1937 world, int tries, @Nullable Predicate<class_2680> statePredicate) {
        return RANDOM.getRandomPositionWithinRange(centerPos, xRadius, yRadius, zRadius, minSpreadX, minSpreadY, minSpreadZ, safeSurfacePlacement, world, tries, statePredicate);
    }

    @NotNull
    public static class_2338 getRandomPositionWithinRange(class_2338 centerPos, int xRadius, int yRadius, int zRadius, int minSpreadX, int minSpreadY, int minSpreadZ, boolean safeSurfacePlacement, class_1937 world, int tries, @Nullable BiPredicate<class_2680, class_2338> statePredicate) {
        return RANDOM.getRandomPositionWithinRange(centerPos, xRadius, yRadius, zRadius, minSpreadX, minSpreadY, minSpreadZ, safeSurfacePlacement, world, tries, statePredicate);
    }

    public static final class EasyRandom
    extends Random {
        private final Random random;

        public EasyRandom() {
            this(new Random());
        }

        public EasyRandom(@NotNull Random rand) {
            this.random = rand;
        }

        public Random getSource() {
            return new Random();
        }

        public boolean fiftyFifty() {
            return this.random.nextBoolean();
        }

        public boolean oneInNChance(int n) {
            if (n <= 0) {
                return false;
            }
            return this.random.nextFloat() < 1.0f / (float)n;
        }

        public boolean percentChance(double percentChance) {
            if (percentChance <= 0.0) {
                return false;
            }
            if (percentChance >= 1.0) {
                return true;
            }
            return this.random.nextDouble() < percentChance;
        }

        public boolean percentChance(float percentChance) {
            if (percentChance <= 0.0f) {
                return false;
            }
            if (percentChance >= 1.0f) {
                return true;
            }
            return this.random.nextDouble() < (double)percentChance;
        }

        public int randomNumberUpTo(int upperBound) {
            return this.random.nextInt(upperBound);
        }

        public float randomValueUpTo(float upperBound) {
            return this.random.nextFloat() * upperBound;
        }

        public double randomValueUpTo(double upperBound) {
            return this.random.nextDouble() * upperBound;
        }

        public double randomGaussianValue() {
            return this.random.nextGaussian();
        }

        public double randomScaledGaussianValue(double scale) {
            return this.random.nextGaussian() * scale;
        }

        public int randomNumberBetween(int min, int max) {
            return min + (int)Math.floor(this.random.nextDouble() * (double)(1 + max - min));
        }

        public double randomValueBetween(double min, double max) {
            return min + this.random.nextDouble() * (max - min);
        }

        public <T> T getRandomSelection(T ... options) {
            return options[this.random.nextInt(options.length)];
        }

        public <T> T getRandomSelection(@NotNull List<T> options) {
            return options.get(this.random.nextInt(options.size()));
        }

        @NotNull
        public class_2338 getRandomPositionWithinRange(class_2338 centerPos, int xRadius, int yRadius, int zRadius) {
            return this.getRandomPositionWithinRange(centerPos, xRadius, yRadius, zRadius, false, null);
        }

        @NotNull
        public class_2338 getRandomPositionWithinRange(class_2338 centerPos, int xRadius, int yRadius, int zRadius, boolean safeSurfacePlacement, class_1937 world) {
            return this.getRandomPositionWithinRange(centerPos, xRadius, yRadius, zRadius, 0, 0, 0, safeSurfacePlacement, world, 1, (Predicate<class_2680>)null);
        }

        @Deprecated(forRemoval=true)
        @NotNull
        public class_2338 getRandomPositionWithinRange(class_2338 centerPos, int xRadius, int yRadius, int zRadius, int minSpreadX, int minSpreadY, int minSpreadZ, boolean safeSurfacePlacement, class_1937 world, int tries, @Nullable Predicate<class_2680> statePredicate) {
            return this.getRandomPositionWithinRange(centerPos, xRadius, yRadius, zRadius, minSpreadX, minSpreadY, minSpreadZ, safeSurfacePlacement, world, tries, (class_2680 state, class_2338 pos) -> statePredicate == null || statePredicate.test((class_2680)state));
        }

        @NotNull
        public class_2338 getRandomPositionWithinRange(class_2338 centerPos, int xRadius, int yRadius, int zRadius, int minSpreadX, int minSpreadY, int minSpreadZ, boolean safeSurfacePlacement, class_1937 world, int tries, @Nullable BiPredicate<class_2680, class_2338> statePredicate) {
            class_2338.class_2339 mutablePos = centerPos.method_25503();
            xRadius = Math.max(xRadius - minSpreadX, 0);
            yRadius = Math.max(yRadius - minSpreadY, 0);
            zRadius = Math.max(zRadius - minSpreadZ, 0);
            for (int i = 0; i < tries; ++i) {
                double xAdjust = this.random.nextFloat() * (float)xRadius * 2.0f - (float)xRadius;
                double yAdjust = this.random.nextFloat() * (float)yRadius * 2.0f - (float)yRadius;
                double zAdjust = this.random.nextFloat() * (float)zRadius * 2.0f - (float)zRadius;
                int newX = (int)Math.floor((double)centerPos.method_10263() + xAdjust + (double)minSpreadX * Math.signum(xAdjust));
                int newY = (int)Math.floor((double)centerPos.method_10264() + yAdjust + (double)minSpreadY * Math.signum(yAdjust));
                int newZ = (int)Math.floor((double)centerPos.method_10260() + zAdjust + (double)minSpreadZ * Math.signum(zAdjust));
                mutablePos.method_10103(newX, newY, newZ);
                if (safeSurfacePlacement && world != null) {
                    mutablePos.method_10101((class_2382)world.method_8598(class_2902.class_2903.field_13203, (class_2338)mutablePos));
                }
                if (statePredicate != null && !statePredicate.test(world.method_8320((class_2338)mutablePos), mutablePos.method_10062())) continue;
                return mutablePos.method_10062();
            }
            return centerPos;
        }

        public EasyRandom fork() {
            return new EasyRandom(this.random);
        }

        @Override
        public void setSeed(long seed) {
            this.random.setSeed(seed);
        }

        @Override
        public int nextInt() {
            return this.random.nextInt();
        }

        @Override
        public int nextInt(int upperLimit) {
            return this.random.nextInt(upperLimit);
        }

        @Override
        public long nextLong() {
            return this.random.nextLong();
        }

        @Override
        public boolean nextBoolean() {
            return this.random.nextBoolean();
        }

        @Override
        public float nextFloat() {
            return this.random.nextFloat();
        }

        @Override
        public double nextDouble() {
            return this.random.nextDouble();
        }

        @Override
        public double nextGaussian() {
            return this.random.nextGaussian();
        }
    }
}

