/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsrpgtweaks.config;

import io.redspace.ironsrpgtweaks.IronsRpgTweaks;
import io.redspace.ironsrpgtweaks.damage_module.PlayerDamageMode;
import io.redspace.ironsrpgtweaks.durability_module.DeathDurabilityMode;
import io.redspace.ironsrpgtweaks.durability_module.VanillaDurabilityMode;
import io.redspace.ironsrpgtweaks.hunger_module.CommonHungerEvents;
import io.redspace.ironsrpgtweaks.hunger_module.RegistryGetter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ServerConfigs {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec SPEC;
    public static final ModConfigSpec.ConfigValue<Boolean> DAMAGE_MODULE_ENABLED;
    public static final ModConfigSpec.ConfigValue<Integer> IFRAME_COUNT;
    public static final ModConfigSpec.ConfigValue<PlayerDamageMode> PLAYER_DAMAGE_MODE;
    public static final ModConfigSpec.ConfigValue<List<? extends String>> SAME_TICK_DAMAGE_TYPE_WHITELIST;
    private static final ModConfigSpec.ConfigValue<List<? extends String>> ENTITY_IFRAME_BLACKLIST;
    public static final ModConfigSpec.ConfigValue<Boolean> ALLOW_NON_MINIMUM_STRENGTH_ATTACKS;
    public static final ModConfigSpec.ConfigValue<Double> MINIMUM_ATTACK_STRENGTH;
    public static final ModConfigSpec.ConfigValue<Double> KNOCKBACK_MODIFIER;
    public static final ModConfigSpec.ConfigValue<Boolean> ENABLE_COMBAT_SNAPSHOT;
    public static final ModConfigSpec.ConfigValue<Boolean> DURABILITY_MODULE_ENABLED;
    public static final ModConfigSpec.ConfigValue<VanillaDurabilityMode> DURABILITY_VANILLA_MODE;
    private static final ModConfigSpec.ConfigValue<List<? extends String>> DURABILITY_VANILLA_MODE_WHITELIST;
    private static final ModConfigSpec.ConfigValue<List<? extends String>> DURABILITY_VANILLA_MODE_BLACKLIST;
    public static final ModConfigSpec.ConfigValue<DeathDurabilityMode> DURABILITY_DEATH_MODE;
    private static final ModConfigSpec.ConfigValue<List<? extends String>> DURABILITY_DEATH_MODE_WHITELIST;
    private static final ModConfigSpec.ConfigValue<List<? extends String>> DURABILITY_DEATH_MODE_BLACKLIST;
    public static final ModConfigSpec.ConfigValue<Double> DURABILITY_LOST_ON_DEATH;
    public static final ModConfigSpec.ConfigValue<Integer> ADDITIONAL_DURABILITY_LOST_ON_DEATH;
    public static final ModConfigSpec.ConfigValue<Boolean> XP_MODULE_ENABLED;
    public static final ModConfigSpec.ConfigValue<Boolean> XP_IGNORE_KEEPINVENTORY;
    public static final ModConfigSpec.ConfigValue<Boolean> XP_ONLY_ALLOW_OWNER;
    public static final ModConfigSpec.ConfigValue<Double> ENTITY_XP_MODIFIER;
    public static final ModConfigSpec.ConfigValue<Double> BLOCK_XP_MODIFIER;
    public static final ModConfigSpec.ConfigValue<Boolean> HUNGER_MODULE_ENABLED;
    public static final ModConfigSpec.ConfigValue<Boolean> HUNGER_DISABLED;
    public static final ModConfigSpec.ConfigValue<Boolean> ALLOW_SPRINTING;
    public static final ModConfigSpec.ConfigValue<Boolean> HUNGER_PREVENTS_SPRINTING;
    public static final ModConfigSpec.ConfigValue<Double> HUNGER_NUTRITION_MULTIPLIER;
    public static final ModConfigSpec.ConfigValue<Double> FOOD_TO_HEALTH_MODIFIER;
    public static final ModConfigSpec.ConfigValue<Integer> NATURAL_REGENERATION_TICK_RATE;
    public static final ModConfigSpec.ConfigValue<Boolean> NATURAL_REGENERATION_DURING_COMBAT;
    public static final ModConfigSpec.ConfigValue<Double> SPLASH_POTION_COOLDOWN;
    public static final ModConfigSpec.ConfigValue<Double> LINGERING_POTION_COOLDOWN;
    public static final ModConfigSpec.ConfigValue<Double> DRINKABLE_POTION_COOLDOWN;
    public static final ModConfigSpec.ConfigValue<Double> FOOD_COOLDOWN;
    public static final ModConfigSpec.ConfigValue<Double> EAT_TIME_MULTIPLIER;
    public static final ModConfigSpec.ConfigValue<Double> POTION_DRINK_TIME_MULTIPLER;
    public static final ModConfigSpec.ConfigValue<Integer> POTION_STACK_SIZE;
    public static final ModConfigSpec.ConfigValue<Integer> FOOD_STACK_SIZE;
    public static final ModConfigSpec.ConfigValue<Boolean> SLEEP_MODULE_ENABLED;
    private static final Map<Holder<Item>, Consumer<DataComponentPatch.Builder>> DEFAULT_COMPONENTS_PATCH;

    public static void handleOnConfigReload() {
        IronsRpgTweaks.LOGGER.debug("On Config Reload");
        ServerConfigs.cacheRegistryList(RegistryGetter.getItem(), (List)DURABILITY_VANILLA_MODE_WHITELIST.get(), RegistryLists.DURABILITY_VANILLA_MODE_WHITELIST_ITEMS);
        ServerConfigs.cacheRegistryList(RegistryGetter.getItem(), (List)DURABILITY_VANILLA_MODE_BLACKLIST.get(), RegistryLists.DURABILITY_VANILLA_MODE_BLACKLIST_ITEMS);
        ServerConfigs.cacheRegistryList(RegistryGetter.getItem(), (List)DURABILITY_DEATH_MODE_WHITELIST.get(), RegistryLists.DURABILITY_DEATH_MODE_WHITELIST_ITEMS);
        ServerConfigs.cacheRegistryList(RegistryGetter.getItem(), (List)DURABILITY_DEATH_MODE_BLACKLIST.get(), RegistryLists.DURABILITY_DEATH_MODE_BLACKLIST_ITEMS);
        ServerConfigs.cacheRegistryList(RegistryGetter.getEntity(), (List)ENTITY_IFRAME_BLACKLIST.get(), RegistryLists.ENTITY_IFRAME_BLACKLIST);
        IronsRpgTweaks.LOGGER.debug("DURABILITY_VANILLA_MODE_WHITELIST: {} {}", DURABILITY_VANILLA_MODE_WHITELIST.get(), RegistryLists.DURABILITY_VANILLA_MODE_WHITELIST_ITEMS);
        IronsRpgTweaks.LOGGER.debug("DURABILITY_VANILLA_MODE_BLACKLIST: {} {}", DURABILITY_VANILLA_MODE_BLACKLIST.get(), RegistryLists.DURABILITY_VANILLA_MODE_BLACKLIST_ITEMS);
        IronsRpgTweaks.LOGGER.debug("DURABILITY_DEATH_MODE_WHITELIST: {} {}", DURABILITY_DEATH_MODE_WHITELIST.get(), RegistryLists.DURABILITY_DEATH_MODE_WHITELIST_ITEMS);
        IronsRpgTweaks.LOGGER.debug("DURABILITY_DEATH_MODE_BLACKLIST: {} {}", DURABILITY_DEATH_MODE_BLACKLIST.get(), RegistryLists.DURABILITY_DEATH_MODE_BLACKLIST_ITEMS);
        IronsRpgTweaks.LOGGER.debug("ENTITY_IFRAME_BLACKLIST: {} {}", ENTITY_IFRAME_BLACKLIST.get(), RegistryLists.ENTITY_IFRAME_BLACKLIST);
        DEFAULT_COMPONENTS_PATCH.clear();
        CommonHungerEvents.modifyDefaultStackSize(ServerConfigs::modifyDefaultComponent);
    }

    public static void handleDefaultStackComponents(ItemStack stack) {
        Consumer<DataComponentPatch.Builder> patch = DEFAULT_COMPONENTS_PATCH.get(stack.getItemHolder());
        if (patch != null) {
            DataComponentPatch.Builder patchBuilder = DataComponentPatch.builder();
            patch.accept(patchBuilder);
            stack.applyComponentsAndValidate(patchBuilder.build());
        }
    }

    private static void modifyDefaultComponent(Holder<Item> item, Consumer<DataComponentPatch.Builder> patch) {
        DEFAULT_COMPONENTS_PATCH.put(item, patch);
    }

    private static <T> void cacheRegistryList(Registry<T> registry, List<? extends String> ids, Set<T> output) {
        output.clear();
        for (String string : ids) {
            try {
                if (string.startsWith("#")) {
                    TagKey tag = new TagKey(registry.key(), ResourceLocation.parse((String)string.substring(1)));
                    output.addAll(registry.stream().filter(item -> registry.wrapAsHolder(item).is(tag)).toList());
                    continue;
                }
                Object item2 = registry.get(ResourceLocation.parse((String)string));
                if (item2 != null) {
                    output.add(item2);
                    continue;
                }
                IronsRpgTweaks.LOGGER.warn("Unable to add item to config, no such item id: {}", (Object)string);
            }
            catch (Exception e) {
                IronsRpgTweaks.LOGGER.warn("Unable to validate item config: {}", (Object)e.getMessage());
            }
        }
    }

    private static boolean validateItemName(Object obj) {
        String itemName;
        return obj instanceof String && ResourceLocation.isValidNamespace((String)(itemName = (String)obj)) && ResourceLocation.isValidPath((String)itemName) && BuiltInRegistries.ITEM.containsKey(ResourceLocation.parse((String)itemName));
    }

    private static String getDefaultEntries(List<? extends String> list) {
        Object str = "[";
        for (String string : list) {
            str = (String)str + "\"" + string + "\",";
        }
        str = ((String)str).substring(0, ((String)str).length() - 1);
        return (String)str + "]";
    }

    static {
        BUILDER.push("Damage-Module");
        DAMAGE_MODULE_ENABLED = BUILDER.comment("The purpose of the damage module is to remove the invulnerability ticks after an entity is damaged to better suit gameplay where entities are going to be ignoring too much damage if left unchecked. Disabling will nullify every feature listed under this module.").define("damageModuleEnabled", true);
        IFRAME_COUNT = BUILDER.comment("Invulnerability Tick (I-Frame) count. Default: 0").define("invulnerabilityTickCount", (Object)0);
        SAME_TICK_DAMAGE_TYPE_WHITELIST = BUILDER.comment("If specified, these damage types will be able to deal damage on the same tick as a mechanism to bypass auto tick detection").defineList("damageTypeSameTickWhitelist", List.of(), x -> true);
        ENTITY_IFRAME_BLACKLIST = BUILDER.comment("If specified, these entity types or type tags will be blacklisted from skipping i-frames upon dealing damage").defineList("entityIframeBlacklist", List.of(), x -> true);
        PLAYER_DAMAGE_MODE = BUILDER.comment("Additional handling for player's interactions with reduced i-frames. \"ALL\" means there is no additional handling, \"ONLY_LIVING\" means only living attacks ignore player i-frames (may help with unforeseen damage like potions), and \"NONE\" means player's damage ticks are unaffected by the damage module.").defineEnum("playerDamageMode", (Enum)PlayerDamageMode.ALL);
        MINIMUM_ATTACK_STRENGTH = BUILDER.comment("In order to prevent spam attacks, a minimum threshold of attack strength can be set before an attack can deal damage. Default: 0.75").define("minimumAttackStrength", (Object)0.75);
        ALLOW_NON_MINIMUM_STRENGTH_ATTACKS = BUILDER.comment("Whether a player is allowed to swing if the minimumAttackStrength threshold is not met. Default: true").define("allowNonMinStrengthAttacks", true);
        KNOCKBACK_MODIFIER = BUILDER.comment("Global multiplier to all knockback. Default: 1.0").define("globalKnockbackMultiplier", (Object)1.0);
        ENABLE_COMBAT_SNAPSHOT = BUILDER.comment("Enable Combat Snapshot Inspired Changes (experimental): Attack cooldown no longer affects damage, but instead affects weapon reach").comment("!THIS SETTING IS AFFECTED BY \"minimumAttackStrength\" AND \"allowNonMinStrengthAttacks\" WHICH SHOULD BE CONFIGURED ACCORDINGLY!").define("enableCombatSnapshot", false);
        BUILDER.pop();
        BUILDER.push("Durability-Module");
        DURABILITY_MODULE_ENABLED = BUILDER.comment("The purpose of the durability module is to rework how durability damage is applied to better emulate an rpg setting.  Disabling will nullify every feature listed under this module.").define("durabilityModuleEnabled", true);
        DURABILITY_VANILLA_MODE = BUILDER.comment("What type of gear should take vanilla durability damage. Default: NONE").defineEnum("vanillaDurabilityGearType", (Enum)VanillaDurabilityMode.NONE);
        BUILDER.push("Vanilla-Mode-Item-Configs");
        DURABILITY_VANILLA_MODE_WHITELIST = BUILDER.comment("If specified, the only items or item tags to take vanilla durability damage (Ignores durability mode)").defineList("vanillaDurabilityWhitelist", List.of(), x -> true);
        DURABILITY_VANILLA_MODE_BLACKLIST = BUILDER.comment("If specified, these items or item tags never take vanilla durability damage").defineList("vanillaDurabilityBlacklist", List.of(), x -> true);
        BUILDER.pop();
        DURABILITY_DEATH_MODE = BUILDER.comment("What type of gear is damaged upon death. Default: ALL").defineEnum("deathGearType", (Enum)DeathDurabilityMode.ALL);
        BUILDER.push("Death-Mode-Item-Configs");
        DURABILITY_DEATH_MODE_WHITELIST = BUILDER.comment("If specified, the only items or item tags to take durability damage on death (Ignores durability mode)").defineList("deathDurabilityWhitelist", List.of(), x -> true);
        DURABILITY_DEATH_MODE_BLACKLIST = BUILDER.comment("If specified, these items or item tags never take durability damage on death").defineList("deathDurabilityBlacklist", List.of(), x -> true);
        BUILDER.pop();
        DURABILITY_LOST_ON_DEATH = BUILDER.comment("The percent of durability damage equipment should take on player dying. Set to 0 to disable. Default: 0.15 (15%)").define("durabilityLostOnDeath", (Object)0.15);
        ADDITIONAL_DURABILITY_LOST_ON_DEATH = BUILDER.comment("An additional constant amount of damage taken on death. This makes items with a high max durability degrade relatively slower. Set to 0 to disable. Default: 25").define("additionalDurabilityLostOnDeath", (Object)25);
        BUILDER.pop();
        BUILDER.push("XP-Module");
        XP_MODULE_ENABLED = BUILDER.comment("The purpose of the xp module is to rework how experience is dropped on a player's death by creating a souls-like xp catalyst instead. Disabling will nullify every feature listed under this module.").define("xpModuleEnabled", true);
        XP_IGNORE_KEEPINVENTORY = BUILDER.comment("Whether players will drop xp despite keepInventory gamerule. Default: true").define("ignoreKeepInventory", true);
        XP_ONLY_ALLOW_OWNER = BUILDER.comment("Whether the player who dropped the xp is the only player allow to collect the xp. Default: true").define("onlyAllowOwnerPickup", true);
        ENTITY_XP_MODIFIER = BUILDER.comment("Multiplier to experience dropped by slain entities. Default: 1.0").define("mobDropXpMultiplier", (Object)1.0);
        BLOCK_XP_MODIFIER = BUILDER.comment("Multiplier to experience dropped by blocks broken. Default: 1.0").define("blockDropXpMultiplier", (Object)1.0);
        BUILDER.pop();
        BUILDER.push("Hunger-Module");
        HUNGER_MODULE_ENABLED = BUILDER.comment("The hunger module removes hunger and makes food to directly heal in order to to remove the tedious task of maintaining hunger, as well as rebalance health management during combat and exploration. Disabling will nullify every feature listed under this module.").define("hungerModuleEnable", true);
        HUNGER_DISABLED = BUILDER.comment("Disable Hunger. Without this, most of the hunger module features and config are nullified, but if you want to adjust stack sizes or potion mechanics without disabling hunger, you can do so here.").define("disableHunger", true);
        HUNGER_PREVENTS_SPRINTING = BUILDER.comment("Whether the Hunger status effect prevents the player from sprinting. Default: true").define("hungerEffectPreventsSprinting", true);
        ALLOW_SPRINTING = BUILDER.comment("Whether sprinting is allowed. Default: true").define("allowSprinting", true);
        FOOD_TO_HEALTH_MODIFIER = BUILDER.comment("The multiplier of a food's hunger value to health regained by eating it. Default: 0.5 (50%)").define("foodToHealthModifier", (Object)0.5);
        HUNGER_NUTRITION_MULTIPLIER = BUILDER.comment("An additional multiplier to the health regained by eating while under the Hunger status effect. Default: 0.5 (50%)").define("hungerEffectHealMultiplier", (Object)0.5);
        NATURAL_REGENERATION_TICK_RATE = BUILDER.comment("The amount of time, in ticks, between players naturally regenerating 1 hp. 1 second is 20 ticks. Turn off the naturalRegeneration gamerule to disable. Default: 250.").define("naturalRegenerationTickRate", (Object)250);
        NATURAL_REGENERATION_DURING_COMBAT = BUILDER.comment("Whether players should naturally regenerate hp during combat. (Turn off the naturalRegeneration gamerule to disable all natural regen). Default: false.").define("naturalRegenerationDuringCombat", false);
        SPLASH_POTION_COOLDOWN = BUILDER.comment("Item Cooldown in seconds when throwing a splash potion. Default: 0.5").define("splashPotionCooldown", (Object)0.5);
        LINGERING_POTION_COOLDOWN = BUILDER.comment("Item Cooldown in seconds when throwing a lingering potion. Default: 1.5").define("lingeringPotionCooldown", (Object)1.5);
        DRINKABLE_POTION_COOLDOWN = BUILDER.comment("Item Cooldown in seconds for drinking a potion. Default: 0.0").define("drinkPotionCooldown", (Object)0.0);
        FOOD_COOLDOWN = BUILDER.comment("Item Cooldown in seconds for eating a food item. Default: 0.0").define("eatFoodCooldown", (Object)0.0);
        EAT_TIME_MULTIPLIER = BUILDER.comment("Multiplier to the time taken to eat food. Default: 1.2").define("eatTimeMultiplier", (Object)1.2);
        POTION_DRINK_TIME_MULTIPLER = BUILDER.comment("Multiplier to the time taken to drink potions. Default: 0.8").define("potionDrinkTimeMultiplier", (Object)0.8);
        FOOD_STACK_SIZE = BUILDER.comment("Limit on stack size of foods with 5 hunger or more. Set to -1 to leave unchanged. Default: -1").define("foodStackSize", (Object)-1);
        POTION_STACK_SIZE = BUILDER.comment("Limit on stack size of all potion types. Set to -1 to leave unchanged. Default: 4").define("potionStackSize", (Object)4);
        BUILDER.pop();
        BUILDER.push("Sleep-Module");
        SLEEP_MODULE_ENABLED = BUILDER.comment("The sleep module addresses imbalance caused by the ease of skipping nights via sleeping. Disabling will nullify every feature listed under this module.").define("sleepModuleEnabled", true);
        BUILDER.pop();
        SPEC = BUILDER.build();
        DEFAULT_COMPONENTS_PATCH = new HashMap<Holder<Item>, Consumer<DataComponentPatch.Builder>>();
    }

    public static class RegistryLists {
        public static final Set<Item> DURABILITY_VANILLA_MODE_WHITELIST_ITEMS = new HashSet<Item>();
        public static final Set<Item> DURABILITY_VANILLA_MODE_BLACKLIST_ITEMS = new HashSet<Item>();
        public static final Set<Item> DURABILITY_DEATH_MODE_WHITELIST_ITEMS = new HashSet<Item>();
        public static final Set<Item> DURABILITY_DEATH_MODE_BLACKLIST_ITEMS = new HashSet<Item>();
        public static final Set<EntityType<?>> ENTITY_IFRAME_BLACKLIST = new HashSet();
        public static final Set<Item> FOOD_STACK_BLACKLIST_ITEMS = new HashSet<Item>();
    }
}

