/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsrpgtweaks.damage_module;

import io.redspace.ironsrpgtweaks.config.ServerConfigs;
import io.redspace.ironsrpgtweaks.damage_module.IRpgLivingEntityExtension;
import io.redspace.ironsrpgtweaks.damage_module.PlayerDamageMode;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingKnockBackEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber
public class DamageServerEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onIncomingDamage(LivingIncomingDamageEvent event) {
        if (((Boolean)ServerConfigs.DAMAGE_MODULE_ENABLED.get()).booleanValue()) {
            boolean ignoreDamage;
            DamageSource source = event.getSource();
            LivingEntity entity = event.getEntity();
            Level level = entity.level();
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            Entity entity2 = source.getDirectEntity();
            if (entity2 instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)entity2;
                event.getContainer().setPostAttackInvulnerabilityTicks(0);
            }
            if (!DamageServerEvents.shouldProcess(source, entity)) {
                return;
            }
            IRpgLivingEntityExtension livingExtension = (IRpgLivingEntityExtension)entity;
            int lastActuallyHurtTimestamp = livingExtension.rpg_tweaks$getHurtTracker().getOrDefault((Object)source.typeHolder(), -1);
            int currentTick = entity.tickCount;
            int lastDamageRequestTimestamp = livingExtension.rpg_tweaks$getRequestDamageTracker().getOrDefault((Object)source.typeHolder(), -1);
            boolean isDamageRepeatTick = currentTick - lastDamageRequestTimestamp == 1;
            boolean isDamageSameTick = currentTick - lastDamageRequestTimestamp <= 0 && !DamageServerEvents.canBypassSameTick(event.getSource());
            boolean bl = ignoreDamage = event.getEntity().invulnerableTime > 0 || (isDamageRepeatTick || isDamageSameTick) && currentTick - lastActuallyHurtTimestamp < 10;
            if (ignoreDamage && event.getContainer().getPostAttackInvulnerabilityTicks() != 0) {
                event.setCanceled(true);
            }
            livingExtension.rpg_tweaks$updateLastRequest((Holder<DamageType>)source.typeHolder(), currentTick);
        }
    }

    private static boolean canBypassSameTick(DamageSource source) {
        ResourceKey key = source.typeHolder().getKey();
        if (key != null) {
            return ((List)ServerConfigs.SAME_TICK_DAMAGE_TYPE_WHITELIST.get()).contains(key.location().toString());
        }
        return false;
    }

    @SubscribeEvent
    public static void onTakeDamage(LivingDamageEvent.Post event) {
        if (((Boolean)ServerConfigs.DAMAGE_MODULE_ENABLED.get()).booleanValue() && DamageServerEvents.shouldProcess(event.getSource(), event.getEntity())) {
            event.getEntity().invulnerableTime = (Integer)ServerConfigs.IFRAME_COUNT.get();
            IRpgLivingEntityExtension entityExtension = (IRpgLivingEntityExtension)event.getEntity();
            entityExtension.rpg_tweaks$updateLastHurt((Holder<DamageType>)event.getSource().typeHolder(), event.getEntity().tickCount);
        }
    }

    @SubscribeEvent
    public static void onPlayerAttack(AttackEntityEvent event) {
        if (((Boolean)ServerConfigs.DAMAGE_MODULE_ENABLED.get()).booleanValue()) {
            Level level = event.getEntity().level();
            if (level.isClientSide) {
                return;
            }
            if (!(event.getEntity() instanceof FakePlayer) && (double)event.getEntity().getAttackStrengthScale(0.0f) < (Double)ServerConfigs.MINIMUM_ATTACK_STRENGTH.get()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void modifyKnockback(LivingKnockBackEvent event) {
        if (((Boolean)ServerConfigs.DAMAGE_MODULE_ENABLED.get()).booleanValue()) {
            event.setStrength((float)((double)event.getStrength() * (Double)ServerConfigs.KNOCKBACK_MODIFIER.get()));
        }
    }

    @SubscribeEvent
    public static void onLivingTick(EntityTickEvent.Post event) {
        Entity entity;
        if (((Boolean)ServerConfigs.DAMAGE_MODULE_ENABLED.get()).booleanValue() && (entity = event.getEntity()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity.tickCount % 600 == 0) {
                ((IRpgLivingEntityExtension)livingEntity).rpg_tweaks$garbageCollect(livingEntity.tickCount);
            }
        }
    }

    private static boolean shouldProcess(DamageSource source, LivingEntity entityBeingAttacked) {
        if (((Boolean)ServerConfigs.DAMAGE_MODULE_ENABLED.get()).booleanValue()) {
            return (source.getDirectEntity() == null || ServerConfigs.RegistryLists.ENTITY_IFRAME_BLACKLIST.isEmpty() || !ServerConfigs.RegistryLists.ENTITY_IFRAME_BLACKLIST.contains(source.getDirectEntity().getType())) && (!(entityBeingAttacked instanceof Player) || ServerConfigs.PLAYER_DAMAGE_MODE.get() == PlayerDamageMode.ALL || ServerConfigs.PLAYER_DAMAGE_MODE.get() == PlayerDamageMode.ONLY_LIVING && source.getDirectEntity() instanceof LivingEntity);
        }
        return false;
    }
}

