/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsrpgtweaks.durability_module;

import io.redspace.ironsrpgtweaks.config.ConfigHelper;
import io.redspace.ironsrpgtweaks.config.ServerConfigs;
import io.redspace.ironsrpgtweaks.durability_module.DeathDurabilityMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

@EventBusSubscriber
public class DurabilityServerEvents {
    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            if ((Double)ServerConfigs.DURABILITY_LOST_ON_DEATH.get() == 0.0 && (Integer)ServerConfigs.ADDITIONAL_DURABILITY_LOST_ON_DEATH.get() == 0 || !((Boolean)ServerConfigs.DURABILITY_MODULE_ENABLED.get()).booleanValue() || serverPlayer.gameMode.isCreative()) {
                return;
            }
            DeathDurabilityMode mode = (DeathDurabilityMode)((Object)ServerConfigs.DURABILITY_DEATH_MODE.get());
            Inventory inventory = serverPlayer.getInventory();
            if (mode.shouldDamageTools()) {
                DurabilityServerEvents.damageItems(DurabilityServerEvents.getHotbarItems(inventory), serverPlayer);
            }
            if (mode.shouldDamageArmor()) {
                DurabilityServerEvents.damageItems(DurabilityServerEvents.getArmorItems(inventory), serverPlayer);
            }
        }
    }

    private static void damageItems(List<ItemStack> items, ServerPlayer serverPlayer) {
        for (ItemStack itemstack : items) {
            Level level;
            if (!itemstack.isDamageableItem() || !ConfigHelper.Durability.shouldTakeDeathDamage(itemstack)) continue;
            int i = DurabilityServerEvents.getUnbreakingDivisor(itemstack, serverPlayer.registryAccess());
            int damageAmount = (int)((double)itemstack.getMaxDamage() * (Double)ServerConfigs.DURABILITY_LOST_ON_DEATH.get()) + (Integer)ServerConfigs.ADDITIONAL_DURABILITY_LOST_ON_DEATH.get();
            itemstack.setDamageValue(itemstack.getDamageValue() + (damageAmount /= i));
            Component component = itemstack.getDisplayName();
            if (!(component instanceof MutableComponent)) continue;
            MutableComponent itemName = (MutableComponent)component;
            if (itemstack.getDamageValue() < itemstack.getMaxDamage()) {
                if (itemstack.getMaxDamage() - itemstack.getDamageValue() < damageAmount) {
                    serverPlayer.sendSystemMessage((Component)Component.translatable((String)"ui.irons_rpg_tweaks.item_damaged_critical", (Object[])new Object[]{itemName.withStyle(Style.EMPTY.withColor(ChatFormatting.YELLOW).withItalic(Boolean.valueOf(false))), damageAmount}).setStyle(Style.EMPTY.withColor(ChatFormatting.YELLOW).withItalic(Boolean.valueOf(true))));
                } else {
                    serverPlayer.sendSystemMessage((Component)Component.translatable((String)"ui.irons_rpg_tweaks.item_damaged", (Object[])new Object[]{itemName.withStyle(Style.EMPTY.withColor(ChatFormatting.GRAY).withItalic(Boolean.valueOf(false))), damageAmount}).setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY).withItalic(Boolean.valueOf(true))));
                }
            }
            if (!((level = serverPlayer.level()) instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            itemstack.hurtAndBreak(0, serverLevel, serverPlayer, item -> {
                serverPlayer.sendSystemMessage((Component)Component.translatable((String)"ui.irons_rpg_tweaks.item_broken", (Object[])new Object[]{itemName.withStyle(Style.EMPTY.withColor(ChatFormatting.RED).withItalic(Boolean.valueOf(false)))}).setStyle(Style.EMPTY.withColor(ChatFormatting.RED).withItalic(Boolean.valueOf(true))));
                if (item instanceof ArmorItem) {
                    ArmorItem armorItem = (ArmorItem)item;
                    serverPlayer.onEquippedItemBroken((Item)armorItem, armorItem.getEquipmentSlot());
                } else {
                    serverPlayer.onEquippedItemBroken(item, EquipmentSlot.MAINHAND);
                }
            });
        }
    }

    private static int getUnbreakingDivisor(ItemStack itemstack, RegistryAccess access) {
        Optional unbreaking;
        int i = 1;
        Registry registry = access.registry(Registries.ENCHANTMENT).orElse(null);
        if (registry != null && (unbreaking = registry.getHolder(Enchantments.UNBREAKING)).isPresent()) {
            i += itemstack.getEnchantmentLevel((Holder)unbreaking.get());
        }
        return i;
    }

    private static List<ItemStack> getHotbarItems(Inventory inventory) {
        ArrayList<ItemStack> hotbarItems = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.getContainerSize() && i < 9; ++i) {
            ItemStack item = inventory.getItem(i);
            if (item.isEmpty()) continue;
            hotbarItems.add(item);
        }
        if (!((ItemStack)inventory.offhand.get(0)).isEmpty()) {
            hotbarItems.add((ItemStack)inventory.offhand.get(0));
        }
        return hotbarItems;
    }

    private static List<ItemStack> getArmorItems(Inventory inventory) {
        ArrayList<ItemStack> armorItems = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.armor.size(); ++i) {
            ItemStack item = (ItemStack)inventory.armor.get(i);
            if (item.isEmpty()) continue;
            armorItems.add(item);
        }
        return armorItems;
    }

    private static String printInventory(Inventory inventory) {
        Object str = "";
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            str = (String)str + inventory.getItem(i).getHoverName().getString() + ",";
        }
        return str;
    }
}

