/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsrpgtweaks.hunger_module;

import io.redspace.ironsrpgtweaks.config.ServerConfigs;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber
public class CommonHungerEvents {
    public static void modifyDefaultStackSize(BiConsumer<Holder<Item>, Consumer<DataComponentPatch.Builder>> modifyCallback) {
        if (!((Boolean)ServerConfigs.HUNGER_MODULE_ENABLED.get()).booleanValue()) {
            return;
        }
        int food = (Integer)ServerConfigs.FOOD_STACK_SIZE.get();
        int potions = (Integer)ServerConfigs.POTION_STACK_SIZE.get();
        if (potions > 1) {
            modifyCallback.accept((Holder<Item>)BuiltInRegistries.ITEM.wrapAsHolder((Object)Items.POTION), builder -> builder.set(DataComponents.MAX_STACK_SIZE, (Object)Math.min(potions, 99)));
            modifyCallback.accept((Holder<Item>)BuiltInRegistries.ITEM.wrapAsHolder((Object)Items.SPLASH_POTION), builder -> builder.set(DataComponents.MAX_STACK_SIZE, (Object)Math.min(potions, 99)));
            modifyCallback.accept((Holder<Item>)BuiltInRegistries.ITEM.wrapAsHolder((Object)Items.LINGERING_POTION), builder -> builder.set(DataComponents.MAX_STACK_SIZE, (Object)Math.min(potions, 99)));
        }
        if (food > 0) {
            for (Item item : BuiltInRegistries.ITEM) {
                FoodProperties fooddata = (FoodProperties)item.components().get(DataComponents.FOOD);
                if (fooddata == null || fooddata.nutrition() < 5 && !fooddata.effects().stream().anyMatch(possibleEffect -> ((MobEffect)possibleEffect.effect().getEffect().value()).isBeneficial())) continue;
                modifyCallback.accept((Holder<Item>)BuiltInRegistries.ITEM.wrapAsHolder((Object)item), builder -> builder.set(DataComponents.MAX_STACK_SIZE, (Object)Math.min(food, Math.min(item.getDefaultMaxStackSize(), 99))));
            }
        }
    }

    @SubscribeEvent
    public static void handleThrownPotionCooldowns(PlayerInteractEvent.RightClickItem event) {
        if (!((Boolean)ServerConfigs.HUNGER_MODULE_ENABLED.get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        if (event.getItemStack().is(Items.SPLASH_POTION) && (Double)ServerConfigs.SPLASH_POTION_COOLDOWN.get() > 0.0) {
            player.getCooldowns().addCooldown(Items.SPLASH_POTION, (int)((Double)ServerConfigs.SPLASH_POTION_COOLDOWN.get() * 20.0));
        } else if (event.getItemStack().is(Items.LINGERING_POTION) && (Double)ServerConfigs.LINGERING_POTION_COOLDOWN.get() > 0.0) {
            player.getCooldowns().addCooldown(Items.LINGERING_POTION, (int)((Double)ServerConfigs.LINGERING_POTION_COOLDOWN.get() * 20.0));
        }
    }

    @SubscribeEvent
    public static void handleConsumableCooldowns(LivingEntityUseItemEvent.Finish event) {
        if (!((Boolean)ServerConfigs.HUNGER_MODULE_ENABLED.get()).booleanValue()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ItemStack stack = event.getItem();
            if (stack.is(Items.POTION) && (Double)ServerConfigs.DRINKABLE_POTION_COOLDOWN.get() > 0.0 && ((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).hasEffects()) {
                player.getCooldowns().addCooldown(Items.POTION, (int)((Double)ServerConfigs.DRINKABLE_POTION_COOLDOWN.get() * 20.0));
            }
            if (stack.has(DataComponents.FOOD) && (Double)ServerConfigs.FOOD_COOLDOWN.get() > 0.0) {
                player.getCooldowns().addCooldown(stack.getItem(), (int)((Double)ServerConfigs.FOOD_COOLDOWN.get() * 20.0));
            }
        }
    }
}

