/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsrpgtweaks.mixin;

import io.redspace.ironsrpgtweaks.config.ConfigHelper;
import io.redspace.ironsrpgtweaks.config.ServerConfigs;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FoodData.class})
public class FoodDataMixin {
    @Shadow
    int foodLevel;
    @Shadow
    int lastFoodLevel;
    @Unique
    float rpg_tweaks$toHeal;

    @Inject(method={"Lnet/minecraft/world/food/FoodData;add(IF)V"}, remap=false, at={@At(value="HEAD")}, cancellable=true)
    public void hungerToHealth(int nutritionToAdd, float saturationToAdd, CallbackInfo ci) {
        if (!ConfigHelper.Hunger.shouldDisableVanillaHunger()) {
            return;
        }
        this.rpg_tweaks$toHeal = (float)((double)nutritionToAdd * (Double)ServerConfigs.FOOD_TO_HEALTH_MODIFIER.get());
        ci.cancel();
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void heal(Player pPlayer, CallbackInfo ci) {
        if (!ConfigHelper.Hunger.shouldDisableVanillaHunger()) {
            return;
        }
        if (this.rpg_tweaks$toHeal > 0.0f) {
            if (pPlayer.hasEffect(MobEffects.HUNGER)) {
                pPlayer.heal(this.rpg_tweaks$toHeal * ((Double)ServerConfigs.HUNGER_NUTRITION_MULTIPLIER.get()).floatValue());
            } else {
                pPlayer.heal(this.rpg_tweaks$toHeal);
            }
            this.rpg_tweaks$toHeal = 0.0f;
        }
    }
}

