/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsrpgtweaks.registry;

import io.redspace.ironsrpgtweaks.config.ServerConfigs;
import io.redspace.ironsrpgtweaks.sleep_module.DrowsyMobEffect;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class PotionEffectsRegistry {
    private static final DeferredRegister<MobEffect> MOB_EFFECTS = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"irons_rpg_tweaks");
    private static final DeferredRegister<Potion> POTIONS = DeferredRegister.create((ResourceKey)Registries.POTION, (String)"irons_rpg_tweaks");
    public static final DeferredHolder<MobEffect, MobEffect> DROWSY_EFFECT = MOB_EFFECTS.register("drowsy", () -> new DrowsyMobEffect(MobEffectCategory.BENEFICIAL, 0xAAAAFF){

        public boolean isEnabled(FeatureFlagSet enabledFeatures) {
            return super.isEnabled(enabledFeatures) && (Boolean)ServerConfigs.SLEEP_MODULE_ENABLED.get() != false;
        }
    });
    public static final DeferredHolder<Potion, Potion> DROWSY_POTION = POTIONS.register("drowsy", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance(DROWSY_EFFECT, 1200)}){

        public boolean isEnabled(FeatureFlagSet enabledFeatures) {
            return super.isEnabled(enabledFeatures) && (Boolean)ServerConfigs.SLEEP_MODULE_ENABLED.get() != false;
        }
    });

    @SubscribeEvent
    public static void addRecipes(RegisterBrewingRecipesEvent event) {
        ItemStack awkward = new ItemStack((ItemLike)Items.POTION);
        awkward.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.AWKWARD));
        ItemStack potion = new ItemStack((ItemLike)Items.POTION);
        potion.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(DROWSY_POTION));
        event.getBuilder().addRecipe(Ingredient.of((ItemStack[])new ItemStack[]{awkward}), Ingredient.of((TagKey)ItemTags.LEAVES), potion);
    }

    public static void register(IEventBus eventBus) {
        MOB_EFFECTS.register(eventBus);
        POTIONS.register(eventBus);
    }
}

