/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsrpgtweaks.sleep_module;

import io.redspace.ironsrpgtweaks.config.ServerConfigs;
import io.redspace.ironsrpgtweaks.registry.PotionEffectsRegistry;
import io.redspace.ironsrpgtweaks.sleep_module.ICustomMobEffectDescription;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BedItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.CanPlayerSleepEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.level.SleepFinishedTimeEvent;

@EventBusSubscriber
public class SleepCommonEvents {
    @SubscribeEvent
    public static void preventPlayerSleep(CanPlayerSleepEvent event) {
        if (!((Boolean)ServerConfigs.SLEEP_MODULE_ENABLED.get()).booleanValue()) {
            return;
        }
        if (!event.getEntity().hasEffect(PotionEffectsRegistry.DROWSY_EFFECT) && event.getProblem() == null) {
            event.setProblem(Player.BedSleepingProblem.OTHER_PROBLEM);
            event.getEntity().displayClientMessage((Component)Component.translatable((String)"ui.irons_rpg_tweaks.sleep_failure").withStyle(ChatFormatting.RED), true);
        }
    }

    @SubscribeEvent
    public static void clearDrowsiness(SleepFinishedTimeEvent event) {
        MinecraftServer server = event.getLevel().getServer();
        if (server != null) {
            server.getPlayerList().getPlayers().forEach(player -> player.removeEffect(PotionEffectsRegistry.DROWSY_EFFECT));
        }
    }

    @SubscribeEvent
    public static void handleTooltips(ItemTooltipEvent event) {
        Item item;
        if (!((Boolean)ServerConfigs.SLEEP_MODULE_ENABLED.get()).booleanValue()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        PotionContents potionData = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
        if (potionData != null) {
            potionData.getAllEffects().forEach(mobEffectInstance -> {
                Object patt0$temp = mobEffectInstance.getEffect().value();
                if (patt0$temp instanceof ICustomMobEffectDescription) {
                    ICustomMobEffectDescription customDescriptionMobEffect = (ICustomMobEffectDescription)patt0$temp;
                    ICustomMobEffectDescription.handleCustomPotionTooltip(stack, event.getToolTip(), event.getFlags().isAdvanced(), mobEffectInstance, customDescriptionMobEffect);
                }
            });
        }
        if ((item = stack.getItem()) instanceof BedItem) {
            BedItem bedItem = (BedItem)item;
            event.getToolTip().add(1, Component.translatable((String)"ui.irons_rpg_tweaks.bed_tooltip").withStyle(ChatFormatting.GOLD));
        }
    }
}

