/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsrpgtweaks.xp_module;

import io.redspace.ironsrpgtweaks.IronsRpgTweaks;
import io.redspace.ironsrpgtweaks.config.ServerConfigs;
import io.redspace.ironsrpgtweaks.xp_module.entity.XpCatalyst;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockDropsEvent;

@EventBusSubscriber
public class XpServerEvents {
    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            IronsRpgTweaks.LOGGER.debug("Levels: {}\nPoints: {}\nTotal: {}", new Object[]{serverPlayer.experienceLevel, Float.valueOf(serverPlayer.experienceProgress), serverPlayer.totalExperience});
            if (XpServerEvents.shouldCreateCatalyst(serverPlayer.level())) {
                XpCatalyst.createXpCatalyst(serverPlayer);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        ServerPlayer serverPlayer;
        Player player;
        if (!event.isEndConquered() && (player = event.getEntity()) instanceof ServerPlayer && XpServerEvents.shouldCreateCatalyst((serverPlayer = (ServerPlayer)player).level())) {
            serverPlayer.setExperienceLevels(0);
            serverPlayer.setExperiencePoints(0);
        }
    }

    @SubscribeEvent
    public static void onXpDropped(LivingExperienceDropEvent event) {
        ServerPlayer serverPlayer;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer && XpServerEvents.shouldCreateCatalyst((serverPlayer = (ServerPlayer)livingEntity).level())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void modifyEntityXp(LivingExperienceDropEvent event) {
        if (((Boolean)ServerConfigs.XP_MODULE_ENABLED.get()).booleanValue()) {
            event.setDroppedExperience((int)((double)event.getDroppedExperience() * (Double)ServerConfigs.ENTITY_XP_MODIFIER.get()));
        }
    }

    @SubscribeEvent
    public static void modifyBlockXp(BlockDropsEvent event) {
        if (((Boolean)ServerConfigs.XP_MODULE_ENABLED.get()).booleanValue()) {
            event.setDroppedExperience((int)((double)event.getDroppedExperience() * (Double)ServerConfigs.BLOCK_XP_MODIFIER.get()));
        }
    }

    public static boolean shouldCreateCatalyst(Level level) {
        return (Boolean)ServerConfigs.XP_MODULE_ENABLED.get() != false && ((Boolean)ServerConfigs.XP_IGNORE_KEEPINVENTORY.get() != false || !level.getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY));
    }
}

