/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsrpgtweaks.xp_module.entity;

import io.redspace.ironsrpgtweaks.config.ServerConfigs;
import io.redspace.ironsrpgtweaks.registry.EntityRegistry;
import io.redspace.ironsrpgtweaks.registry.SoundRegistry;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class XpCatalyst
extends Entity {
    UUID ownerUUID;
    int storedXp;

    public XpCatalyst(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public XpCatalyst(Level level) {
        this((EntityType)EntityRegistry.XP_CATALYST.get(), level);
    }

    @Nullable
    public static XpCatalyst createXpCatalyst(ServerPlayer deadPlayer) {
        if (deadPlayer.experienceLevel == 0 && deadPlayer.experienceProgress == 0.0f) {
            return null;
        }
        XpCatalyst xpCatalyst = new XpCatalyst(deadPlayer.level());
        xpCatalyst.storedXp = (int)(deadPlayer.experienceProgress * (float)deadPlayer.getXpNeededForNextLevel());
        int level = deadPlayer.experienceLevel;
        for (int i = level - 1; i >= 0; --i) {
            xpCatalyst.storedXp += xpCatalyst.getXpNeededForLevel(i);
        }
        xpCatalyst.ownerUUID = deadPlayer.getUUID();
        xpCatalyst.setPos(deadPlayer.position().add(0.0, 0.75, 0.0));
        deadPlayer.level().addFreshEntity((Entity)xpCatalyst);
        return xpCatalyst;
    }

    public int getXpNeededForLevel(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        return level >= 15 ? 37 + (level - 15) * 5 : 7 + level * 2;
    }

    public float getVisualYOffset(float partialTick) {
        return Mth.sin((float)(((float)this.tickCount + partialTick) * 0.04f)) * 0.25f;
    }

    public void tick() {
        if (this.level().isClientSide) {
            this.level().addParticle((ParticleOptions)ParticleTypes.TOTEM_OF_UNDYING, this.getRandomX(0.125), this.getRandomY(), this.getRandomZ(0.125), 0.0, 0.07, 0.0);
        }
        if (this.firstTick) {
            this.firstTick = false;
        }
        this.checkBelowWorld();
    }

    public boolean canBeHitByProjectile() {
        return false;
    }

    public boolean isPickable() {
        return true;
    }

    @NotNull
    public InteractionResult interact(Player player, InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (player.getUUID().equals(this.ownerUUID) || !((Boolean)ServerConfigs.XP_ONLY_ALLOW_OWNER.get()).booleanValue()) {
                player.giveExperiencePoints(this.storedXp);
                this.playSound((SoundEvent)SoundRegistry.RETRIEVE_XP.get());
                this.discard();
                return InteractionResult.SUCCESS;
            }
            serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"ui.irons_rpg_tweaks.xp_retrieve_error").withStyle(ChatFormatting.RED)));
        }
        return super.interact(player, hand);
    }

    public boolean shouldBeSaved() {
        return true;
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        if (tag.hasUUID("Owner")) {
            this.ownerUUID = tag.getUUID("Owner");
        }
        this.storedXp = tag.getInt("StoredXp");
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        if (this.ownerUUID != null) {
            tag.putUUID("Owner", this.ownerUUID);
        }
        tag.putInt("StoredXp", this.storedXp);
    }
}

