/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsrpgtweaks.xp_module.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.redspace.ironsrpgtweaks.IronsRpgTweaks;
import io.redspace.ironsrpgtweaks.xp_module.entity.XpCatalyst;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class XpCatalystRenderer
extends EntityRenderer<XpCatalyst> {
    public static final ModelLayerLocation MODEL_LAYER_LOCATION = new ModelLayerLocation(IronsRpgTweaks.id("xp_catalyst_model"), "main");
    private static final ResourceLocation ORB_TEXTURE = IronsRpgTweaks.id("textures/entity/xp_catalyst/xp_catalyst_orb.png");
    private static final ResourceLocation SOLID_TEXTURE = IronsRpgTweaks.id("textures/entity/xp_catalyst/solid.png");
    private final ModelPart orb;
    private final ModelPart swirl;
    private final ModelPart swirl2;
    static final Vec3 green = new Vec3((double)0.15f, 1.0, (double)0.2f);
    static final Vec3 yellow = new Vec3((double)0.9f, (double)0.9f, (double)0.2f);
    static final Vec3 white = new Vec3(1.0, 1.0, 1.0);
    static final Vec3 purple = new Vec3(1.0, (double)0.63f, 1.0);

    public XpCatalystRenderer(EntityRendererProvider.Context context) {
        super(context);
        ModelPart modelpart = context.bakeLayer(MODEL_LAYER_LOCATION);
        this.orb = modelpart.getChild("orb");
        this.swirl = modelpart.getChild("swirl");
        this.swirl2 = modelpart.getChild("swirl2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("orb", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("swirl", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("swirl2", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)8, (int)8);
    }

    public void render(XpCatalyst entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        poseStack.pushPose();
        poseStack.translate(0.0, entity.getBoundingBox().getYsize() * 0.5 + (double)entity.getVisualYOffset(partialTicks), 0.0);
        float scale = 1.0f + Mth.sin((float)(((float)entity.tickCount + partialTicks) * 0.06f)) * 0.05f;
        poseStack.scale(scale, scale, scale);
        poseStack.scale(0.6f, 0.6f, 0.6f);
        float f = (float)entity.tickCount + partialTicks;
        poseStack.pushPose();
        poseStack.scale(0.4f, 0.4f, 0.4f);
        float orbColorPeriod = (Mth.sin((float)(f * 0.04f)) + 1.0f) * 0.5f;
        float colorPeriod = (Mth.sin((float)(f * 0.08f)) + 1.0f) * 0.5f;
        float swirlX = Mth.cos((float)(0.05f * f)) * 90.0f;
        float swirlY = Mth.sin((float)(0.05f * f)) * 90.0f;
        float swirlZ = Mth.cos((float)(0.05f * f + 5464.0f)) * 90.0f;
        Vec3 orbGradient1 = green.add(yellow.subtract(green).scale((double)orbColorPeriod));
        Vec3 orbGradient2 = white.add(purple.subtract(white).scale((double)orbColorPeriod));
        Vec3 orbGradient3 = orbGradient1.add(orbGradient2.subtract(orbGradient1).scale((double)colorPeriod));
        poseStack.mulPose(Axis.XP.rotationDegrees(swirlX * 0.45f));
        poseStack.mulPose(Axis.YP.rotationDegrees(swirlY * 0.45f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(swirlZ * 0.45f));
        VertexConsumer consumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)SOLID_TEXTURE));
        this.orb.render(poseStack, consumer, 0xF000F0, OverlayTexture.NO_OVERLAY, XpCatalystRenderer.colorf((float)orbGradient3.x, (float)orbGradient3.y, (float)orbGradient3.z, 1.0f));
        poseStack.popPose();
        consumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.getTextureLocation(entity)));
        poseStack.mulPose(Axis.XP.rotationDegrees(swirlX));
        poseStack.mulPose(Axis.YP.rotationDegrees(swirlY));
        poseStack.mulPose(Axis.ZP.rotationDegrees(swirlZ));
        Vec3 rimGradient = green.add(yellow.subtract(green).scale((double)colorPeriod));
        Vec3 rimGradientInverted = green.add(yellow.subtract(green).scale((double)(1.0f - colorPeriod)));
        this.orb.render(poseStack, consumer, 0xF000F0, OverlayTexture.NO_OVERLAY, XpCatalystRenderer.colorf((float)rimGradient.x, (float)rimGradient.y, (float)rimGradient.z, 1.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(swirlZ));
        poseStack.mulPose(Axis.YP.rotationDegrees(swirlX));
        poseStack.mulPose(Axis.ZP.rotationDegrees(swirlY));
        poseStack.scale(1.5f, 1.5f, 1.5f);
        this.swirl.render(poseStack, consumer, 0xF000F0, OverlayTexture.NO_OVERLAY, XpCatalystRenderer.colorf((float)rimGradientInverted.x, (float)rimGradientInverted.y, (float)rimGradientInverted.z, 1.0f));
        poseStack.popPose();
        super.render((Entity)entity, yaw, partialTicks, poseStack, bufferSource, light);
    }

    public ResourceLocation getTextureLocation(XpCatalyst entity) {
        return ORB_TEXTURE;
    }

    private static void vertex(VertexConsumer pBuffer, Matrix4f pMatrix, Matrix3f pMatrixNormal, float pX, float pY, int pRed, int pGreen, int pBlue, float pTexU, float pTexV, int pPackedLight) {
        pBuffer.addVertex(pX, pY, 0.0f).setColor(pRed, pGreen, pBlue, 128).setUv(pTexU, pTexV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(pPackedLight).setNormal(0.0f, 1.0f, 0.0f);
    }

    public static int color255(int pRed, int pGreen, int pBlue, int pAlpha) {
        return pAlpha << 24 | pRed << 16 | pGreen << 8 | pBlue;
    }

    public static int color255(int pRed, int pGreen, int pBlue) {
        return XpCatalystRenderer.color255(pRed, pGreen, pBlue, 255);
    }

    public static int colorf(float pRed, float pGreen, float pBlue, float pAlpha) {
        return XpCatalystRenderer.color255((int)(255.0f * pRed), (int)(255.0f * pGreen), (int)(255.0f * pBlue), (int)(255.0f * pAlpha));
    }

    public static int colorf(float pRed, float pGreen, float pBlue) {
        return XpCatalystRenderer.colorf(pRed, pGreen, pBlue, 1.0f);
    }
}

