/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsrpgtweaks.config;

import io.redspace.ironsrpgtweaks.config.ServerConfigs;
import io.redspace.ironsrpgtweaks.durability_module.DeathDurabilityMode;
import io.redspace.ironsrpgtweaks.durability_module.VanillaDurabilityMode;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;

public class ConfigHelper {

    public static class Hunger {
        public static double useDurationMultiplier(ItemStack item) {
            if (((Boolean)ServerConfigs.HUNGER_MODULE_ENABLED.get()).booleanValue()) {
                if (item.m_41614_()) {
                    return (Double)ServerConfigs.EAT_TIME_MULTIPLIER.get();
                }
                if (item.m_41720_() instanceof PotionItem) {
                    return (Double)ServerConfigs.POTION_DRINK_TIME_MULTIPLER.get();
                }
            }
            return 1.0;
        }

        public static boolean canSprint(LivingEntity entity) {
            return !((Boolean)ServerConfigs.HUNGER_PREVENTS_SPRINTING.get() != false && entity.m_21023_(MobEffects.f_19612_) || (Boolean)ServerConfigs.ALLOW_SPRINTING.get() == false && !entity.m_5842_());
        }

        public static boolean shouldDisableVanillaHunger() {
            return (Boolean)ServerConfigs.HUNGER_DISABLED.get() != false && (Boolean)ServerConfigs.HUNGER_MODULE_ENABLED.get() != false;
        }
    }

    public static class Damage {
    }

    public static class Durability {
        public static boolean shouldTakeVanillaDamage(ItemStack itemStack) {
            if (!((Boolean)ServerConfigs.DURABILITY_MODULE_ENABLED.get()).booleanValue()) {
                return true;
            }
            if (ServerConfigs.RegistryLists.DURABILITY_VANILLA_MODE_BLACKLIST_ITEMS.contains(itemStack.m_41720_())) {
                return false;
            }
            if (!ServerConfigs.RegistryLists.DURABILITY_VANILLA_MODE_WHITELIST_ITEMS.isEmpty()) {
                return ServerConfigs.RegistryLists.DURABILITY_VANILLA_MODE_WHITELIST_ITEMS.contains(itemStack.m_41720_());
            }
            VanillaDurabilityMode mode = (VanillaDurabilityMode)((Object)ServerConfigs.DURABILITY_VANILLA_MODE.get());
            if (mode == VanillaDurabilityMode.NONE) {
                return false;
            }
            if (mode == VanillaDurabilityMode.ALL) {
                return true;
            }
            return itemStack.m_41720_() instanceof ArmorItem ? mode == VanillaDurabilityMode.ARMOR : mode == VanillaDurabilityMode.TOOLS;
        }

        public static boolean shouldTakeDeathDamage(ItemStack itemStack) {
            if (!((Boolean)ServerConfigs.DURABILITY_MODULE_ENABLED.get()).booleanValue()) {
                return false;
            }
            if (ServerConfigs.RegistryLists.DURABILITY_DEATH_MODE_BLACKLIST_ITEMS.contains(itemStack.m_41720_())) {
                return false;
            }
            if (!ServerConfigs.RegistryLists.DURABILITY_DEATH_MODE_WHITELIST_ITEMS.isEmpty()) {
                return ServerConfigs.RegistryLists.DURABILITY_DEATH_MODE_WHITELIST_ITEMS.contains(itemStack.m_41720_());
            }
            DeathDurabilityMode mode = (DeathDurabilityMode)((Object)ServerConfigs.DURABILITY_DEATH_MODE.get());
            if (mode == DeathDurabilityMode.NONE) {
                return false;
            }
            if (mode == DeathDurabilityMode.ALL) {
                return true;
            }
            return itemStack.m_41720_() instanceof ArmorItem ? mode == DeathDurabilityMode.ARMOR : mode == DeathDurabilityMode.TOOLS;
        }

        public static boolean shouldHideDurabilityBar(ItemStack itemStack) {
            if (!((Boolean)ServerConfigs.DURABILITY_MODULE_ENABLED.get()).booleanValue()) {
                return false;
            }
            return (!Durability.shouldTakeDeathDamage(itemStack) || (Integer)ServerConfigs.ADDITIONAL_DURABILITY_LOST_ON_DEATH.get() == 0 && (Double)ServerConfigs.DURABILITY_LOST_ON_DEATH.get() == 0.0) && !Durability.shouldTakeVanillaDamage(itemStack);
        }
    }
}

