/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsrpgtweaks.damage_module;

import io.redspace.ironsrpgtweaks.config.ServerConfigs;
import io.redspace.ironsrpgtweaks.damage_module.IRpgLivingEntityExtension;
import io.redspace.ironsrpgtweaks.damage_module.PlayerDamageMode;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DamageServerEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onIncomingDamage(LivingAttackEvent event) {
        if (((Boolean)ServerConfigs.DAMAGE_MODULE_ENABLED.get()).booleanValue()) {
            boolean ignoreDamage;
            DamageSource source = event.getSource();
            LivingEntity entity = event.getEntity();
            Level level = entity.m_9236_();
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            Entity entity2 = source.m_7640_();
            if (entity2 instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)entity2;
                event.getEntity().f_19802_ = 0;
            }
            if (!DamageServerEvents.shouldProcess(source, entity)) {
                return;
            }
            IRpgLivingEntityExtension livingExtension = (IRpgLivingEntityExtension)entity;
            int lastActuallyHurtTimestamp = livingExtension.rpg_tweaks$getHurtTracker().getOrDefault((Object)source.m_269150_(), -1);
            int currentTick = entity.f_19797_;
            int lastDamageRequestTimestamp = livingExtension.rpg_tweaks$getRequestDamageTracker().getOrDefault((Object)source.m_269150_(), -1);
            boolean isDamageRepeatTick = currentTick - lastDamageRequestTimestamp == 1;
            boolean isDamageSameTick = currentTick - lastDamageRequestTimestamp <= 0 && !DamageServerEvents.canBypassSameTick(event.getSource());
            boolean bl = ignoreDamage = event.getEntity().f_19802_ > 0 || (isDamageRepeatTick || isDamageSameTick) && currentTick - lastActuallyHurtTimestamp < 10;
            if (ignoreDamage) {
                event.setCanceled(true);
            }
            livingExtension.rpg_tweaks$updateLastRequest((Holder<DamageType>)source.m_269150_(), currentTick);
        }
    }

    private static boolean canBypassSameTick(DamageSource source) {
        ResourceKey key = source.m_269150_().m_203543_().orElse(null);
        if (key != null) {
            return ((List)ServerConfigs.SAME_TICK_DAMAGE_TYPE_WHITELIST.get()).contains(key.m_135782_().toString());
        }
        return false;
    }

    @SubscribeEvent
    public static void onTakeDamage(LivingDamageEvent event) {
        if (((Boolean)ServerConfigs.DAMAGE_MODULE_ENABLED.get()).booleanValue() && DamageServerEvents.shouldProcess(event.getSource(), event.getEntity())) {
            event.getEntity().f_19802_ = (Integer)ServerConfigs.IFRAME_COUNT.get();
            IRpgLivingEntityExtension entityExtension = (IRpgLivingEntityExtension)event.getEntity();
            entityExtension.rpg_tweaks$updateLastHurt((Holder<DamageType>)event.getSource().m_269150_(), event.getEntity().f_19797_);
        }
    }

    @SubscribeEvent
    public static void onPlayerAttack(AttackEntityEvent event) {
        if (((Boolean)ServerConfigs.DAMAGE_MODULE_ENABLED.get()).booleanValue()) {
            Level level = event.getEntity().m_9236_();
            if (level.f_46443_) {
                return;
            }
            if (!(event.getEntity() instanceof FakePlayer) && (double)event.getEntity().m_36403_(0.0f) < (Double)ServerConfigs.MINIMUM_ATTACK_STRENGTH.get()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void modifyKnockback(LivingKnockBackEvent event) {
        if (((Boolean)ServerConfigs.DAMAGE_MODULE_ENABLED.get()).booleanValue()) {
            event.setStrength((float)((double)event.getStrength() * (Double)ServerConfigs.KNOCKBACK_MODIFIER.get()));
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        if (((Boolean)ServerConfigs.DAMAGE_MODULE_ENABLED.get()).booleanValue() && event.getEntity().f_19797_ % 600 == 0) {
            ((IRpgLivingEntityExtension)event.getEntity()).rpg_tweaks$garbageCollect(event.getEntity().f_19797_);
        }
    }

    private static boolean shouldProcess(DamageSource source, LivingEntity entityBeingAttacked) {
        if (((Boolean)ServerConfigs.DAMAGE_MODULE_ENABLED.get()).booleanValue()) {
            return (source.m_7640_() == null || ServerConfigs.RegistryLists.ENTITY_IFRAME_BLACKLIST.isEmpty() || !ServerConfigs.RegistryLists.ENTITY_IFRAME_BLACKLIST.contains(source.m_7640_().m_6095_())) && (!(entityBeingAttacked instanceof Player) || ServerConfigs.PLAYER_DAMAGE_MODE.get() == PlayerDamageMode.ALL || ServerConfigs.PLAYER_DAMAGE_MODE.get() == PlayerDamageMode.ONLY_LIVING && source.m_7640_() instanceof LivingEntity);
        }
        return false;
    }
}

