/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsrpgtweaks.utils;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.item.ItemStack;

public class TooltipsUtils {
    public static final Style UNIQUE_STYLE = Style.f_131099_.m_178520_(14697252);

    public static int indexOfComponent(List<Component> lines, String key) {
        return TooltipsUtils.indexOfInternal(lines, key::equals);
    }

    public static int indexOfComponentRegex(List<Component> lines, String regex) {
        return TooltipsUtils.indexOfInternal(lines, string -> string.matches(regex));
    }

    public static int indexOfAdvancedText(List<Component> lines, ItemStack itemStack) {
        return TooltipsUtils.indexOfComponentRegex(lines, "item.durability|item.components|" + BuiltInRegistries.f_257033_.m_7981_((Object)itemStack.m_41720_()));
    }

    private static int indexOfInternal(List<Component> lines, Predicate<String> comparator) {
        int size = lines.size();
        for (int i = 0; i < size; ++i) {
            LiteralContents literalContents;
            TranslatableContents translatableContents;
            Component component = lines.get(i);
            ComponentContents componentContents = component.m_214077_();
            if (!(componentContents instanceof TranslatableContents ? comparator.test((translatableContents = (TranslatableContents)componentContents).m_237508_()) : (componentContents = component.m_214077_()) instanceof LiteralContents && comparator.test((literalContents = (LiteralContents)componentContents).f_237368_()))) continue;
            return i;
        }
        return -1;
    }
}

