/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsrpgtweaks.xp_module;

import io.redspace.ironsrpgtweaks.IronsRpgTweaks;
import io.redspace.ironsrpgtweaks.config.ServerConfigs;
import io.redspace.ironsrpgtweaks.xp_module.entity.XpCatalyst;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class XpServerEvents {
    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            IronsRpgTweaks.LOGGER.debug("Levels: {}\nPoints: {}\nTotal: {}", new Object[]{serverPlayer.f_36078_, Float.valueOf(serverPlayer.f_36080_), serverPlayer.f_36079_});
            if (XpServerEvents.shouldCreateCatalyst(serverPlayer.m_9236_())) {
                XpCatalyst.createXpCatalyst(serverPlayer);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        ServerPlayer serverPlayer;
        Player player;
        if (!event.isEndConquered() && (player = event.getEntity()) instanceof ServerPlayer && XpServerEvents.shouldCreateCatalyst((serverPlayer = (ServerPlayer)player).m_9236_())) {
            serverPlayer.m_9174_(0);
            serverPlayer.m_8985_(0);
        }
    }

    @SubscribeEvent
    public static void onXpDropped(LivingExperienceDropEvent event) {
        ServerPlayer serverPlayer;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer && XpServerEvents.shouldCreateCatalyst((serverPlayer = (ServerPlayer)livingEntity).m_9236_())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void modifyEntityXp(LivingExperienceDropEvent event) {
        if (((Boolean)ServerConfigs.XP_MODULE_ENABLED.get()).booleanValue()) {
            event.setDroppedExperience((int)((double)event.getDroppedExperience() * (Double)ServerConfigs.ENTITY_XP_MODIFIER.get()));
        }
    }

    @SubscribeEvent
    public static void modifyBlockXp(BlockEvent.BreakEvent event) {
        if (((Boolean)ServerConfigs.XP_MODULE_ENABLED.get()).booleanValue()) {
            event.setExpToDrop((int)((double)event.getExpToDrop() * (Double)ServerConfigs.BLOCK_XP_MODIFIER.get()));
        }
    }

    public static boolean shouldCreateCatalyst(Level level) {
        return (Boolean)ServerConfigs.XP_MODULE_ENABLED.get() != false && ((Boolean)ServerConfigs.XP_IGNORE_KEEPINVENTORY.get() != false || !level.m_46469_().m_46207_(GameRules.f_46133_));
    }
}

