/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.particles;

import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.Vec3Util;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class GeometricParticle
extends TextureSheetParticle {
    private final ParticleContext particleContext;
    private final IParticleGeometry particleGeometry;
    private final boolean cycleSprites;
    private Function<GeometricParticle, Float> rotationOverride;
    private Function<GeometricParticle, Vec3> velocityOverride;
    private Function<GeometricParticle, Vec3> positionOverride;
    private Function<Float, Float> scaleOverride;
    private Function<Float, ColorUtil> colorOverride;
    private Function<Float, Integer> brightnessOverride;
    private Vec3 colorVariation = Vec3.f_82478_;
    private float prevRotation = 0.0f;
    private float rotation = 0.0f;
    public float ageRatio = 1.0f;

    public GeometricParticle(ParticleContext particleContext, int particleAge, IParticleGeometry particleGeometry, boolean cycleSprites, boolean doCollision) {
        super(particleContext.level, particleContext.pos().m_7096_(), particleContext.pos().m_7098_(), particleContext.pos().m_7094_());
        this.particleContext = particleContext;
        this.f_107225_ = particleAge;
        this.particleGeometry = particleGeometry;
        this.cycleSprites = cycleSprites;
        this.f_107219_ = doCollision;
        this.f_107215_ = particleContext.vel().m_7096_();
        this.f_107216_ = particleContext.vel().m_7098_();
        this.f_107217_ = particleContext.vel().m_7094_();
        if (cycleSprites) {
            this.m_108339_(particleContext.spriteSet());
        } else {
            this.m_108337_(particleContext.spriteSet().m_213979_(this.f_107223_));
        }
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    @NotNull
    public Vec3 getPos() {
        return new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
    }

    public int getAge() {
        return this.f_107224_;
    }

    public void m_5989_() {
        super.m_5989_();
        if (!this.m_107276_()) {
            return;
        }
        if (this.cycleSprites) {
            this.m_108339_(this.particleContext.spriteSet());
        }
        this.ageRatio = (float)this.f_107224_ / (float)this.f_107225_;
        this.setColorFromOverride(this.colorOverride, this.ageRatio);
        this.setScaleFromOverride(this.scaleOverride, this.ageRatio);
        this.setVelocityFromOverride(this.velocityOverride);
        this.setPositionFromOverride(this.positionOverride);
        this.setRotationFromOverride(this.rotationOverride);
    }

    private void setRotationFromOverride(Function<GeometricParticle, Float> rotationOverride) {
        if (rotationOverride == null) {
            return;
        }
        float rot = rotationOverride.apply(this).floatValue();
        this.prevRotation = this.rotation;
        this.rotation = rot;
    }

    private void setVelocityFromOverride(Function<GeometricParticle, Vec3> velocityOverride) {
        if (velocityOverride == null) {
            return;
        }
        Vec3 velocity = velocityOverride.apply(this);
        this.f_107215_ = velocity.m_7096_();
        this.f_107216_ = velocity.m_7098_();
        this.f_107217_ = velocity.m_7094_();
    }

    private void setPositionFromOverride(Function<GeometricParticle, Vec3> positionOverride) {
        if (positionOverride == null) {
            return;
        }
        Vec3 pos = positionOverride.apply(this);
        this.m_107264_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
    }

    private void setScaleFromOverride(Function<Float, Float> scaleOverride, float ageRatio) {
        if (scaleOverride == null) {
            return;
        }
        this.f_107663_ = scaleOverride.apply(Float.valueOf(ageRatio)).floatValue();
        this.m_107250_(0.2f * this.f_107663_, 0.2f * this.f_107663_);
    }

    private void setColorFromOverride(Function<Float, ColorUtil> colorOverride, float ageRatio) {
        if (colorOverride == null) {
            return;
        }
        ColorUtil color = colorOverride.apply(Float.valueOf(ageRatio));
        Vec3 vec3 = new Vec3((double)color.red, (double)color.green, (double)color.blue);
        Vec3 variedColor = Vec3Util.coerceAtMost(Vec3Util.coerceAtLeast(vec3.m_82549_(this.colorVariation), Vec3.f_82478_), Vec3Util.unit);
        this.m_107253_((float)variedColor.m_7096_(), (float)variedColor.m_7098_(), (float)variedColor.m_7094_());
    }

    public void setBrightnessOverride(Function<Float, Integer> override) {
        this.brightnessOverride = override;
    }

    public void setColorOverride(Function<Float, ColorUtil> override) {
        this.colorOverride = override;
        this.setColorFromOverride(override, 0.0f);
    }

    public void setScaleOverride(Function<Float, Float> override) {
        this.scaleOverride = override;
        this.setScaleFromOverride(override, 0.0f);
    }

    public void setColorVariation(double variation) {
        this.colorVariation = Vec3Util.randVec(this.f_107223_).m_82490_(variation);
        this.setColorFromOverride(this.colorOverride, 0.0f);
    }

    public void setVelocityOverride(Function<GeometricParticle, Vec3> override) {
        this.velocityOverride = override;
    }

    public void setPositionOverride(Function<GeometricParticle, Vec3> override) {
        this.positionOverride = override;
    }

    public void setRotationOverride(Function<GeometricParticle, Float> override) {
        this.rotationOverride = override;
        if (this.rotationOverride != null) {
            this.rotation = this.rotationOverride.apply(this).floatValue();
            this.prevRotation = this.rotationOverride.apply(this).floatValue();
        }
    }

    protected int m_6355_(float partialTick) {
        return this.brightnessOverride != null ? this.brightnessOverride.apply(Float.valueOf(this.ageRatio)).intValue() : super.m_6355_(partialTick);
    }

    public void m_5744_(VertexConsumer vertexConsumer, @NotNull Camera camera, float partialTicks) {
        Vector3f[] vector3fs = this.particleGeometry.getGeometry(camera, partialTicks, this.f_107209_, this.f_107210_, this.f_107211_, this.f_107212_, this.f_107213_, this.f_107214_, this.m_5902_(partialTicks), Mth.m_14179_((float)partialTicks, (float)this.prevRotation, (float)this.rotation));
        float l = this.m_5970_();
        float m = this.m_5952_();
        float n = this.m_5951_();
        float o = this.m_5950_();
        float p = this.m_6355_(partialTicks);
        vertexConsumer.m_5483_((double)vector3fs[0].x(), (double)vector3fs[0].y(), (double)vector3fs[0].z()).m_7421_(m, o).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_((int)p).m_5752_();
        vertexConsumer.m_5483_((double)vector3fs[1].x(), (double)vector3fs[1].y(), (double)vector3fs[1].z()).m_7421_(m, n).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_((int)p).m_5752_();
        vertexConsumer.m_5483_((double)vector3fs[2].x(), (double)vector3fs[2].y(), (double)vector3fs[2].z()).m_7421_(l, n).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_((int)p).m_5752_();
        vertexConsumer.m_5483_((double)vector3fs[3].x(), (double)vector3fs[3].y(), (double)vector3fs[3].z()).m_7421_(l, o).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_((int)p).m_5752_();
    }

    public record ParticleContext(SpriteSet spriteSet, ClientLevel level, Vec3 pos, Vec3 vel, Boolean cycleSprites) {
    }

    @FunctionalInterface
    public static interface IParticleGeometry {
        public Vector3f[] getGeometry(Camera var1, float var2, double var3, double var5, double var7, double var9, double var11, double var13, float var15, float var16);
    }

    public static class Geometries {
        public static Vector3f[] buildBillBoardGeometry(@NotNull Camera camera, float tickDelta, double prevPosX, double prevPosY, double prevPosZ, double x, double y, double z, float scale, float rotation) {
            Vec3 vec3 = camera.m_90583_();
            float f = (float)(Mth.m_14139_((double)tickDelta, (double)prevPosX, (double)x) - vec3.m_7096_());
            float g = (float)(Mth.m_14139_((double)tickDelta, (double)prevPosY, (double)y) - vec3.m_7098_());
            float h = (float)(Mth.m_14139_((double)tickDelta, (double)prevPosZ, (double)z) - vec3.m_7094_());
            Quaternionf quaternion2 = camera.m_253121_();
            Vector3f[] vector3fs = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
            for (int k = 0; k <= 3; ++k) {
                Vector3f vector3f2 = vector3fs[k];
                vector3f2.rotate((Quaternionfc)Axis.f_252403_.m_252977_(rotation));
                vector3f2.rotate((Quaternionfc)quaternion2);
                vector3f2.mul(scale);
                vector3f2.add(f, g, h);
            }
            return vector3fs;
        }

        public static Vector3f @NotNull [] buildFlatGeometry(@NotNull Camera camera, float tickDelta, double prevPosX, double prevPosY, double prevPosZ, double x, double y, double z, float scale, float rotation) {
            Vec3 vec3 = camera.m_90583_();
            float f = (float)(Mth.m_14139_((double)tickDelta, (double)prevPosX, (double)x) - vec3.m_7096_());
            float g = (float)(Mth.m_14139_((double)tickDelta, (double)prevPosY, (double)y) - vec3.m_7098_());
            float h = (float)(Mth.m_14139_((double)tickDelta, (double)prevPosZ, (double)z) - vec3.m_7094_());
            Vector3f[] vector3fs = new Vector3f[]{new Vector3f(-1.0f, 0.0f, -1.0f), new Vector3f(-1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, -1.0f)};
            for (int k = 0; k <= 3; ++k) {
                Vector3f vector3f2 = vector3fs[k];
                vector3f2.rotate((Quaternionfc)Axis.f_252436_.m_252977_(rotation));
                vector3f2.mul(scale);
                vector3f2.add(f, g, h);
            }
            return vector3fs;
        }
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;
        private final Function<ParticleContext, Particle> particleProvider;

        public Provider(SpriteSet spriteSet, Function<ParticleContext, Particle> particleProvider) {
            this.spriteSet = spriteSet;
            this.particleProvider = particleProvider;
        }

        @Nullable
        public Particle createParticle(@NotNull SimpleParticleType type, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return this.particleProvider.apply(new ParticleContext(this.spriteSet, level, new Vec3(x, y, z), new Vec3(xSpeed, ySpeed, zSpeed), true));
        }
    }
}

