/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.particles;

import com.Polarice3.Goety.client.particles.WindParticleOption;
import com.Polarice3.Goety.client.particles.WindTrailParticle;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class WindParticle
extends WindTrailParticle {
    public final int ownerId;
    public final boolean isEntity;
    public final float width;
    public final float height;
    public float initYRot;
    public float rotateAge;
    public final Vec3 origin;

    public WindParticle(ClientLevel world, double x, double y, double z, float red, float green, float blue, float width, float height, int life, int ownerId) {
        super(world, x, y, z, 0.0, 0.0, 0.0, red, green, blue);
        this.ownerId = ownerId;
        this.isEntity = ownerId > 0;
        this.f_107226_ = 0.0f;
        this.f_107225_ = life <= 0 ? 20 + this.f_107223_.m_188503_(20) : life;
        this.initYRot = this.f_107223_.m_188501_() * 360.0f;
        this.rotateAge = (10.0f + this.f_107223_.m_188501_() * 10.0f) * (float)this.f_107223_.m_216332_(-1, 1);
        this.width = width;
        this.height = height;
        this.origin = new Vec3(x, y, z);
        Vec3 vec3 = this.getOrbitPosition();
        this.f_107212_ = this.f_107209_ = vec3.f_82479_;
        this.f_107213_ = this.f_107210_ = vec3.f_82480_;
        this.f_107214_ = this.f_107211_ = vec3.f_82481_;
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
    }

    public Vec3 getPosition() {
        Entity owner = this.getEntity();
        return owner != null ? owner.m_20182_() : this.origin;
    }

    public Entity getEntity() {
        return this.ownerId == -1 ? null : this.f_107208_.m_6815_(this.ownerId);
    }

    public Vec3 getOrbitPosition() {
        Vec3 position = this.getPosition();
        Vec3 vec3 = new Vec3(0.0, (double)this.height, (double)this.width).m_82524_((float)Math.toRadians(this.initYRot + this.rotateAge * (float)this.f_107224_));
        return position.m_82549_(vec3);
    }

    @Override
    public void m_5989_() {
        super.m_5989_();
        this.trailA = 1.0f - (float)this.f_107224_ / (float)this.f_107225_;
        Vec3 vec3 = this.getOrbitPosition();
        this.f_107212_ = vec3.f_82479_;
        this.f_107213_ = vec3.f_82480_;
        this.f_107214_ = vec3.f_82481_;
        if (this.getEntity() == null && this.isEntity) {
            this.m_107274_();
        }
    }

    @Override
    public int sampleSize() {
        return 4;
    }

    public int m_6355_(float pPartialTick) {
        return 240;
    }

    public static class Provider
    implements ParticleProvider<WindParticleOption> {
        public Provider(SpriteSet p_172490_) {
        }

        public Particle createParticle(WindParticleOption typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new WindParticle(worldIn, x, y, z, typeIn.getRed(), typeIn.getGreen(), typeIn.getBlue(), typeIn.getWidth(), typeIn.getHeight(), typeIn.getLife(), typeIn.getOwnerId());
        }
    }
}

