/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally;

import com.Polarice3.Goety.client.render.TropicalSlimeTextures;
import com.Polarice3.Goety.common.entities.ally.SlimeServant;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.ModLootTables;
import java.util.EnumSet;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

public class TropicalSlimeServant
extends SlimeServant {
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID = SynchedEntityData.m_135353_(TropicalSlimeServant.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public TropicalSlimeServant(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new TropicalSlimeMoveControl(this);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public ResourceLocation getResourceLocation() {
        return TropicalSlimeTextures.TEXTURES.getOrDefault(this.getAnimation(), TropicalSlimeTextures.TEXTURES.get(0));
    }

    @Override
    public void slimeGoal() {
        this.f_21345_.m_25352_(2, (Goal)new SlimeAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new SlimeRandomDirectionGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new SlimeKeepOnJumpingGoal(this));
    }

    @Override
    public void followGoal() {
        this.f_21345_.m_25352_(8, (Goal)new SlimeFollowGoal(this, 4.0f, 10.0f));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22266_(Attributes.f_22281_).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 0.1);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TYPE_ID, (Object)0);
    }

    public int getAnimation() {
        return (Integer)this.f_19804_.m_135370_(DATA_TYPE_ID);
    }

    public void setAnimation(int pType) {
        this.f_19804_.m_135381_(DATA_TYPE_ID, (Object)pType);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setAnimation(pCompound.m_128451_("Animation"));
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Animation", this.getAnimation());
    }

    protected void m_7472_(DamageSource p_33574_, int p_33575_, boolean p_33576_) {
        super.m_7472_(p_33574_, p_33575_, p_33576_);
        if (this.f_19853_.m_7654_() != null && this.m_6125_()) {
            LootTable loottable = this.f_19853_.m_7654_().m_278653_().m_278676_(ModLootTables.TROPICAL_SLIME);
            LootParams.Builder lootparams$builder = new LootParams.Builder((ServerLevel)this.f_19853_).m_287286_(LootContextParams.f_81455_, (Object)this).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)p_33574_).m_287289_(LootContextParams.f_81458_, (Object)p_33574_.m_7639_()).m_287289_(LootContextParams.f_81459_, (Object)p_33574_.m_7640_());
            if (this.f_20889_ > 0 && this.f_20888_ != null) {
                lootparams$builder = lootparams$builder.m_287286_(LootContextParams.f_81456_, (Object)this.f_20888_).m_287239_(this.f_20888_.m_36336_());
            }
            LootParams lootparams = lootparams$builder.m_287235_(LootContextParamSets.f_81415_);
            loottable.m_287276_(lootparams, this.m_287233_(), arg_0 -> ((TropicalSlimeServant)this).m_19983_(arg_0));
        }
    }

    @Override
    protected float getSoundPitch() {
        return this.m_6100_();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource p_33631_) {
        if (this.isTiny()) {
            return (SoundEvent)ModSounds.TROPICAL_SLIME_SMALL_HURT.get();
        }
        if (this.isMedium()) {
            return (SoundEvent)ModSounds.TROPICAL_SLIME_MEDIUM_HURT.get();
        }
        if (this.isLarge()) {
            return (SoundEvent)ModSounds.TROPICAL_SLIME_LARGE_HURT.get();
        }
        return (SoundEvent)ModSounds.TROPICAL_SLIME_SMALL_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        if (this.isTiny()) {
            return (SoundEvent)ModSounds.TROPICAL_SLIME_SMALL_DEATH.get();
        }
        if (this.isMedium()) {
            return (SoundEvent)ModSounds.TROPICAL_SLIME_MEDIUM_DEATH.get();
        }
        if (this.isLarge()) {
            return (SoundEvent)ModSounds.TROPICAL_SLIME_LARGE_DEATH.get();
        }
        return (SoundEvent)ModSounds.TROPICAL_SLIME_SMALL_DEATH.get();
    }

    @Override
    protected SoundEvent getSquishSound() {
        if (this.isTiny()) {
            return (SoundEvent)ModSounds.TROPICAL_SLIME_SMALL_SQUISH.get();
        }
        if (this.isMedium()) {
            return (SoundEvent)ModSounds.TROPICAL_SLIME_MEDIUM_SQUISH.get();
        }
        if (this.isLarge()) {
            return (SoundEvent)ModSounds.TROPICAL_SLIME_LARGE_SQUISH.get();
        }
        return (SoundEvent)ModSounds.TROPICAL_SLIME_SMALL_SQUISH.get();
    }

    @Override
    protected SoundEvent getJumpSound() {
        if (this.isTiny()) {
            return (SoundEvent)ModSounds.TROPICAL_SLIME_SMALL_JUMP.get();
        }
        if (this.isMedium()) {
            return (SoundEvent)ModSounds.TROPICAL_SLIME_MEDIUM_JUMP.get();
        }
        if (this.isLarge()) {
            return (SoundEvent)ModSounds.TROPICAL_SLIME_LARGE_JUMP.get();
        }
        return (SoundEvent)ModSounds.TROPICAL_SLIME_SMALL_JUMP.get();
    }

    @Override
    protected SoundEvent getAttackSound() {
        if (this.isTiny()) {
            return (SoundEvent)ModSounds.TROPICAL_SLIME_SMALL_ATTACK.get();
        }
        if (this.isMedium()) {
            return (SoundEvent)ModSounds.TROPICAL_SLIME_MEDIUM_ATTACK.get();
        }
        if (this.isLarge()) {
            return (SoundEvent)ModSounds.TROPICAL_SLIME_LARGE_ATTACK.get();
        }
        return (SoundEvent)ModSounds.TROPICAL_SLIME_SMALL_ATTACK.get();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            if (this.getAnimation() < TropicalSlimeTextures.TEXTURES.size()) {
                this.setAnimation(this.getAnimation() + 1);
            } else {
                this.setAnimation(0);
            }
        }
    }

    @Override
    public void commandMode() {
        if (this.isCommanded() && this.m_20069_()) {
            this.m_7618_(EntityAnchorArgument.Anchor.EYES, this.getCommandPos().m_252807_());
            MoveControl moveControl = this.m_21566_();
            if (moveControl instanceof TropicalSlimeMoveControl) {
                TropicalSlimeMoveControl control = (TropicalSlimeMoveControl)moveControl;
                control.setDirection(this.m_146908_(), true);
                control.setWantedMovement(0.5);
            }
        }
        super.commandMode();
    }

    @Override
    public double getCommandSpeed() {
        if (this.m_20069_()) {
            return 0.5;
        }
        return 1.0;
    }

    @Override
    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    public boolean m_6914_(LevelReader p_32829_) {
        return p_32829_.m_45784_((Entity)this);
    }

    @Override
    public void m_6667_(DamageSource pCause) {
        float size = 1.5f * (float)Math.max(1, this.getSize());
        for (LivingEntity livingEntity : this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82400_((double)size))) {
            int air = Math.min(livingEntity.m_20146_() + 3 * Math.max(1, this.getSize()), livingEntity.m_6062_());
            livingEntity.m_20301_(air);
        }
        super.m_6667_(pCause);
    }

    @Override
    protected ParticleOptions getParticleType() {
        return ParticleTypes.f_123769_;
    }

    public void m_7023_(Vec3 p_32394_) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), p_32394_);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(p_32394_);
        }
    }

    static class TropicalSlimeMoveControl
    extends MoveControl {
        private float yRot;
        private int jumpDelay;
        private final TropicalSlimeServant slime;
        private boolean isAggressive;

        public TropicalSlimeMoveControl(TropicalSlimeServant p_33668_) {
            super((Mob)p_33668_);
            this.slime = p_33668_;
            this.yRot = 180.0f * p_33668_.m_146908_() / (float)Math.PI;
        }

        public void setDirection(float p_33673_, boolean p_33674_) {
            this.yRot = p_33673_;
            this.isAggressive = p_33674_;
        }

        public void setWantedY(double y) {
            this.f_24976_ = y;
        }

        public void setWantedMovement(double p_33671_) {
            this.f_24978_ = p_33671_;
            this.f_24981_ = MoveControl.Operation.MOVE_TO;
        }

        public void m_8126_() {
            this.f_24974_.m_20256_(this.f_24974_.m_20184_().m_82492_(0.0, 0.008, 0.0));
            this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), this.yRot, 90.0f));
            this.f_24974_.f_20885_ = this.f_24974_.m_146908_();
            this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
            if (this.f_24981_ != MoveControl.Operation.MOVE_TO) {
                this.f_24974_.m_7910_(0.0f);
                this.f_24974_.m_21564_(0.0f);
            } else {
                this.f_24981_ = MoveControl.Operation.WAIT;
                if (this.f_24974_.m_20069_() && !this.f_24974_.m_20096_()) {
                    float f1 = (float)(this.f_24978_ * this.f_24974_.m_21133_((Attribute)ForgeMod.SWIM_SPEED.get()));
                    double d1 = this.f_24976_ - this.f_24974_.m_20186_();
                    boolean flag = d1 < 0.0 && this.f_24974_.m_5448_() != null;
                    float f2 = Mth.m_14179_((float)0.125f, (float)this.f_24974_.m_6113_(), (float)f1);
                    this.f_24974_.m_7910_(f2);
                    if (flag && Math.abs(d1) > (double)1.0E-5f) {
                        this.f_24974_.m_21567_(f2 * 3.0f);
                    }
                } else if (this.f_24974_.m_20096_()) {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.slime.getJumpDelay();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.slime.m_21569_().m_24901_();
                        if (this.slime.doPlayJumpSound()) {
                            this.slime.m_5496_(this.slime.getJumpSound(), this.slime.m_6121_(), this.slime.getSoundPitch());
                        }
                    } else {
                        this.slime.f_20900_ = 0.0f;
                        this.f_24974_.m_21564_(0.0f);
                        this.f_24974_.m_7910_(0.0f);
                    }
                } else {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                }
            }
        }
    }

    static class SlimeAttackGoal
    extends Goal {
        private final TropicalSlimeServant slime;
        private int growTiredTimer;

        public SlimeAttackGoal(TropicalSlimeServant p_33648_) {
            this.slime = p_33648_;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.slime.m_5448_();
            if (livingentity == null) {
                return false;
            }
            return this.slime.m_6779_(livingentity) && this.slime.m_21566_() instanceof TropicalSlimeMoveControl;
        }

        public void m_8056_() {
            this.growTiredTimer = SlimeAttackGoal.m_186073_((int)300);
            super.m_8056_();
        }

        public boolean m_8045_() {
            LivingEntity livingentity = this.slime.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!this.slime.m_6779_(livingentity)) {
                return false;
            }
            return --this.growTiredTimer > 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            MoveControl moveControl = this.slime.m_21566_();
            if (moveControl instanceof TropicalSlimeMoveControl) {
                TropicalSlimeMoveControl control = (TropicalSlimeMoveControl)moveControl;
                LivingEntity livingentity = this.slime.m_5448_();
                if (livingentity != null) {
                    this.slime.m_21391_((Entity)livingentity, 10.0f, 10.0f);
                    control.setWantedY(livingentity.m_20186_());
                }
                control.setDirection(this.slime.m_146908_(), this.slime.isDealsDamage());
            }
        }
    }

    static class SlimeRandomDirectionGoal
    extends Goal {
        private final TropicalSlimeServant slime;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public SlimeRandomDirectionGoal(TropicalSlimeServant p_33679_) {
            this.slime = p_33679_;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return !(this.slime.m_5448_() != null || this.slime.getTrueOwner() != null && !this.slime.isWandering() || !this.slime.m_20096_() && !this.slime.m_20069_() && !this.slime.m_20077_() && !this.slime.m_21023_(MobEffects.f_19620_) || !(this.slime.m_21566_() instanceof TropicalSlimeMoveControl));
        }

        public void m_8037_() {
            MoveControl moveControl;
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = this.m_183277_(40 + this.slime.m_217043_().m_188503_(60));
                this.chosenDegrees = this.slime.m_217043_().m_188503_(360);
            }
            if ((moveControl = this.slime.m_21566_()) instanceof TropicalSlimeMoveControl) {
                TropicalSlimeMoveControl control = (TropicalSlimeMoveControl)moveControl;
                control.setDirection(this.chosenDegrees, false);
            }
        }
    }

    static class SlimeKeepOnJumpingGoal
    extends Goal {
        private final TropicalSlimeServant slime;

        public SlimeKeepOnJumpingGoal(TropicalSlimeServant p_33660_) {
            this.slime = p_33660_;
        }

        public boolean m_8036_() {
            return !this.slime.m_20159_() && !this.slime.isStaying() && (this.slime.getTrueOwner() == null || this.slime.isWandering() || this.slime.m_5448_() != null);
        }

        public void m_8037_() {
            MoveControl moveControl = this.slime.m_21566_();
            if (moveControl instanceof TropicalSlimeMoveControl) {
                TropicalSlimeMoveControl control = (TropicalSlimeMoveControl)moveControl;
                control.setWantedMovement(1.0);
            }
        }
    }

    static class SlimeFollowGoal
    extends Goal {
        private final TropicalSlimeServant slime;
        private LivingEntity owner;
        private final float stopDistance;
        private final float startDistance;

        public SlimeFollowGoal(TropicalSlimeServant p_33648_, float startDistance, float stopDistance) {
            this.slime = p_33648_;
            this.startDistance = startDistance;
            this.stopDistance = stopDistance;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.slime.getTrueOwner();
            if (livingentity == null) {
                return false;
            }
            if (!(this.slime.m_21566_() instanceof TropicalSlimeMoveControl)) {
                return false;
            }
            if (livingentity.m_5833_()) {
                return false;
            }
            if (this.slime.m_20280_((Entity)livingentity) < (double)Mth.m_14207_((float)this.startDistance)) {
                return false;
            }
            if (!this.slime.isFollowing() || this.slime.isCommanded()) {
                return false;
            }
            if (this.slime.m_5448_() != null) {
                return false;
            }
            this.owner = livingentity;
            return true;
        }

        public void m_8056_() {
            super.m_8056_();
        }

        public boolean m_8045_() {
            if (this.slime.m_21573_().m_26571_()) {
                return false;
            }
            if (this.slime.m_5448_() != null) {
                return false;
            }
            return !(this.slime.m_20280_((Entity)this.owner) <= (double)Mth.m_14207_((float)this.stopDistance));
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            MoveControl movecontrol = this.slime.m_21566_();
            if (movecontrol instanceof TropicalSlimeMoveControl) {
                TropicalSlimeMoveControl control = (TropicalSlimeMoveControl)movecontrol;
                if (this.owner != null) {
                    this.slime.m_21391_((Entity)this.owner, 10.0f, 10.0f);
                    control.setWantedY(this.owner.m_20186_());
                }
                control.setDirection(this.slime.m_146908_(), true);
                control.setWantedMovement(1.0);
            }
        }
    }
}

