/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.golem;

import com.Polarice3.Goety.api.entities.IAutoRideable;
import com.Polarice3.Goety.api.entities.IRM;
import com.Polarice3.Goety.api.items.magic.IWand;
import com.Polarice3.Goety.client.particles.CircleExplodeParticleOption;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.golem.RaiderGolemServant;
import com.Polarice3.Goety.common.entities.ally.golem.RedstoneCube;
import com.Polarice3.Goety.common.entities.ally.illager.RaiderServant;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.entities.projectiles.ScatterBomb;
import com.Polarice3.Goety.common.entities.util.CameraShake;
import com.Polarice3.Goety.common.entities.util.SummonCircleVariant;
import com.Polarice3.Goety.common.items.block.RedstoneMonstrosityHeadItem;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.config.MobsConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedstoneMonstrosity
extends RaiderGolemServant
implements PlayerRideable,
IAutoRideable,
IRM {
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(RedstoneMonstrosity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(RedstoneMonstrosity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> AUTO_MODE = SynchedEntityData.m_135353_(RedstoneMonstrosity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static String ACTIVATE = "activate";
    public static String IDLE = "idle";
    public static String ATTACK = "attack";
    public static String WALK = "walk";
    public static String SUMMON = "summon";
    public static String TO_SIT = "to_sit";
    public static String TO_STAND = "to_stand";
    public static String SIT = "sit";
    public static String BELCH = "belch";
    public static String DEATH = "death";
    public static float SUMMON_SECONDS_TIME = 4.7f;
    public static double MELEE_RANGE = 8.0;
    private int activateTick;
    public int attackTick;
    public int summonTick;
    private int summonCool;
    private int summonCount;
    public int belchCool;
    private int postAttackCool;
    public int isSittingDown;
    public int isStandingUp;
    public float minorGlow;
    public float glowAmount = 0.01f;
    public float bigGlow;
    public float deathRotation = 0.0f;
    public int bigGlowCool;
    public int deathTime = 0;
    public boolean clientStop;
    public AnimationState activateAnimationState = new AnimationState();
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState walkAnimationState = new AnimationState();
    public AnimationState summonAnimationState = new AnimationState();
    public AnimationState toSitAnimationState = new AnimationState();
    public AnimationState toStandAnimationState = new AnimationState();
    public AnimationState sitAnimationState = new AnimationState();
    public AnimationState belchAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();

    public RedstoneMonstrosity(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.LEAVES, 0.0f);
        this.f_21342_ = new SlowRotMoveControl((Mob)this);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new SummonGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new BelchGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new AttackGoal(this, 1.2));
    }

    @Override
    public void miscGoal() {
        this.f_21345_.m_25352_(8, new RaiderServant.RaiderWanderGoal<RedstoneMonstrosity>(this, 1.0, 10.0f));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.RedstoneMonstrosityHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.RedstoneMonstrosityArmor.get()).doubleValue()).m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22282_, 6.0).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 2.0).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.RedstoneMonstrosityDamage.get()).doubleValue()).m_22268_(Attributes.f_22277_, ((Double)AttributesConfig.RedstoneMonstrosityFollowRange.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.RedstoneMonstrosityHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.RedstoneMonstrosityArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.RedstoneMonstrosityDamage.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22277_), (Double)AttributesConfig.RedstoneMonstrosityFollowRange.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
        this.f_19804_.m_135372_(AUTO_MODE, (Object)false);
    }

    @Override
    public void setAutonomous(boolean autonomous) {
        this.f_19804_.m_135381_(AUTO_MODE, (Object)autonomous);
        if (autonomous) {
            this.m_216990_(SoundEvents.f_11686_);
            if (!this.isWandering()) {
                this.setWandering(true);
                this.setStaying(false);
            }
        }
    }

    @Override
    public boolean isAutonomous() {
        return (Boolean)this.f_19804_.m_135370_(AUTO_MODE);
    }

    @Nullable
    public LivingEntity m_6688_() {
        if (!this.m_21525_()) {
            Entity entity = this.m_146895_();
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                if (((Boolean)MobsConfig.ServantRideAutonomous.get()).booleanValue()) {
                    return null;
                }
                return mob;
            }
            if (entity instanceof LivingEntity && !this.isAutonomous()) {
                return (LivingEntity)entity;
            }
        }
        return null;
    }

    public boolean m_6109_() {
        return this.m_21515_();
    }

    public double m_6048_() {
        return this.f_19815_.f_20378_;
    }

    protected void doPlayerRide(Player player) {
        if (!this.f_19853_.f_46443_) {
            player.m_146922_(this.m_146908_());
            player.m_146926_(this.m_146909_());
            player.m_20329_((Entity)this);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_7023_(@NotNull Vec3 pTravelVector) {
        if (!this.m_6084_()) return;
        LivingEntity rider = this.m_6688_();
        if (this.m_20160_() && rider instanceof Player) {
            Player player = (Player)rider;
            if (!this.clientStopMoving() && !this.isAutonomous()) {
                this.m_146922_(rider.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(rider.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                float speed = this.m_245547_(player);
                float f = rider.f_20900_ * speed;
                float f1 = rider.f_20902_ * speed;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                }
                this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                super.m_7023_(new Vec3((double)f, pTravelVector.f_82480_, (double)f1));
                this.f_20903_ = 0;
                this.m_267651_(false);
                return;
            }
        }
        if (this.clientStopMoving()) {
            pTravelVector = new Vec3(0.0, pTravelVector.f_82480_, 0.0);
        }
        super.m_7023_(pTravelVector);
    }

    public boolean clientStopMoving() {
        if (this.f_19853_.f_46443_) {
            return this.clientStop;
        }
        return this.isMeleeAttacking() || this.isBelching() || this.isSummoning();
    }

    protected float m_6059_() {
        return this.f_19788_ + 1.5f;
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new RMBodyRotateControl((Mob)this);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.REDSTONE_MONSTROSITY_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return (SoundEvent)ModSounds.REDSTONE_MONSTROSITY_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.REDSTONE_MONSTROSITY_DEATH.get();
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
        if (this.m_5912_()) {
            this.m_5496_((SoundEvent)ModSounds.REDSTONE_MONSTROSITY_CHASE.get(), 2.0f, 1.0f);
        } else {
            this.m_5496_((SoundEvent)ModSounds.REDSTONE_MONSTROSITY_STEP.get(), 2.0f, 1.0f);
        }
        CameraShake.cameraShake(this.f_19853_, this.m_20182_(), 20.0f, 0.03f, 0, 20);
    }

    protected float m_6121_() {
        return 3.0f;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, this.m_217003_(Pose.EMERGING) ? 1 : 0);
    }

    public void m_141965_(ClientboundAddEntityPacket p_219420_) {
        super.m_141965_(p_219420_);
        if (p_219420_.m_131509_() == 1) {
            this.m_20124_(Pose.EMERGING);
        }
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "activate")) {
            return 1;
        }
        if (Objects.equals(animation, "idle")) {
            return 2;
        }
        if (Objects.equals(animation, "attack")) {
            return 3;
        }
        if (Objects.equals(animation, "walk")) {
            return 4;
        }
        if (Objects.equals(animation, "summon")) {
            return 5;
        }
        if (Objects.equals(animation, "to_sit")) {
            return 6;
        }
        if (Objects.equals(animation, "to_stand")) {
            return 7;
        }
        if (Objects.equals(animation, "sit")) {
            return 8;
        }
        if (Objects.equals(animation, "belch")) {
            return 9;
        }
        if (Objects.equals(animation, "death")) {
            return 10;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> animationStates = new ArrayList<AnimationState>();
        animationStates.add(this.activateAnimationState);
        animationStates.add(this.idleAnimationState);
        animationStates.add(this.walkAnimationState);
        animationStates.add(this.attackAnimationState);
        animationStates.add(this.summonAnimationState);
        animationStates.add(this.toSitAnimationState);
        animationStates.add(this.toStandAnimationState);
        animationStates.add(this.sitAnimationState);
        animationStates.add(this.belchAnimationState);
        animationStates.add(this.deathAnimationState);
        return animationStates;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public int getCurrentAnimation() {
        return (Integer)this.f_19804_.m_135370_(ANIM_STATE);
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        if (ANIM_STATE.equals(accessor) && this.f_19853_.f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    break;
                }
                case 1: {
                    this.activateAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.activateAnimationState);
                    break;
                }
                case 2: {
                    this.idleAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.idleAnimationState);
                    break;
                }
                case 3: {
                    this.attackAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.attackAnimationState);
                    break;
                }
                case 4: {
                    this.walkAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.walkAnimationState);
                    break;
                }
                case 5: {
                    this.summonAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.summonAnimationState);
                    break;
                }
                case 6: {
                    this.stopMostAnimation(this.toSitAnimationState);
                    this.toSitAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 7: {
                    this.stopMostAnimation(this.toStandAnimationState);
                    this.toStandAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 8: {
                    this.sitAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.sitAnimationState);
                    break;
                }
                case 9: {
                    this.belchAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.belchAnimationState);
                    break;
                }
                case 10: {
                    this.deathAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.deathAnimationState);
                }
            }
        }
    }

    private boolean getFlag(int mask) {
        byte i = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        return (i & mask) != 0;
    }

    private void setFlag(int mask, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(i & 0xFF)));
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("ActivateTick", this.activateTick);
        pCompound.m_128405_("SummonTick", this.summonTick);
        pCompound.m_128405_("PostAttackCool", this.postAttackCool);
        pCompound.m_128405_("CoolDown", this.summonCool);
        pCompound.m_128405_("BelchCool", this.belchCool);
        pCompound.m_128379_("AutoMode", this.isAutonomous());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("ActivateTick")) {
            this.activateTick = pCompound.m_128451_("ActivateTick");
        }
        if (pCompound.m_128441_("SummonTick")) {
            this.summonTick = pCompound.m_128451_("SummonTick");
        }
        if (pCompound.m_128441_("PostAttackCool")) {
            this.postAttackCool = pCompound.m_128451_("PostAttackCool");
        }
        if (pCompound.m_128441_("CoolDown")) {
            this.summonCool = pCompound.m_128451_("CoolDown");
        }
        if (pCompound.m_128441_("BelchCool")) {
            this.belchCool = pCompound.m_128451_("BelchCool");
        }
        if (pCompound.m_128441_("AutoMode")) {
            this.setAutonomous(pCompound.m_128471_("AutoMode"));
        }
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (pReason == MobSpawnType.MOB_SUMMONED || pReason == MobSpawnType.COMMAND) {
            this.m_20124_(Pose.EMERGING);
        }
        this.isStandingUp = 0;
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @Override
    public SoundEvent getCelebrateSound() {
        return (SoundEvent)ModSounds.REDSTONE_MONSTROSITY_AMBIENT.get();
    }

    @Override
    public boolean canAnimateMove() {
        return super.canAnimateMove() && this.getCurrentAnimation() == this.getAnimationState(WALK);
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.isSummoning() || this.isActivating() || this.postAttackCool > 0;
    }

    public boolean m_142582_(Entity p_149755_) {
        return this.summonTick <= 0 && !this.isActivating() && super.m_142582_(p_149755_);
    }

    @Override
    public boolean isSummoning() {
        return this.summonTick > 0;
    }

    private void glow() {
        this.minorGlow = Mth.m_14036_((float)(this.minorGlow + this.glowAmount), (float)0.0f, (float)1.0f);
        if (this.minorGlow == 0.0f || this.minorGlow == 1.0f) {
            this.glowAmount *= -1.0f;
        }
    }

    public boolean isMeleeAttacking() {
        return this.getFlag(1);
    }

    public void setMeleeAttacking(boolean attacking) {
        this.setFlag(1, attacking);
        this.attackTick = 0;
    }

    public void setBelching(boolean belching) {
        this.setFlag(2, belching);
    }

    @Override
    public boolean isBelching() {
        return this.getFlag(2);
    }

    @Override
    public void setStaying(boolean staying) {
        super.setStaying(staying);
        if (staying) {
            this.isSittingDown = MathHelper.secondsToTicks(1);
        } else if (this.isFollowing()) {
            this.isStandingUp = MathHelper.secondsToTicks(1);
        }
    }

    protected boolean m_6129_() {
        return false;
    }

    public double canHurtRange(DamageSource pSource) {
        if (pSource.m_7639_() != null) {
            return this.m_20270_(pSource.m_7639_());
        }
        if (pSource.m_7270_() != null) {
            return pSource.m_7270_().m_82554_(this.m_20182_());
        }
        return -1.0;
    }

    @Override
    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.canHurtRange(pSource) > (Double)AttributesConfig.RedstoneMonstrosityHurtRange.get() && !pSource.m_269533_(DamageTypeTags.f_268738_)) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    protected void m_6475_(DamageSource source, float amount) {
        if (!source.m_269533_(DamageTypeTags.f_268738_)) {
            amount = Math.min(amount, ((Double)AttributesConfig.RedstoneMonstrosityDamageCap.get()).floatValue());
        }
        super.m_6475_(source, amount);
    }

    @Override
    public int getDeathTime() {
        return this.deathTime;
    }

    protected void m_6153_() {
        ++this.deathTime;
        if (this.deathTime >= MathHelper.secondsToTicks(5)) {
            this.m_21373_();
            if (this.getTrueOwner() != null) {
                ItemEntity itemEntity;
                ItemStack itemStack = new ItemStack((ItemLike)ModBlocks.REDSTONE_MONSTROSITY_HEAD_BLOCK.get());
                RedstoneMonstrosityHeadItem.setOwner(this.getTrueOwner(), itemStack);
                if (this.m_7770_() != null) {
                    RedstoneMonstrosityHeadItem.setCustomName(this.m_7770_().getString(), itemStack);
                }
                if ((itemEntity = this.m_19983_(itemStack)) != null) {
                    itemEntity.m_32064_();
                }
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        this.f_20916_ = 1;
        this.m_146922_(this.deathRotation);
        this.m_5618_(this.deathRotation);
    }

    @Override
    public void m_6667_(DamageSource p_21014_) {
        this.deathRotation = this.m_146908_();
        super.m_6667_(p_21014_);
    }

    public void m_216990_(SoundEvent p_216991_) {
        if (!this.m_20067_()) {
            this.m_5496_(p_216991_, this.m_6121_(), this.m_6100_());
        }
    }

    @Override
    public float getBigGlow() {
        return this.bigGlow;
    }

    @Override
    public float getMinorGlow() {
        return this.minorGlow;
    }

    @Override
    public boolean isActivating() {
        return this.m_217003_(Pose.EMERGING);
    }

    @Override
    public void m_8119_() {
        Object mob;
        super.m_8119_();
        if (this.isHostile() && this.f_19797_ % 10 == 0 && (mob = this.m_21406_((EntityType)ModEntityType.HOSTILE_REDSTONE_MONSTROSITY.get(), false)) != null) {
            mob.m_146926_(this.m_146909_());
            mob.m_146922_(this.m_146908_());
            mob.m_5618_(this.m_146908_());
            mob.m_5616_(this.m_6080_());
        }
        if (this.m_21224_()) {
            this.setAnimationState(DEATH);
            this.m_146922_(this.deathRotation);
            this.m_5618_(this.deathRotation);
        }
        if (this.m_217003_(Pose.EMERGING)) {
            ++this.activateTick;
            this.isStandingUp = 0;
            this.setAnimationState(ACTIVATE);
            if (this.activateTick == 1) {
                this.m_5496_((SoundEvent)ModSounds.REDSTONE_MONSTROSITY_AWAKEN.get(), 10.0f, 1.0f);
            }
            if (this.activateTick == 40) {
                CameraShake.cameraShake(this.f_19853_, this.m_20182_(), 40.0f, 0.5f, 0, 20);
            }
            if (this.activateTick > MathHelper.secondsToTicks(3.25f)) {
                this.m_20124_(Pose.STANDING);
            }
        }
        if (!this.f_19853_.f_46443_) {
            if (this.m_6084_() && !this.isActivating()) {
                AABB aabb;
                if (((Boolean)MobsConfig.RedstoneMonstrosityLeafBreak.get()).booleanValue() && ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this)) {
                    boolean flag = false;
                    aabb = this.m_20191_().m_82400_(0.2);
                    for (Object blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                        BlockState blockstate = this.f_19853_.m_8055_((BlockPos)blockpos);
                        Block block = blockstate.m_60734_();
                        if (!(block instanceof LeavesBlock) && !blockstate.m_204336_(ModTags.Blocks.MONSTROSITY_BREAKS)) continue;
                        flag = this.f_19853_.m_46953_((BlockPos)blockpos, true, (Entity)this) || flag;
                    }
                }
                if (!(this.isMeleeAttacking() || this.isBelching() || this.isSummoning())) {
                    this.f_19853_.m_7605_((Entity)this, (byte)7);
                    if (this.isStaying()) {
                        if (this.isSittingDown > 0) {
                            --this.isSittingDown;
                            this.setAnimationState(TO_SIT);
                        } else {
                            this.setAnimationState(SIT);
                        }
                    } else if (this.isMoving()) {
                        this.setAnimationState(WALK);
                    } else if (this.isStandingUp > 0) {
                        --this.isStandingUp;
                        this.setAnimationState(TO_STAND);
                    } else {
                        this.setAnimationState(IDLE);
                    }
                } else {
                    this.f_19853_.m_7605_((Entity)this, (byte)6);
                    this.isSittingDown = this.isStaying() ? MathHelper.secondsToTicks(1) : 0;
                    this.isStandingUp = 0;
                }
                if (this.isMeleeAttacking()) {
                    ++this.attackTick;
                    if (this.attackTick > MathHelper.secondsToTicks(3.3f)) {
                        this.setMeleeAttacking(false);
                    }
                }
                if (this.isSummoning()) {
                    this.makeBigGlow();
                    --this.summonTick;
                    aabb = this.f_19853_;
                    if (aabb instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)aabb;
                        for (int i = 0; i < 5; ++i) {
                            double d0 = serverLevel.f_46441_.m_188583_() * 0.02;
                            double d1 = serverLevel.f_46441_.m_188583_() * 0.02;
                            double d2 = serverLevel.f_46441_.m_188583_() * 0.02;
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.ELECTRIC.get()), this.m_20208_(0.5), this.m_20188_() - (double)serverLevel.f_46441_.m_188503_(2), this.m_20262_(0.5), 0, d0, d1, d2, 0.5);
                        }
                        if (this.summonTick < MathHelper.secondsToTicks(SUMMON_SECONDS_TIME - 1.0f) && this.summonTick >= MathHelper.secondsToTicks(SUMMON_SECONDS_TIME - 2.0f) && !this.f_19853_.m_8055_(this.m_20183_().m_7495_()).m_60795_()) {
                            for (int j = 0; j < 4; ++j) {
                                double d1 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() * 2.0;
                                double d2 = (float)this.m_20183_().m_123342_() + 0.5f;
                                double d3 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() * 2.0;
                                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.BIG_FIRE_GROUND.get()), d1, d2, d3, 0, 0.0, 0.0, 0.0, 0.5);
                            }
                        }
                        if (this.summonTick == MathHelper.secondsToTicks(SUMMON_SECONDS_TIME - 1.0f)) {
                            ColorUtil colorUtil = new ColorUtil(16744960);
                            serverLevel.m_8767_((ParticleOptions)new CircleExplodeParticleOption(colorUtil.red(), colorUtil.green(), colorUtil.blue(), 3.0f, 1), this.getXLeft(), BlockFinder.moveDownToGround((Entity)this), this.getZLeft(), 1, 0.0, 0.0, 0.0, 0.0);
                            serverLevel.m_8767_((ParticleOptions)new CircleExplodeParticleOption(colorUtil.red(), colorUtil.green(), colorUtil.blue(), 3.0f, 1), this.getXRight(), BlockFinder.moveDownToGround((Entity)this), this.getZRight(), 1, 0.0, 0.0, 0.0, 0.0);
                            this.m_5496_((SoundEvent)ModSounds.REDSTONE_MONSTROSITY_BELCH.get(), this.m_6121_(), 0.7f);
                            AABB aabb2 = new AABB(this.m_20183_());
                            for (LivingEntity target : this.f_19853_.m_45976_(LivingEntity.class, aabb2.m_82400_(MELEE_RANGE / 2.0))) {
                                if (target == this || MobUtil.areAllies((Entity)this, (Entity)target) || !target.m_6469_(this.getServantAttack(), 2.0f)) continue;
                                float f1 = 2.0f;
                                if (target.m_20191_().m_82309_() > this.m_20191_().m_82309_()) {
                                    target.m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                                    continue;
                                }
                                MobUtil.forcefulKnockBack(target, f1 * 0.5f, Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), -Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))), 0.5);
                            }
                        }
                        if (this.summonTick == MathHelper.secondsToTicks(SUMMON_SECONDS_TIME - 1.2f)) {
                            CameraShake.cameraShake(this.f_19853_, this.m_20182_(), 25.0f, 0.3f, 0, 20);
                        }
                        if (this.summonTick <= MathHelper.secondsToTicks(SUMMON_SECONDS_TIME - 2.0f) && this.summonCount != 0) {
                            for (int i = 0; i < 10; ++i) {
                                BlockPos blockPos = this.m_20183_();
                                blockPos = blockPos.m_7918_(-16 + this.f_19853_.f_46441_.m_188503_(32), 0, -16 + this.f_19853_.f_46441_.m_188503_(32));
                                Vec3 vec3 = Vec3.m_82539_((Vec3i)blockPos);
                                RedstoneCube summoned = new RedstoneCube((EntityType<? extends Owned>)((EntityType)ModEntityType.REDSTONE_CUBE.get()), this.f_19853_);
                                if (!this.f_19853_.m_45756_((Entity)summoned, summoned.m_20191_().m_82383_(vec3))) continue;
                                SummonCircleVariant summonCircle = new SummonCircleVariant(this.f_19853_, vec3, (Entity)summoned, (LivingEntity)this);
                                summonCircle.m_5496_((SoundEvent)ModSounds.DIRT_DEBRIS.get(), 3.0f, 0.4f);
                                this.f_19853_.m_7967_((Entity)summonCircle);
                            }
                            this.summonCount = 0;
                        }
                        if (this.summonTick <= 1) {
                            if (this.summonCool <= 0) {
                                this.summonCool = MathHelper.secondsToTicks(13);
                            }
                            if (this.postAttackCool <= 0) {
                                this.postAttackCool = MathHelper.secondsToTicks(0.5f);
                            }
                        }
                    }
                }
                if (this.summonCool > 0) {
                    --this.summonCool;
                }
                if (this.postAttackCool > 0) {
                    --this.postAttackCool;
                }
                if (this.belchCool > 0) {
                    --this.belchCool;
                }
            }
        } else if (this.m_6084_()) {
            if (this.bigGlowCool > 0) {
                --this.bigGlowCool;
            }
            if (!this.isActivating()) {
                if (this.bigGlow > 0.0f) {
                    if (this.bigGlowCool <= 0) {
                        this.bigGlow -= 0.1f;
                    }
                } else {
                    this.glow();
                }
            } else if (this.activateTick > 40) {
                this.bigGlow = 1.0f;
            }
        }
    }

    public void makeBigGlow() {
        this.f_19853_.m_7605_((Entity)this, (byte)5);
    }

    public void m_7822_(byte p_21375_) {
        if (p_21375_ == 5) {
            this.bigGlow = 1.0f;
            this.bigGlowCool = 10;
        } else if (p_21375_ == 6) {
            this.clientStop = true;
        } else if (p_21375_ == 7) {
            this.clientStop = false;
        } else {
            super.m_7822_(p_21375_);
        }
    }

    @Override
    public double getAttackReachSqr(LivingEntity enemy) {
        return (double)(this.m_20205_() * 6.0f + enemy.m_20205_()) + 1.0;
    }

    @Override
    public boolean targetClose(LivingEntity enemy, double distToEnemySqr) {
        double reach = this.getAttackReachSqr(enemy);
        return distToEnemySqr <= reach || (double)this.m_20270_((Entity)enemy) <= MELEE_RANGE || this.m_20191_().m_82400_(4.0).m_82381_(enemy.m_20191_());
    }

    public boolean targetClose(LivingEntity entity) {
        return this.targetClose(entity, this.m_20280_((Entity)entity));
    }

    public double getXLeft() {
        return this.m_20185_() + this.getHorizontalLookAngle().f_82479_ * 2.0 + MobUtil.getHorizontalLeftLookAngle((Entity)this).f_82479_ * 2.0;
    }

    public double getZLeft() {
        return this.m_20189_() + this.getHorizontalLookAngle().f_82481_ * 2.0 + MobUtil.getHorizontalLeftLookAngle((Entity)this).f_82481_ * 2.0;
    }

    public double getXRight() {
        return this.m_20185_() + this.getHorizontalLookAngle().f_82479_ * 2.0 + MobUtil.getHorizontalRightLookAngle((Entity)this).f_82479_ * 2.0;
    }

    public double getZRight() {
        return this.m_20189_() + this.getHorizontalLookAngle().f_82481_ * 2.0 + MobUtil.getHorizontalRightLookAngle((Entity)this).f_82481_ * 2.0;
    }

    @Override
    public boolean m_7327_(Entity entityIn) {
        if (!this.f_19853_.f_46443_ && !this.isMeleeAttacking()) {
            this.setMeleeAttacking(true);
        }
        return true;
    }

    public Vec3 getHorizontalLookAngle() {
        return this.m_20171_(0.0f, this.m_146908_());
    }

    @Override
    public void tryKill(Player player) {
        if (this.killChance <= 0) {
            this.warnKill(player);
        } else {
            super.tryKill(player);
        }
    }

    @Override
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        if (!this.f_19853_.f_46443_) {
            ItemStack itemstack = pPlayer.m_21120_(pHand);
            if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner()) {
                if ((itemstack.m_204117_(Tags.Items.STORAGE_BLOCKS_REDSTONE) || itemstack.m_150930_(((Block)ModBlocks.REINFORCED_REDSTONE_BLOCK.get()).m_5456_())) && this.m_21223_() < this.m_21233_()) {
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    if (itemstack.m_150930_(((Block)ModBlocks.REINFORCED_REDSTONE_BLOCK.get()).m_5456_())) {
                        this.m_5634_(this.m_21233_() / 4.0f);
                        this.m_5496_(SoundEvents.f_12009_, 1.0f, 1.25f);
                    } else {
                        this.m_5634_(this.m_21233_() / 4.0f / 8.0f);
                        this.m_5496_(SoundEvents.f_12009_, 0.25f, 0.75f);
                    }
                    Level level = this.f_19853_;
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        for (int i = 0; i < 7; ++i) {
                            double d0 = serverLevel.f_46441_.m_188583_() * 0.02;
                            double d1 = serverLevel.f_46441_.m_188583_() * 0.02;
                            double d2 = serverLevel.f_46441_.m_188583_() * 0.02;
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.HEAL_EFFECT.get()), this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                        }
                    }
                    return InteractionResult.SUCCESS;
                }
                if (this.m_146895_() != null && this.m_146895_() != pPlayer) {
                    this.m_146895_().m_8127_();
                    return InteractionResult.SUCCESS;
                }
                if (!(pPlayer.m_21120_(pHand).m_41720_() instanceof IWand)) {
                    this.doPlayerRide(pPlayer);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public static class SlowRotMoveControl
    extends MobUtil.noSpinControl {
        private float trueSpeed;
        private float additionalRot;

        public SlowRotMoveControl(Mob mob) {
            super(mob);
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.STRAFE) {
                float f8;
                float f = (float)this.f_24974_.m_21133_(Attributes.f_22279_);
                float f1 = (float)this.f_24978_ * f;
                float f2 = this.f_24979_;
                float f3 = this.f_24980_;
                float f4 = Mth.m_14116_((float)(f2 * f2 + f3 * f3));
                this.trueSpeed = Mth.m_14179_((float)0.1f, (float)this.trueSpeed, (float)f1);
                if (f4 < 1.0f) {
                    f4 = 1.0f;
                }
                f4 = this.trueSpeed / f4;
                float f5 = Mth.m_14031_((float)(this.f_24974_.m_146908_() * ((float)Math.PI / 180)));
                float f6 = Mth.m_14089_((float)(this.f_24974_.m_146908_() * ((float)Math.PI / 180)));
                float f7 = (f2 *= f4) * f6 - (f3 *= f4) * f5;
                if (!this.m_24996_(f7, f8 = f3 * f6 + f2 * f5)) {
                    this.f_24979_ = 1.0f;
                    this.f_24980_ = 0.0f;
                }
                this.f_24974_.m_7910_(this.trueSpeed);
                this.f_24974_.m_21564_(this.f_24979_);
                this.f_24974_.m_21570_(this.f_24980_);
                this.f_24981_ = MoveControl.Operation.WAIT;
            } else if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                this.f_24981_ = MoveControl.Operation.WAIT;
                double d0 = this.f_24975_ - this.f_24974_.m_20185_();
                double d1 = this.f_24977_ - this.f_24974_.m_20189_();
                double d2 = this.f_24976_ - this.f_24974_.m_20186_();
                double d3 = d0 * d0 + d2 * d2 + d1 * d1;
                if (d3 < 2.500000277905201E-7) {
                    this.trueSpeed = Mth.m_14179_((float)0.1f, (float)this.trueSpeed, (float)0.0f);
                    this.f_24974_.m_21564_(this.trueSpeed);
                    if (this.additionalRot > 0.0f) {
                        this.additionalRot -= 0.1f;
                    }
                    return;
                }
                this.trueSpeed = Mth.m_14179_((float)0.1f, (float)this.trueSpeed, (float)((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_))));
                float f9 = (float)(Mth.m_14136_((double)d1, (double)d0) * 57.2957763671875) - 90.0f;
                if (this.additionalRot < 1.0f) {
                    this.additionalRot += 0.1f;
                }
                this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), f9, 5.0f + this.additionalRot * 5.0f));
                this.f_24974_.m_7910_(this.trueSpeed);
                BlockPos blockpos = this.f_24974_.m_20183_();
                BlockState blockstate = this.f_24974_.f_19853_.m_8055_(blockpos);
                VoxelShape voxelshape = blockstate.m_60812_((BlockGetter)this.f_24974_.f_19853_, blockpos);
                if (d2 > (double)this.f_24974_.getStepHeight() && d0 * d0 + d1 * d1 < (double)Math.max(1.0f, this.f_24974_.m_20205_()) || !voxelshape.m_83281_() && this.f_24974_.m_20186_() < voxelshape.m_83297_(Direction.Axis.Y) + (double)blockpos.m_123342_() && !blockstate.m_204336_(BlockTags.f_13103_) && !blockstate.m_204336_(BlockTags.f_13039_)) {
                    this.f_24974_.m_21569_().m_24901_();
                    this.f_24981_ = MoveControl.Operation.JUMPING;
                }
            } else if (this.f_24981_ == MoveControl.Operation.JUMPING) {
                this.trueSpeed = Mth.m_14179_((float)0.1f, (float)this.trueSpeed, (float)((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_))));
                this.f_24974_.m_7910_(this.trueSpeed);
                if (this.f_24974_.m_20096_()) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                }
            } else {
                this.trueSpeed = Mth.m_14179_((float)0.1f, (float)this.trueSpeed, (float)0.0f);
                this.f_24974_.m_21564_(this.trueSpeed);
                if (this.additionalRot > 0.0f) {
                    this.additionalRot -= 0.1f;
                }
            }
        }

        private boolean m_24996_(float p_24997_, float p_24998_) {
            PathNavigation pathnavigation = this.f_24974_.m_21573_();
            if (pathnavigation != null) {
                NodeEvaluator nodeevaluator = pathnavigation.m_26575_();
                return nodeevaluator == null || nodeevaluator.m_8086_((BlockGetter)this.f_24974_.f_19853_, Mth.m_14107_((double)(this.f_24974_.m_20185_() + (double)p_24997_)), this.f_24974_.m_146904_(), Mth.m_14107_((double)(this.f_24974_.m_20189_() + (double)p_24998_))) == BlockPathTypes.WALKABLE;
            }
            return true;
        }
    }

    public static class SummonGoal
    extends Goal {
        public RedstoneMonstrosity mob;

        public SummonGoal(RedstoneMonstrosity mob) {
            this.mob = mob;
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.mob.m_5448_();
            int i = this.mob.f_19853_.m_45976_(RedstoneCube.class, this.mob.m_20191_().m_82400_(32.0)).size();
            if (livingentity != null && livingentity.m_6084_()) {
                return this.mob.summonCool <= 0 && i < 3 && !this.mob.isMeleeAttacking() && !this.mob.isBelching() && this.mob.m_20096_() && this.mob.m_20270_((Entity)livingentity) < 16.0f;
            }
            return false;
        }

        public void m_8056_() {
            super.m_8056_();
            if (this.mob.m_5448_() != null) {
                MobUtil.instaLook((Mob)this.mob, (Entity)this.mob.m_5448_());
            }
            this.mob.m_216990_((SoundEvent)ModSounds.REDSTONE_MONSTROSITY_CHARGE.get());
            this.mob.setAnimationState(SUMMON);
            this.mob.summonTick = MathHelper.secondsToTicks(SUMMON_SECONDS_TIME);
            this.mob.summonCount = 1;
        }
    }

    static class MeleeGoal
    extends Goal {
        public RedstoneMonstrosity mob;

        public MeleeGoal(RedstoneMonstrosity mob) {
            this.mob = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return this.mob.m_5448_() != null && !this.mob.isSummoning() && !this.mob.isBelching() && this.mob.isMeleeAttacking();
        }

        public boolean m_8045_() {
            return this.mob.attackTick < MathHelper.secondsToTicks(3.2917f) && !this.mob.isSummoning() && !this.mob.isBelching();
        }

        public void m_8056_() {
            this.mob.setMeleeAttacking(true);
            if (this.mob.m_5448_() != null) {
                MobUtil.instaLook((Mob)this.mob, (Entity)this.mob.m_5448_());
            }
        }

        public void m_8041_() {
            this.mob.setMeleeAttacking(false);
            this.mob.setAnimationState(IDLE);
        }

        public void m_8037_() {
            if (this.mob.attackTick < 30 && this.mob.m_5448_() != null) {
                MobUtil.rotateTo((Mob)this.mob, this.mob.m_5448_(), 5.0f);
            }
            this.mob.m_21573_().m_26573_();
            if (this.mob.attackTick > 0 && this.mob.getCurrentAnimation() != this.mob.getAnimationState(ATTACK)) {
                this.mob.m_216990_((SoundEvent)ModSounds.REDSTONE_MONSTROSITY_GROWL.get());
                this.mob.setAnimationState(ATTACK);
            }
            if (this.mob.attackTick == 34) {
                LivingEntity target2;
                this.mob.makeBigGlow();
                this.mob.m_5496_((SoundEvent)ModSounds.REDSTONE_MONSTROSITY_SMASH.get(), this.mob.m_6121_() * 2.0f, 0.2f);
                this.mob.m_5496_(SoundEvents.f_11913_, this.mob.m_6121_() / 2.0f, 0.9f);
                Vec3 vec3 = this.mob.getHorizontalLookAngle();
                AABB aabb = new AABB(this.mob.m_20183_());
                for (LivingEntity target2 : this.mob.f_19853_.m_45976_(LivingEntity.class, aabb.m_82383_(vec3.m_82490_(5.0)).m_82400_(MELEE_RANGE))) {
                    if (MobUtil.areAllies((Entity)this.mob, (Entity)target2)) continue;
                    this.hurtTarget((Entity)target2);
                }
                CameraShake.cameraShake(this.mob.f_19853_, this.mob.m_20182_(), 25.0f, 0.3f, 0, 20);
                target2 = this.mob.f_19853_;
                if (target2 instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)target2;
                    ColorUtil colorUtil = new ColorUtil(16744960);
                    Vec3 vec31 = this.mob.m_20182_().m_82549_(vec3.m_82490_(5.0));
                    ServerParticleUtil.windShockwaveParticle(serverLevel, colorUtil, 2.0f, 0.0f, 20, -1, vec31.m_82520_(0.0, 1.0, 0.0));
                    ServerParticleUtil.windShockwaveParticle(serverLevel, colorUtil, 4.0f, 0.0f, 20, -1, vec31.m_82520_(0.0, 1.0, 0.0));
                }
            }
        }

        public void hurtTarget(Entity target) {
            Player player;
            boolean flag;
            float f = (float)this.mob.m_21133_(Attributes.f_22281_);
            float f1 = (float)this.mob.m_21133_(Attributes.f_22282_);
            if (target instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)target;
                f += livingEntity.m_21233_() * ((Double)AttributesConfig.RedstoneMonstrosityHPPercentDamage.get()).floatValue();
            }
            if (flag = target.m_6469_(this.mob.getServantAttack(), f)) {
                if (f1 > 0.0f && target instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)target;
                    if (livingEntity.m_20191_().m_82309_() > this.mob.m_20191_().m_82309_()) {
                        livingEntity.m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(this.mob.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.mob.m_146908_() * ((float)Math.PI / 180)))));
                    } else {
                        MobUtil.forcefulKnockBack(livingEntity, f1 * 0.5f, Mth.m_14031_((float)(this.mob.m_146908_() * ((float)Math.PI / 180))), -Mth.m_14089_((float)(this.mob.m_146908_() * ((float)Math.PI / 180))), 0.5);
                    }
                    this.mob.m_20256_(this.mob.m_20184_().m_82542_(0.6, 1.0, 0.6));
                }
                this.mob.m_19970_((LivingEntity)this.mob, target);
                this.mob.m_21335_(target);
            }
            if (target instanceof Player && (player = (Player)target).m_21254_()) {
                player.m_36384_(true);
            } else {
                MobUtil.disableShield(target);
            }
        }

        public boolean m_183429_() {
            return true;
        }
    }

    public static class BelchGoal
    extends Goal {
        private final RedstoneMonstrosity mob;
        private int attackTime = 0;
        private int seeTime;

        public BelchGoal(RedstoneMonstrosity mob) {
            this.mob = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (this.mob.belchCool <= 0 && livingentity != null && livingentity.m_6084_() && !this.mob.targetClose(livingentity) && this.mob.m_20270_((Entity)livingentity) <= 13.0f) {
                return !this.mob.isMeleeAttacking() && !this.mob.isSummoning();
            }
            return false;
        }

        public boolean m_8045_() {
            return this.m_8036_() || !this.mob.isMeleeAttacking() && !this.mob.isSummoning() && this.attackTime > 0 && this.mob.belchCool <= 0;
        }

        public void m_8041_() {
            this.mob.setBelching(false);
            this.seeTime = 0;
            this.attackTime = 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity target = this.mob.m_5448_();
            if (!this.mob.isMeleeAttacking() && !this.mob.isSummoning()) {
                if (target != null) {
                    double distance = this.mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
                    boolean flag = this.mob.m_21574_().m_148306_((Entity)target);
                    this.seeTime = flag ? ++this.seeTime : 0;
                    if (distance <= (double)Mth.m_144944_((int)32) && this.seeTime >= 5) {
                        this.mob.m_21573_().m_26573_();
                    } else {
                        this.mob.m_21573_().m_5624_((Entity)target, 1.0);
                    }
                    MobUtil.instaLook((Mob)this.mob, (Entity)target);
                }
                ++this.attackTime;
                if (this.attackTime == 1) {
                    this.mob.m_5496_((SoundEvent)ModSounds.REDSTONE_MONSTROSITY_ARM.get(), this.mob.m_6121_() * 0.7f, this.mob.m_6100_());
                    this.mob.setBelching(true);
                    this.mob.setAnimationState(BELCH);
                } else if (this.attackTime > 5 && this.attackTime < 17) {
                    this.mob.makeBigGlow();
                } else if (this.attackTime == 17) {
                    Vec3 vec3 = this.mob.m_20182_().m_82549_(this.mob.m_20154_().m_82490_(10.0));
                    for (int i = 0; i < 8; ++i) {
                        ScatterBomb bomb = this.getScatterBomb(vec3);
                        this.mob.f_19853_.m_7967_((Entity)bomb);
                    }
                    this.mob.m_5496_((SoundEvent)ModSounds.REDSTONE_MONSTROSITY_BELCH.get(), this.mob.m_6121_(), 0.7f);
                    this.mob.m_5496_((SoundEvent)ModSounds.REDSTONE_MONSTROSITY_GROWL.get(), this.mob.m_6121_() - 1.5f, 0.9f);
                } else if (this.attackTime >= 37) {
                    this.mob.setBelching(false);
                    this.mob.postAttackCool = MathHelper.secondsToTicks(0.5f);
                    this.attackTime = 0;
                    this.mob.belchCool = MathHelper.secondsToTicks(8);
                }
            }
        }

        @NotNull
        private ScatterBomb getScatterBomb(Vec3 vec3) {
            LivingEntity livingEntity;
            ScatterBomb bomb = new ScatterBomb((LivingEntity)this.mob, this.mob.f_19853_);
            double d1 = vec3.f_82479_ - this.mob.m_20185_();
            double d2 = vec3.f_82480_ - bomb.m_20186_();
            double d3 = vec3.f_82481_ - this.mob.m_20189_();
            double d4 = Math.sqrt(d1 * d1 + d3 * d3);
            bomb.m_146926_(bomb.m_146909_() - -20.0f);
            bomb.m_6027_(this.mob.m_20185_(), this.mob.m_20186_() + 4.5, this.mob.m_20189_());
            float velocity = 1.0f;
            if (this.mob.m_5448_() != null && (livingEntity = this.mob.m_5448_()).m_20270_((Entity)this.mob) <= 13.0f) {
                velocity = Math.max(0.25f, livingEntity.m_20270_((Entity)this.mob) / 13.0f);
            }
            this.shoot(bomb, d1, d2 + d4, d3, velocity, 30.0f);
            return bomb;
        }

        public void shoot(Projectile projectile, double xPower, double yPower, double zPower, float velocity, float inaccuracy) {
            Vec3 vec3 = new Vec3(xPower, yPower, zPower).m_82541_().m_82520_(this.mob.f_19796_.m_216328_(0.0, 0.0172275 * (double)inaccuracy), this.mob.f_19796_.m_216328_(0.0, 0.0861375), this.mob.f_19796_.m_216328_(0.0, 0.0172275 * (double)inaccuracy)).m_82490_((double)velocity);
            projectile.m_20256_(vec3);
            double d0 = vec3.m_165924_();
            projectile.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
            projectile.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875));
            projectile.f_19859_ = projectile.m_146908_();
            projectile.f_19860_ = projectile.m_146909_();
        }
    }

    static class AttackGoal
    extends MeleeAttackGoal {
        public RedstoneMonstrosity mob;
        private final double moveSpeed;
        private int delayCounter;

        public AttackGoal(RedstoneMonstrosity mob, double moveSpeed) {
            super((PathfinderMob)mob, moveSpeed, true);
            this.mob = mob;
            this.moveSpeed = moveSpeed;
        }

        public boolean m_8036_() {
            return this.mob.m_5448_() != null && !this.mob.isSummoning() && !this.mob.isBelching() && !this.mob.isMeleeAttacking() && this.mob.m_5448_().m_6084_();
        }

        public void m_8056_() {
            this.mob.m_21561_(true);
            this.delayCounter = 0;
        }

        public void m_8041_() {
            this.mob.m_21573_().m_26573_();
            if (this.mob.m_5448_() == null) {
                this.mob.m_21561_(false);
            }
        }

        public void m_8037_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity == null) {
                return;
            }
            this.mob.m_21563_().m_24960_((Entity)livingentity, (float)this.mob.m_8085_(), (float)this.mob.m_8132_());
            if (--this.delayCounter <= 0) {
                this.delayCounter = 10;
                this.mob.m_21573_().m_5624_((Entity)livingentity, this.moveSpeed);
            }
            this.m_6739_(livingentity, this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_()));
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            if (this.mob.targetClose(enemy, distToEnemySqr)) {
                this.mob.m_7327_((Entity)enemy);
            }
        }
    }

    public static class RMBodyRotateControl
    extends BodyRotationControl {
        private final Mob mob;
        private static final float MAX_ROTATE = 75.0f;
        private int headStableTime;
        private float lastStableYHeadRot;

        public RMBodyRotateControl(Mob mob) {
            super(mob);
            this.mob = mob;
        }

        public void m_8121_() {
            if (this.m_24884_()) {
                this.mob.f_20883_ = this.mob.m_146908_();
                this.m_24881_();
                this.lastStableYHeadRot = this.mob.f_20885_;
                this.headStableTime = 0;
            } else if (this.m_24883_()) {
                if (Math.abs(this.mob.f_20885_ - this.lastStableYHeadRot) > 15.0f) {
                    this.headStableTime = 0;
                    this.lastStableYHeadRot = this.mob.f_20885_;
                    this.m_24880_();
                } else {
                    float limit = 75.0f;
                    ++this.headStableTime;
                    int speed = 10;
                    if (this.headStableTime > speed) {
                        limit = (float)Math.max(1 - (this.headStableTime - speed) / speed, 0) * 75.0f;
                    }
                    this.mob.f_20883_ = RMBodyRotateControl.approach(this.mob.f_20885_, this.mob.f_20883_, limit);
                }
            }
        }

        private void m_24880_() {
            this.mob.f_20883_ = Mth.m_14094_((float)this.mob.f_20883_, (float)this.mob.f_20885_, (float)this.mob.m_8085_());
        }

        private void m_24881_() {
            this.mob.f_20885_ = Mth.m_14094_((float)this.mob.f_20885_, (float)this.mob.f_20883_, (float)this.mob.m_8085_());
        }

        private boolean m_24883_() {
            return this.mob.m_20197_().isEmpty() || !(this.mob.m_20197_().get(0) instanceof Mob);
        }

        private boolean m_24884_() {
            double d1;
            double d0 = this.mob.m_20185_() - this.mob.f_19854_;
            return d0 * d0 + (d1 = this.mob.m_20189_() - this.mob.f_19856_) * d1 > 2.500000277905201E-7;
        }

        public static float approach(float target, float current, float limit) {
            float delta = Mth.m_14177_((float)(current - target));
            if (delta < -limit) {
                delta = -limit;
            } else if (delta >= limit) {
                delta = limit;
            }
            return target + delta * 0.55f;
        }
    }
}

