/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.illager;

import com.Polarice3.Goety.api.entities.ITrainable;
import com.Polarice3.Goety.common.advancements.ModCriteriaTriggers;
import com.Polarice3.Goety.common.blocks.entities.OminousIdolBlockEntity;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.illager.AbstractIllagerServant;
import com.Polarice3.Goety.common.entities.ally.illager.AllyTrampler;
import com.Polarice3.Goety.common.entities.ally.illager.ModRavager;
import com.Polarice3.Goety.common.entities.ally.illager.WitchServant;
import com.Polarice3.Goety.common.entities.ally.undead.bound.AbstractBoundIllager;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.items.WaystoneItem;
import com.Polarice3.Goety.common.items.magic.TaglockKit;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SPlayPlayerSoundPacket;
import com.Polarice3.Goety.config.MainConfig;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.EntityFinder;
import com.Polarice3.Goety.utils.ItemHelper;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.SEHelper;
import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import org.jetbrains.annotations.Nullable;

public abstract class RaiderServant
extends Summoned {
    protected static final EntityDataAccessor<Boolean> IS_CELEBRATING = SynchedEntityData.m_135353_(RaiderServant.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> CAPTURE_MODE = SynchedEntityData.m_135353_(RaiderServant.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Optional<UUID>> MARKED_ID = SynchedEntityData.m_135353_(RaiderServant.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<Optional<UUID>> LEADER_ID = SynchedEntityData.m_135353_(RaiderServant.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<Integer> LEADER_CLIENT_ID = SynchedEntityData.m_135353_(RaiderServant.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Optional<BlockPos>> RAID_POS = SynchedEntityData.m_135353_(RaiderServant.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    protected static final EntityDataAccessor<String> RAID_DIM = SynchedEntityData.m_135353_(RaiderServant.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    @Nullable
    public BlockPos revivePos;
    public String reviveDim = Level.f_46428_.m_135782_().toString();
    private int celebrationTime;
    private int raidTime;
    private boolean missionComplete = false;

    public RaiderServant(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.miscGoal();
        this.f_21345_.m_25352_(1, new ObtainLeaderBannerGoal<RaiderServant>(this));
        this.f_21345_.m_25352_(3, new PathfindToRaidGoal<RaiderServant>(this));
        this.f_21345_.m_25352_(4, (Goal)new RaiderMoveThroughVillageGoal(this, 1.05, 1));
        this.f_21345_.m_25352_(5, (Goal)new CelebrateGoal(this));
    }

    @Override
    public void followGoal() {
        this.f_21345_.m_25352_(6, (Goal)new Summoned.FollowOwnerGoal<RaiderServant>(this, 1.0, 10.0f, 2.0f){

            @Override
            public boolean m_8036_() {
                ITrainable trainable;
                if (RaiderServant.this.isRaiding()) {
                    return false;
                }
                RaiderServant raiderServant = RaiderServant.this;
                if (raiderServant instanceof ITrainable && (trainable = (ITrainable)((Object)raiderServant)).isTraining()) {
                    return false;
                }
                if (RaiderServant.this.getLeader() != null) {
                    RaiderServant livingentity = RaiderServant.this.getLeader();
                    if (livingentity == null) {
                        return false;
                    }
                    if (livingentity.m_5833_()) {
                        return false;
                    }
                    if (RaiderServant.this.m_20280_((Entity)livingentity) < (double)Mth.m_14207_((float)this.startDistance)) {
                        return false;
                    }
                    if (!RaiderServant.this.isFollowing() || RaiderServant.this.isCommanded()) {
                        return false;
                    }
                    if (RaiderServant.this.m_5448_() != null) {
                        return false;
                    }
                    this.owner = livingentity;
                    return true;
                }
                return super.m_8036_();
            }

            @Override
            public boolean m_8045_() {
                ITrainable trainable;
                RaiderServant raiderServant = RaiderServant.this;
                if (raiderServant instanceof ITrainable && (trainable = (ITrainable)((Object)raiderServant)).isTraining()) {
                    return false;
                }
                return super.m_8045_();
            }
        });
    }

    @Override
    public void targetSelectGoal() {
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false, livingEntity -> this.isRaiding() && !livingEntity.m_6162_()));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, false, livingEntity -> this.isRaiding() && !livingEntity.m_6162_() && livingEntity.m_6095_().m_204039_(ModTags.EntityTypes.VILLAGE_GUARDS)));
        super.targetSelectGoal();
    }

    public void miscGoal() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(8, new RaiderWanderGoal<RaiderServant>(this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 15.0f));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_CELEBRATING, (Object)false);
        this.f_19804_.m_135372_(CAPTURE_MODE, (Object)false);
        this.f_19804_.m_135372_(MARKED_ID, Optional.empty());
        this.f_19804_.m_135372_(LEADER_ID, Optional.empty());
        this.f_19804_.m_135372_(LEADER_CLIENT_ID, (Object)-1);
        this.f_19804_.m_135372_(RAID_POS, Optional.empty());
        this.f_19804_.m_135372_(RAID_DIM, (Object)Level.f_46428_.m_135782_().toString());
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getMarkedId() != null) {
            compound.m_128362_("Marked", this.getMarkedId());
        }
        if (this.getLeaderId() != null) {
            compound.m_128362_("Leader", this.getLeaderId());
        }
        if (this.getLeaderClientId() > -1) {
            compound.m_128405_("LeaderClient", this.getLeaderClientId());
        }
        if (this.getRaidPos() != null) {
            compound.m_128365_("RaidPos", (Tag)NbtUtils.m_129224_((BlockPos)this.getRaidPos()));
            compound.m_128359_("RaidDim", this.getRaidDim());
        }
        compound.m_128405_("CelebrationTime", this.celebrationTime);
        compound.m_128405_("RaidTime", this.raidTime);
        compound.m_128379_("MissionComplete", this.missionComplete);
        compound.m_128379_("Capturing", this.isCapturing());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Marked")) {
            this.setMarkedId(compound.m_128342_("Marked"));
        }
        if (compound.m_128441_("Leader")) {
            this.setLeaderId(compound.m_128342_("Leader"));
        }
        if (compound.m_128441_("LeaderClient")) {
            this.setLeaderClientId(compound.m_128451_("LeaderClient"));
        }
        if (compound.m_128441_("RaidPos")) {
            this.setRaidPos(NbtUtils.m_129239_((CompoundTag)compound.m_128469_("RaidPos")));
            this.setRaidDim(compound.m_128461_("RaidDim"));
        }
        if (compound.m_128441_("CelebrationTime")) {
            this.celebrationTime = compound.m_128451_("CelebrationTime");
        }
        if (compound.m_128441_("RaidTime")) {
            this.raidTime = compound.m_128451_("RaidTime");
        }
        if (compound.m_128441_("MissionComplete")) {
            this.missionComplete = compound.m_128471_("MissionComplete");
        }
        if (compound.m_128441_("Capturing")) {
            this.setCaptureMode(compound.m_128471_("Capturing"));
        }
    }

    @Nullable
    public LivingEntity getMarked() {
        UUID uuid = this.getMarkedId();
        return uuid == null ? null : EntityFinder.getLivingEntityByUuiD(uuid);
    }

    @Nullable
    public UUID getMarkedId() {
        return ((Optional)this.f_19804_.m_135370_(MARKED_ID)).orElse(null);
    }

    public void setMarkedId(@Nullable UUID p_184754_1_) {
        this.f_19804_.m_135381_(MARKED_ID, Optional.ofNullable(p_184754_1_));
    }

    public void setMarked(@Nullable LivingEntity livingEntity) {
        if (livingEntity != null) {
            this.setMarkedId(livingEntity.m_20148_());
        } else {
            this.setMarkedId(null);
        }
    }

    @Nullable
    public RaiderServant getLeader() {
        RaiderServant servant;
        Entity entity;
        if (!this.f_19853_.f_46443_) {
            RaiderServant servant2;
            LivingEntity livingEntity;
            UUID uuid = this.getLeaderId();
            return uuid == null ? null : ((livingEntity = EntityFinder.getLivingEntityByUuiD(uuid)) instanceof RaiderServant && (servant2 = (RaiderServant)livingEntity).m_6084_() && servant2.canBeLeader() && servant2 != this ? servant2 : null);
        }
        int id = this.getLeaderClientId();
        return id <= -1 ? null : ((entity = this.f_19853_.m_6815_(this.getLeaderClientId())) instanceof RaiderServant && (servant = (RaiderServant)entity).m_6084_() && servant.canBeLeader() && servant != this ? servant : null);
    }

    @Nullable
    public UUID getLeaderId() {
        return ((Optional)this.f_19804_.m_135370_(LEADER_ID)).orElse(null);
    }

    public void setLeaderId(@Nullable UUID p_184754_1_) {
        this.f_19804_.m_135381_(LEADER_ID, Optional.ofNullable(p_184754_1_));
    }

    public int getLeaderClientId() {
        return (Integer)this.f_19804_.m_135370_(LEADER_CLIENT_ID);
    }

    public void setLeaderClientId(int p_184754_1_) {
        this.f_19804_.m_135381_(LEADER_CLIENT_ID, (Object)p_184754_1_);
    }

    public void setLeader(@Nullable RaiderServant livingEntity) {
        if (livingEntity != null && livingEntity != this) {
            this.setLeaderId(livingEntity.m_20148_());
            this.setLeaderClientId(livingEntity.m_19879_());
        } else {
            this.setLeaderId(null);
            this.setLeaderClientId(-1);
        }
    }

    public boolean isLeader() {
        if (this.canBeLeader()) {
            if (this.getLeaderBannerInstance().m_41619_()) {
                return this.m_6844_(EquipmentSlot.HEAD).m_204117_(ItemTags.f_13191_);
            }
            return ItemStack.m_41728_((ItemStack)this.m_6844_(EquipmentSlot.HEAD), (ItemStack)this.getLeaderBannerInstance());
        }
        return false;
    }

    public boolean isFollower() {
        return this.getLeader() != null;
    }

    @Nullable
    public BlockPos getRaidPos() {
        return ((Optional)this.f_19804_.m_135370_(RAID_POS)).orElse(null);
    }

    public void setRaidPos(@Nullable BlockPos blockPos) {
        this.f_19804_.m_135381_(RAID_POS, Optional.ofNullable(blockPos));
    }

    public ResourceKey<Level> getRaidLevel() {
        ResourceLocation resourcelocation = new ResourceLocation(this.getRaidDim());
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)resourcelocation);
    }

    public String getRaidDim() {
        return (String)this.f_19804_.m_135370_(RAID_DIM);
    }

    public void setRaidDim(ResourceKey<Level> resourceKey) {
        this.setRaidDim(resourceKey.m_135782_().toString());
    }

    public void setRaidDim(String string) {
        this.f_19804_.m_135381_(RAID_DIM, (Object)string);
    }

    public boolean isRaiding() {
        return this.getRaidPos() != null;
    }

    public void setCaptureMode(boolean captureMode) {
        this.f_19804_.m_135381_(CAPTURE_MODE, (Object)captureMode);
    }

    public boolean isCapturing() {
        return (Boolean)this.f_19804_.m_135370_(CAPTURE_MODE);
    }

    public double m_6049_() {
        return -0.45;
    }

    @Nullable
    public BlockPos findRandomSpawnPos(int p_37708_, int p_37709_) {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.getRaidPos() != null) {
                int i = p_37708_ == 0 ? 2 : 2 - p_37708_;
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int i1 = 0; i1 < p_37709_; ++i1) {
                    float f = this.f_19853_.f_46441_.m_188501_() * ((float)Math.PI * 2);
                    int j = this.getRaidPos().m_123341_() + Mth.m_14143_((float)(Mth.m_14089_((float)f) * 32.0f * (float)i)) + this.f_19853_.f_46441_.m_188503_(5);
                    int l = this.getRaidPos().m_123343_() + Mth.m_14143_((float)(Mth.m_14031_((float)f) * 32.0f * (float)i)) + this.f_19853_.f_46441_.m_188503_(5);
                    int k = this.f_19853_.m_6924_(Heightmap.Types.WORLD_SURFACE, j, l);
                    blockpos$mutableblockpos.m_122178_(j, k, l);
                    if (serverLevel.m_8802_((BlockPos)blockpos$mutableblockpos) && p_37708_ < 2) continue;
                    int j1 = 10;
                    if (!this.f_19853_.m_151572_(blockpos$mutableblockpos.m_123341_() - j1, blockpos$mutableblockpos.m_123343_() - j1, blockpos$mutableblockpos.m_123341_() + j1, blockpos$mutableblockpos.m_123343_() + j1) || !serverLevel.m_143340_((BlockPos)blockpos$mutableblockpos) || !NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)this.f_19853_, (BlockPos)blockpos$mutableblockpos, (EntityType)EntityType.f_20518_) && (!this.f_19853_.m_8055_(blockpos$mutableblockpos.m_7495_()).m_60713_(Blocks.f_50125_) || !this.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos).m_60795_())) continue;
                    return blockpos$mutableblockpos;
                }
            }
        }
        return null;
    }

    public boolean isCelebrating() {
        return (Boolean)this.f_19804_.m_135370_(IS_CELEBRATING);
    }

    public void setCelebrating(boolean p_37900_) {
        this.f_19804_.m_135381_(IS_CELEBRATING, (Object)p_37900_);
    }

    public SoundEvent getCelebrateSound() {
        return SoundEvents.f_271165_;
    }

    @Override
    public boolean canUpdateMove() {
        return true;
    }

    @Override
    public void updateMoveMode(Player player) {
        if (this.getLeader() != null) {
            player.m_5661_((Component)Component.m_237110_((String)"info.goety.servant.removeLeader", (Object[])new Object[]{this.m_5446_(), this.getLeader().m_5446_()}), true);
            this.setLeader(null);
            this.m_5496_(SoundEvents.f_12616_, 1.0f, 1.0f);
        } else {
            super.updateMoveMode(player);
        }
    }

    @Override
    public void setCommandPosEntityOrder(LivingEntity living) {
        if (living instanceof RaiderServant) {
            RaiderServant servant = (RaiderServant)living;
            RaiderServant leader = null;
            if (servant != this) {
                if (servant.isLeader()) {
                    leader = servant;
                } else if (servant.isFollower()) {
                    leader = servant.getLeader();
                }
            }
            if (leader != null && this.canBeFollower()) {
                this.setLeader(leader);
                this.setFollowing();
                LivingEntity livingEntity = this.getTrueOwner();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    player.m_5661_((Component)Component.m_237110_((String)"info.goety.servant.setLeaderGroup", (Object[])new Object[]{leader.m_5446_()}), true);
                }
            } else {
                super.setCommandPosEntity(living);
            }
        } else {
            super.setCommandPosEntity(living);
        }
    }

    @Override
    public void setCommandPosEntity(LivingEntity living) {
        if (living instanceof RaiderServant) {
            RaiderServant servant = (RaiderServant)living;
            RaiderServant leader = null;
            if (servant != this) {
                if (servant.isLeader()) {
                    leader = servant;
                } else if (servant.isFollower()) {
                    leader = servant.getLeader();
                }
            }
            if (leader != null && this.canBeFollower()) {
                this.setLeader(leader);
                this.setFollowing();
                LivingEntity livingEntity = this.getTrueOwner();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    player.m_5661_((Component)Component.m_237110_((String)"info.goety.servant.setLeader", (Object[])new Object[]{this.m_5446_(), leader.m_5446_()}), true);
                }
            } else {
                super.setCommandPosEntity(living);
            }
        } else {
            super.setCommandPosEntity(living);
        }
    }

    @Override
    public void m_6667_(DamageSource pCause) {
        if (this.getMarked() != null) {
            this.setMarked(null);
        }
        if (this.getRaidPos() != null) {
            this.setRaidPos(null);
        }
        super.m_6667_(pCause);
    }

    @Override
    public void onCeaseFire(ServerPlayer player) {
        if ((player.m_21205_().m_204117_(ItemTags.f_13191_) || player.m_21206_().m_204117_(ItemTags.f_13191_)) && this.getRaidPos() != null) {
            if (this.isLeader()) {
                player.m_5661_((Component)Component.m_237110_((String)"info.goety.servant.stopRaid", (Object[])new Object[]{this.getRaidPos().m_123341_(), this.getRaidPos().m_123342_(), this.getRaidPos().m_123343_()}), false);
            }
            this.setRaidPos(null);
        }
    }

    public boolean canCelebrate() {
        return true;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            if (this.celebrationTime > 0) {
                --this.celebrationTime;
            } else if (this.missionComplete) {
                if (this.getTrueOwner() != null && (double)this.getTrueOwner().m_20270_((Entity)this) > 32.0 && MobUtil.sameDimension((Entity)this, (Entity)this.getTrueOwner())) {
                    this.teleportTowards((Entity)this.getTrueOwner());
                }
                this.missionComplete = false;
            }
            if (this.getLeader() != null) {
                if (this.getLeader().f_19797_ >= 100 && !this.getLeader().isLeader() || this.getLeader().m_21224_() || this.isLeader()) {
                    this.setLeader(null);
                } else {
                    ITrainable trainable;
                    RaiderServant raiderServant;
                    OminousIdolBlockEntity idol;
                    if (this.getLeader().f_19797_ < 20) {
                        Entity entity = this.f_19853_.m_6815_(this.getOwnerClientId());
                        if (entity instanceof RaiderServant) {
                            RaiderServant raiderServant2 = (RaiderServant)entity;
                            if (raiderServant2 != this.getLeader()) {
                                this.setLeaderClientId(this.getLeader().m_19879_());
                            }
                        } else {
                            this.setLeaderClientId(this.getLeader().m_19879_());
                        }
                    }
                    if (this.canLinkToIdol() && this.getLeader().getIdol() != null && (idol = this.getLeader().getIdol()) != null && (this.getIdol() == null || this.getIdol() != idol) && idol.getIllagers().size() < (Integer)MainConfig.OminousIdolLimit.get()) {
                        if (this.getIdol() != null) {
                            this.getIdol().removeIllager(this);
                        }
                        idol.addIllager(this);
                    }
                    if (!((raiderServant = this) instanceof ITrainable) || (trainable = (ITrainable)((Object)raiderServant)).isTraining()) {
                        if (this.getLeader().getMarked() != null && this.getLeader().getMarked() != this.getMarked()) {
                            this.setMarked(this.getLeader().getMarked());
                        }
                        if (this.getLeader().getRaidPos() != null && !BlockFinder.samePos(this.getLeader().getRaidPos(), this.getRaidPos())) {
                            this.setRaidPos(this.getLeader().getRaidPos());
                        } else if (this.getLeader().m_5448_() != null && this.m_5448_() == null) {
                            this.m_6710_(this.getLeader().m_5448_());
                        }
                    }
                    this.setCaptureMode(this.getLeader().isCapturing());
                }
            } else if (this.isCapturing() && !this.isLeader()) {
                this.setCaptureMode(false);
            }
            this.markedTick();
            this.raidTick();
        }
    }

    public void markedTick() {
        if (this.getMarked() != null) {
            try {
                if (this.m_5448_() == null) {
                    if (EntitySelector.f_20406_.test(this.getMarked()) && MobUtil.sameDimension((Entity)this, (Entity)this.getMarked()) && this.f_19853_.m_46749_(this.getMarked().m_20183_())) {
                        this.m_6710_(this.getMarked());
                        Entity entity = this.m_275832_();
                        if (entity instanceof Mob) {
                            Mob mob = (Mob)entity;
                            mob.m_6710_(this.getMarked());
                        }
                    }
                } else if (this.m_5448_() == this.getMarked() && (double)this.m_5448_().m_20270_((Entity)this) > 64.0 && MobUtil.sameDimension((Entity)this, (Entity)this.getMarked())) {
                    this.teleportTowards((Entity)this.getMarked());
                }
                if (this.getTrueOwner() != null && MobUtil.areAllies((Entity)this.getMarked(), (Entity)this.getTrueOwner())) {
                    if ((double)this.getTrueOwner().m_20270_((Entity)this) > 32.0 && MobUtil.sameDimension((Entity)this, (Entity)this.getTrueOwner())) {
                        this.teleportTowards((Entity)this.getTrueOwner());
                    }
                    if (this.getMarked() != null) {
                        this.setMarked(null);
                    }
                }
                if (this.getMarked().m_21224_()) {
                    this.celebrationTime = 600;
                    this.missionComplete = true;
                    if (this.getMarked() != null) {
                        this.setMarked(null);
                    }
                } else if (this.isLeader()) {
                    for (RaiderServant servant : this.getNearbyCompanions()) {
                        if (servant.getLeader() != null || servant.getMarked() != this.getMarked()) continue;
                        servant.setLeader(this);
                        servant.setFollowing();
                    }
                }
            }
            catch (NullPointerException exception) {
                this.celebrationTime = 600;
                this.missionComplete = true;
                this.setMarked(null);
            }
        }
    }

    public void raidTick() {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.getRaidPos() != null) {
                Player player;
                LivingEntity livingEntity;
                if (this.f_19853_.m_46472_() != this.getRaidLevel()) {
                    this.setRaidPos(null);
                    if (this.getTrueOwner() != null && (double)this.getTrueOwner().m_20270_((Entity)this) > 32.0 && MobUtil.sameDimension((Entity)this, (Entity)this.getTrueOwner())) {
                        this.teleportTowards((Entity)this.getTrueOwner());
                    }
                }
                if (!serverLevel.m_8802_(this.getRaidPos())) {
                    this.moveRaidCenterToNearbyVillageSection();
                }
                if (!serverLevel.m_8802_(this.getRaidPos())) {
                    this.celebrationTime = 600;
                    this.missionComplete = true;
                    this.setRaidPos(null);
                    livingEntity = this.getTrueOwner();
                    if (livingEntity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                        ModCriteriaTriggers.SERVANT_RAID_VICTORY.m_222618_(serverPlayer);
                    }
                }
                ++this.raidTime;
                if (this.raidTime >= 48000) {
                    this.setRaidPos(null);
                    if (this.getTrueOwner() != null && (double)this.getTrueOwner().m_20270_((Entity)this) > 32.0 && MobUtil.sameDimension((Entity)this, (Entity)this.getTrueOwner())) {
                        this.teleportTowards((Entity)this.getTrueOwner());
                    }
                }
                if ((livingEntity = this.getTrueOwner()) instanceof Player && SEHelper.getAllyEntityTypes(player = (Player)livingEntity).contains(EntityType.f_20492_)) {
                    this.setRaidPos(null);
                    if ((double)this.getTrueOwner().m_20270_((Entity)this) > 32.0 && MobUtil.sameDimension((Entity)this, (Entity)this.getTrueOwner())) {
                        this.teleportTowards((Entity)this.getTrueOwner());
                    }
                }
                if (this.isLeader()) {
                    for (RaiderServant servant : this.getNearbyCompanions()) {
                        if (servant.getLeader() != null || servant.getRaidPos() != this.getRaidPos()) continue;
                        servant.setLeader(this);
                        servant.setFollowing();
                    }
                }
            } else if (this.raidTime > 0) {
                this.raidTime = 0;
            }
        }
    }

    @Override
    public void teleportTowards(Entity entity) {
        LivingEntity livingEntity;
        Entity entity2 = this.m_275832_();
        if (entity2 instanceof LivingEntity && !((livingEntity = (LivingEntity)entity2) instanceof RaiderServant)) {
            if (!this.f_19853_.m_5776_() && livingEntity.m_6084_()) {
                for (int i = 0; i < 128; ++i) {
                    double d3;
                    double d2;
                    Vec3 vector3d = new Vec3(livingEntity.m_20185_() - entity.m_20185_(), livingEntity.m_20227_(0.5) - entity.m_20188_(), livingEntity.m_20189_() - entity.m_20189_());
                    vector3d = vector3d.m_82541_();
                    double d0 = 16.0;
                    double d1 = livingEntity.m_20185_() + (livingEntity.m_217043_().m_188500_() - 0.5) * 8.0 - vector3d.f_82479_ * d0;
                    EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)livingEntity, (double)d1, (double)(d2 = livingEntity.m_20186_() + (double)(livingEntity.m_217043_().m_188503_(16) - 8) - vector3d.f_82480_ * d0), (double)(d3 = livingEntity.m_20189_() + (livingEntity.m_217043_().m_188500_() - 0.5) * 8.0 - vector3d.f_82481_ * d0));
                    if (!event.isCanceled()) {
                        if (!livingEntity.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), false)) continue;
                        this.teleportHits();
                    }
                    break;
                }
            }
        } else {
            super.teleportTowards(entity);
        }
    }

    @Override
    public void teleportHits() {
    }

    private void moveRaidCenterToNearbyVillageSection() {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.getRaidPos() != null) {
                Stream stream = SectionPos.m_123201_((SectionPos)SectionPos.m_123199_((BlockPos)this.getRaidPos()), (int)2);
                stream.filter(arg_0 -> ((ServerLevel)serverLevel).m_8762_(arg_0)).map(SectionPos::m_123250_).min(Comparator.comparingDouble(p_37766_ -> p_37766_.m_123331_((Vec3i)this.getRaidPos()))).ifPresent(this::setRaidPos);
            }
        }
    }

    public boolean canBeLeader() {
        return false;
    }

    public boolean canBeFollower() {
        return true;
    }

    public boolean canJoinPatrol() {
        Player player;
        LivingEntity livingEntity = this.getTrueOwner();
        if (livingEntity instanceof Player && SEHelper.isGrounded(player = (Player)livingEntity, (LivingEntity)this)) {
            return false;
        }
        return this.canBeFollower();
    }

    public ItemStack getBannerPatternInstance() {
        Player player;
        ListTag listTag;
        LivingEntity livingEntity = this.getTrueOwner();
        if (livingEntity instanceof Player && (listTag = SEHelper.getBannerPattern(player = (Player)livingEntity)) != null) {
            ItemStack itemstack = new ItemStack((ItemLike)BannerBlock.m_49014_((DyeColor)SEHelper.getBannerBaseColor(player)));
            CompoundTag compoundtag = new CompoundTag();
            compoundtag.m_128365_("Patterns", (Tag)listTag);
            BlockItem.m_186338_((ItemStack)itemstack, (BlockEntityType)BlockEntityType.f_58935_, (CompoundTag)compoundtag);
            return itemstack;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack getLeaderBannerInstance() {
        Player player;
        ListTag listTag;
        LivingEntity livingEntity = this.getTrueOwner();
        if (livingEntity instanceof Player && (listTag = SEHelper.getBannerPattern(player = (Player)livingEntity)) != null) {
            ItemStack itemstack = this.getBannerPatternInstance();
            itemstack.m_41654_(ItemStack.TooltipPart.ADDITIONAL);
            itemstack.m_41714_((Component)Component.m_237110_((String)"block.goety.player_banner", (Object[])new Object[]{player.m_5446_()}).m_130940_(ChatFormatting.GOLD));
            return itemstack;
        }
        return ItemStack.f_41583_;
    }

    @Nullable
    public <T extends Mob> T m_21406_(EntityType<T> p_21407_, boolean p_21408_) {
        Mob convert = super.m_21406_(p_21407_, p_21408_);
        if (convert instanceof RaiderServant) {
            RaiderServant servant = (RaiderServant)convert;
            if (this.getLeader() != null) {
                servant.setLeader(this.getLeader());
            }
        }
        return (T)convert;
    }

    @Nullable
    public OminousIdolBlockEntity getIdol() {
        if (this.m_20194_() != null && this.revivePos != null) {
            for (Level level1 : this.m_20194_().m_129785_()) {
                OminousIdolBlockEntity idol;
                BlockEntity blockEntity;
                if (level1.m_46472_() != this.getReviveLevel() || !((blockEntity = this.f_19853_.m_7702_(this.revivePos)) instanceof OminousIdolBlockEntity) || (idol = (OminousIdolBlockEntity)blockEntity).getTrueOwner() != this.getTrueOwner()) continue;
                return idol;
            }
        }
        return null;
    }

    @Override
    public void tryKill(Player player) {
        if (this.killChance <= 0 && this.getIdol() != null) {
            this.warnKill(player);
        } else {
            super.tryKill(player);
        }
    }

    @Override
    public boolean canRevive(DamageSource damageSource) {
        if (!damageSource.m_276093_(ModDamageSource.DISMISSED) && ((Boolean)MainConfig.OminousIdolRevive.get()).booleanValue() && !this.m_21023_((MobEffect)GoetyEffects.WOUNDED.get()) && this.getIdol() != null && this.getIdol().getSoulEnergy() >= (Integer)MainConfig.OminousIdolReviveCost.get()) {
            return this.getIdol().getIllagers().contains(this);
        }
        return false;
    }

    @Override
    public void reviveOwned() {
        if (this.isLeader()) {
            this.m_19983_(this.m_6844_(EquipmentSlot.HEAD));
            this.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
        }
        super.reviveOwned();
        this.m_6710_(null);
        this.setMarked(null);
        this.setRaidPos(null);
        this.f_19853_.m_7605_((Entity)this, (byte)35);
        this.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.WOUNDED.get(), MathHelper.minecraftDayToTicks(1)));
        this.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.CRIPPLED.get(), MathHelper.minutesToTicks(5)));
        if (this.getIdol() != null) {
            this.getIdol().siphonSoulEnergy((Integer)MainConfig.OminousIdolReviveCost.get());
        }
    }

    @Override
    @Nullable
    public BlockPos getRevivePos() {
        return this.revivePos;
    }

    @Override
    public void setRevivePos(BlockPos revivePos) {
        this.revivePos = revivePos;
    }

    @Override
    public String getReviveDim() {
        return this.reviveDim;
    }

    @Override
    public void setReviveDim(String reviveDim) {
        this.reviveDim = reviveDim;
    }

    public boolean canLinkToIdol() {
        return this instanceof AbstractIllagerServant || this instanceof AbstractBoundIllager || this instanceof WitchServant || this instanceof AllyTrampler || this instanceof ModRavager;
    }

    public List<RaiderServant> getNearbyCompanions() {
        return this.f_19853_.m_6443_(RaiderServant.class, this.m_20191_().m_82400_(8.0), illager -> illager != this && illager.getTrueOwner() == this.getTrueOwner() && illager.canJoinPatrol() && (illager.getLeader() == null || illager.getLeader() == this));
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner()) {
            if (this.canBeLeader() && !this.getLeaderBannerInstance().m_41619_() && ItemHelper.sameBanner(itemstack, this.getBannerPatternInstance()) && !ItemStack.m_41728_((ItemStack)this.m_6844_(EquipmentSlot.HEAD), (ItemStack)this.getLeaderBannerInstance())) {
                ItemStack helmet = this.m_6844_(EquipmentSlot.HEAD);
                this.m_5496_(SoundEvents.f_11675_, 1.0f, 1.0f);
                this.m_5496_(this.getCelebrateSound(), 1.0f, this.m_6100_());
                this.dropEquipment(EquipmentSlot.HEAD, helmet);
                this.m_8061_(EquipmentSlot.HEAD, this.getLeaderBannerInstance());
                this.m_21508_(EquipmentSlot.HEAD);
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                for (int i = 0; i < 7; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
                }
                return InteractionResult.SUCCESS;
            }
            if (pPlayer.m_21205_().m_41720_() instanceof TaglockKit && TaglockKit.hasEntity(pPlayer.m_21205_()) && !MobUtil.areAllies((Entity)pPlayer, (Entity)TaglockKit.getEntity(pPlayer.m_21205_())) && this.isLeader()) {
                Object player;
                LivingEntity i;
                this.setMarked(TaglockKit.getEntity(pPlayer.m_21205_()));
                this.m_6710_(this.getMarked());
                if (!pPlayer.m_150110_().f_35937_) {
                    TaglockKit.removeEntity(pPlayer.m_21205_());
                }
                if (!this.f_19853_.f_46443_ && (i = this.getMarked()) instanceof ServerPlayer && CuriosFinder.hasCurio((LivingEntity)(player = (ServerPlayer)i), (Item)ModItems.ALARMING_CHARM.get())) {
                    player.m_5661_((Component)Component.m_237115_((String)"info.goety.summon.hunt").m_130940_(ChatFormatting.RED), true);
                    ModNetwork.sendToClient((ServerPlayer)player, new SPlayPlayerSoundPacket((SoundEvent)SoundEvents.f_12355_.get(), 64.0f, 1.0f));
                }
                if (this.isStaying()) {
                    this.setStaying(false);
                }
                if (this.isGuardingArea()) {
                    this.setBoundPos(null);
                }
                for (RaiderServant servant : this.getNearbyCompanions()) {
                    servant.setMarked(this.getMarked());
                    servant.m_6710_(this.getMarked());
                    if (servant.getLeader() == null) {
                        servant.setLeader(this);
                        servant.setFollowing();
                    }
                    if (!MobUtil.sameDimension((Entity)servant, (Entity)this.getMarked())) continue;
                    servant.teleportTowards((Entity)this.getMarked());
                }
                if (MobUtil.sameDimension((Entity)this, (Entity)this.getMarked())) {
                    this.teleportTowards((Entity)this.getMarked());
                }
                return InteractionResult.SUCCESS;
            }
            if (pPlayer.m_21205_().m_150930_((Item)ModItems.WAYSTONE.get()) && WaystoneItem.hasBlock(pPlayer.m_21205_()) && WaystoneItem.isSameDimension((LivingEntity)this, pPlayer.m_21205_()) && pPlayer.m_21206_().m_150930_(Items.f_220219_) && !SEHelper.getFocusCoolDown(pPlayer).isOnCooldown((Item)ModItems.WAYSTONE.get()) && this.isLeader()) {
                Level servant = this.f_19853_;
                if (servant instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)servant;
                    GlobalPos globalPos = WaystoneItem.getPosition(pPlayer.m_21205_());
                    if (globalPos != null) {
                        BlockPos blockPos = globalPos.m_122646_();
                        if (!serverLevel.m_46749_(blockPos)) {
                            pPlayer.m_5661_((Component)Component.m_237115_((String)"info.goety.waystone.unloaded"), true);
                            return InteractionResult.FAIL;
                        }
                        if (serverLevel.m_8802_(blockPos)) {
                            boolean flag;
                            Player player;
                            LivingEntity d1 = this.getTrueOwner();
                            if (d1 instanceof Player && SEHelper.getAllyEntityTypes(player = (Player)d1).contains(EntityType.f_20492_)) {
                                return InteractionResult.FAIL;
                            }
                            this.setRaidPos(blockPos);
                            this.setRaidDim((ResourceKey<Level>)serverLevel.m_46472_());
                            if (this.isStaying()) {
                                this.setStaying(false);
                            }
                            if (this.isGuardingArea()) {
                                this.setBoundPos(null);
                            }
                            boolean bl = flag = this.m_20182_().m_82557_(blockPos.m_252807_()) <= (double)Mth.m_144944_((int)32);
                            if (!flag) {
                                int k = 0;
                                BlockPos blockPos1 = this.findRandomSpawnPos(k, 20);
                                if (blockPos1 != null) {
                                    for (RaiderServant servant2 : this.getNearbyCompanions()) {
                                        servant2.setRaidPos(blockPos);
                                        servant2.setRaidDim((ResourceKey<Level>)serverLevel.m_46472_());
                                        if (servant2.getLeader() == null) {
                                            servant2.setLeader(this);
                                            servant2.setFollowing();
                                        }
                                        servant2.m_20035_(blockPos1, 0.0f, 0.0f);
                                    }
                                    this.m_20035_(blockPos1, 0.0f, 0.0f);
                                    flag = true;
                                } else {
                                    ++k;
                                }
                            }
                            if (flag) {
                                long j = serverLevel.m_213780_().m_188505_();
                                for (ServerPlayer serverplayer : serverLevel.m_6907_()) {
                                    Vec3 vec3 = serverplayer.m_20182_();
                                    Vec3 vec31 = this.m_20182_();
                                    double d0 = Math.sqrt((vec31.f_82479_ - vec3.f_82479_) * (vec31.f_82479_ - vec3.f_82479_) + (vec31.f_82481_ - vec3.f_82481_) * (vec31.f_82481_ - vec3.f_82481_));
                                    double d12 = vec3.f_82479_ + 13.0 / d0 * (vec31.f_82479_ - vec3.f_82479_);
                                    double d2 = vec3.f_82481_ + 13.0 / d0 * (vec31.f_82481_ - vec3.f_82481_);
                                    if (!(d0 <= 64.0)) continue;
                                    serverplayer.f_8906_.m_9829_((Packet)new ClientboundSoundPacket((Holder)SoundEvents.f_12355_, SoundSource.NEUTRAL, d12, serverplayer.m_20186_(), d2, 64.0f, 1.0f, j));
                                }
                                LivingEntity livingEntity = this.getTrueOwner();
                                if (livingEntity instanceof Player) {
                                    Player player2 = (Player)livingEntity;
                                    SEHelper.addCooldown(player2, (Item)ModItems.WAYSTONE.get(), 300);
                                }
                                return InteractionResult.SUCCESS;
                            }
                        }
                    }
                }
                return InteractionResult.CONSUME;
            }
            if (pPlayer.m_21205_().m_150930_(Items.f_42026_) && !this.isCapturing() && this.isLeader()) {
                if (!this.f_19853_.f_46443_) {
                    this.setCaptureMode(true);
                    this.m_5496_(SoundEvents.f_11745_, 1.0f, 1.0f);
                }
                return InteractionResult.SUCCESS;
            }
            if (pPlayer.m_21205_().m_204117_(ItemTags.f_271207_) && this.isCapturing() && this.isLeader()) {
                if (!this.f_19853_.f_46443_) {
                    this.setCaptureMode(false);
                    this.m_5496_(SoundEvents.f_11794_, 1.0f, 0.5f);
                }
                return InteractionResult.SUCCESS;
            }
            if (pPlayer.m_21205_().m_41619_() && this.m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof BannerItem) {
                ItemStack helmet = this.m_6844_(EquipmentSlot.HEAD);
                this.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                this.dropEquipment(EquipmentSlot.HEAD, helmet);
                return InteractionResult.SUCCESS;
            }
            if (this.canLinkToIdol()) {
                return this.linkToIdol(pPlayer, pHand);
            }
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public InteractionResult linkToIdol(Player pPlayer, InteractionHand pHand) {
        OminousIdolBlockEntity idol;
        BlockEntity blockEntity;
        if (pPlayer.m_21205_().m_150930_((Item)ModItems.WAYSTONE.get()) && WaystoneItem.isSameDimension((LivingEntity)this, pPlayer.m_21205_()) && (blockEntity = WaystoneItem.getBlockEntity(pPlayer.m_21205_(), this.f_19853_)) instanceof OminousIdolBlockEntity && (idol = (OminousIdolBlockEntity)blockEntity).getTrueOwner() == this.getTrueOwner() && idol.getIllagers().size() < (Integer)MainConfig.OminousIdolLimit.get() && !this.f_19853_.f_46443_) {
            BlockPos blockPos = idol.m_58899_();
            if (this.getIdol() != null) {
                this.getIdol().removeIllager(this);
            }
            idol.addIllager(this);
            this.m_5496_(SoundEvents.f_11686_, 1.0f, 0.45f);
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 7; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                }
            }
            this.setRevivePos(blockPos);
            this.setReviveDim(this.f_19853_.m_46472_());
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public static class ObtainLeaderBannerGoal<T extends RaiderServant>
    extends Goal {
        private final T mob;

        public ObtainLeaderBannerGoal(T p_37917_) {
            this.mob = p_37917_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            Optional optional;
            List list;
            RaiderServant raider;
            if (!(((RaiderServant)this.mob).getMarked() == null && !((RaiderServant)this.mob).isRaiding() || !((RaiderServant)this.mob).canBeLeader() || ((RaiderServant)this.mob).getLeaderBannerInstance().m_41619_() || ItemStack.m_41728_((ItemStack)this.mob.m_6844_(EquipmentSlot.HEAD), (ItemStack)((RaiderServant)this.mob).getLeaderBannerInstance()) || (raider = ((RaiderServant)this.mob).getLeader()) != null && raider.m_6084_() || (list = ((RaiderServant)this.mob).f_19853_.m_6443_(ItemEntity.class, this.mob.m_20191_().m_82377_(16.0, 8.0, 16.0), itemEntity -> !itemEntity.m_32063_() && itemEntity.m_6084_() && ItemHelper.sameBanner(itemEntity.m_32055_(), ((RaiderServant)this.mob).getBannerPatternInstance()))).isEmpty() || !(optional = list.stream().findFirst()).isPresent())) {
                return this.mob.m_21573_().m_5624_((Entity)optional.get(), 1.15);
            }
            return false;
        }

        public void m_8037_() {
            Optional optional;
            List list = ((RaiderServant)this.mob).f_19853_.m_6443_(ItemEntity.class, this.mob.m_20191_().m_82377_(4.0, 4.0, 4.0), itemEntity -> !itemEntity.m_32063_() && itemEntity.m_6084_() && ItemHelper.sameBanner(itemEntity.m_32055_(), ((RaiderServant)this.mob).getBannerPatternInstance()));
            if (!list.isEmpty() && (optional = list.stream().findFirst()).isPresent()) {
                ((RaiderServant)this.mob).m_7581_((ItemEntity)optional.get());
            }
        }

        public boolean m_183429_() {
            return true;
        }
    }

    public static class PathfindToRaidGoal<T extends RaiderServant>
    extends Goal {
        private final T mob;

        public PathfindToRaidGoal(T p_25706_) {
            this.mob = p_25706_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            ServerLevel serverLevel;
            Level level;
            return this.mob.m_5448_() == null && !((Owned)this.mob).m_20160_() && ((RaiderServant)this.mob).isRaiding() && (level = ((RaiderServant)this.mob).f_19853_) instanceof ServerLevel && !(serverLevel = (ServerLevel)level).m_8802_(this.mob.m_20183_());
        }

        public boolean m_8045_() {
            ServerLevel serverLevel;
            Level level;
            return ((RaiderServant)this.mob).isRaiding() && (level = ((RaiderServant)this.mob).f_19853_) instanceof ServerLevel && !(serverLevel = (ServerLevel)level).m_8802_(this.mob.m_20183_());
        }

        public void m_8037_() {
            Vec3 vec3;
            if (((RaiderServant)this.mob).getRaidPos() != null && !this.mob.m_21691_() && (vec3 = DefaultRandomPos.m_148412_(this.mob, (int)15, (int)4, (Vec3)Vec3.m_82539_((Vec3i)((RaiderServant)this.mob).getRaidPos()), (double)1.5707963705062866)) != null) {
                this.mob.m_21573_().m_26519_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1.0);
            }
        }
    }

    static class RaiderMoveThroughVillageGoal
    extends Goal {
        private final RaiderServant raider;
        private final double speedModifier;
        private BlockPos poiPos;
        private final List<BlockPos> visited = Lists.newArrayList();
        private final int distanceToPoi;
        private boolean stuck;

        public RaiderMoveThroughVillageGoal(RaiderServant p_37936_, double p_37937_, int p_37938_) {
            this.raider = p_37936_;
            this.speedModifier = p_37937_;
            this.distanceToPoi = p_37938_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            this.updateVisited();
            return this.raider.isRaiding() && this.hasSuitablePoi() && this.raider.m_5448_() == null;
        }

        public boolean m_8045_() {
            if (this.raider.m_21573_().m_26571_()) {
                return false;
            }
            return this.raider.m_5448_() == null && !this.poiPos.m_203195_((Position)this.raider.m_20182_(), (double)(this.raider.m_20205_() + (float)this.distanceToPoi)) && !this.stuck;
        }

        private boolean hasSuitablePoi() {
            ServerLevel serverlevel = (ServerLevel)this.raider.m_9236_();
            BlockPos blockpos = this.raider.m_20183_();
            Optional optional = serverlevel.m_8904_().m_217951_(p_219843_ -> p_219843_.m_203565_(PoiTypes.f_218060_), this::hasNotVisited, PoiManager.Occupancy.ANY, blockpos, 48, this.raider.f_19796_);
            if (optional.isEmpty()) {
                return false;
            }
            this.poiPos = ((BlockPos)optional.get()).m_7949_();
            return true;
        }

        public void m_8041_() {
            if (this.poiPos.m_203195_((Position)this.raider.m_20182_(), (double)this.distanceToPoi)) {
                this.visited.add(this.poiPos);
            }
        }

        public void m_8056_() {
            super.m_8056_();
            this.raider.m_21310_(0);
            this.raider.m_21573_().m_26519_((double)this.poiPos.m_123341_(), (double)this.poiPos.m_123342_(), (double)this.poiPos.m_123343_(), this.speedModifier);
            this.stuck = false;
        }

        public void m_8037_() {
            if (this.raider.m_21573_().m_26571_()) {
                Vec3 vec3 = Vec3.m_82539_((Vec3i)this.poiPos);
                Vec3 vec31 = DefaultRandomPos.m_148412_((PathfinderMob)this.raider, (int)16, (int)7, (Vec3)vec3, (double)0.3141592741012573);
                if (vec31 == null) {
                    vec31 = DefaultRandomPos.m_148412_((PathfinderMob)this.raider, (int)8, (int)7, (Vec3)vec3, (double)1.5707963705062866);
                }
                if (vec31 == null) {
                    this.stuck = true;
                    return;
                }
                this.raider.m_21573_().m_26519_(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, this.speedModifier);
            }
        }

        private boolean hasNotVisited(BlockPos p_37943_) {
            for (BlockPos blockpos : this.visited) {
                if (!Objects.equals(p_37943_, blockpos)) continue;
                return false;
            }
            return true;
        }

        private void updateVisited() {
            if (this.visited.size() > 2) {
                this.visited.remove(0);
            }
        }
    }

    public static class CelebrateGoal
    extends Goal {
        private final RaiderServant mob;

        public CelebrateGoal(RaiderServant p_37924_) {
            this.mob = p_37924_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return this.mob.m_6084_() && this.mob.m_5448_() == null && this.mob.canCelebrate() && this.mob.celebrationTime > 0;
        }

        public void m_8056_() {
            this.mob.setCelebrating(true);
            super.m_8056_();
        }

        public void m_8041_() {
            this.mob.setCelebrating(false);
            super.m_8041_();
        }

        public void m_8037_() {
            if (!this.mob.m_20067_() && this.mob.f_19796_.m_188503_(this.m_183277_(100)) == 0) {
                this.mob.m_5496_(this.mob.getCelebrateSound(), this.mob.m_6121_(), this.mob.m_6100_());
            }
            if (!this.mob.m_20159_() && this.mob.f_19796_.m_188503_(this.m_183277_(50)) == 0) {
                this.mob.m_21569_().m_24901_();
            }
            super.m_8037_();
        }
    }

    public static class RaiderWanderGoal<T extends RaiderServant>
    extends Summoned.WanderGoal<T> {
        public RaiderWanderGoal(T entity, double speedModifier) {
            super(entity, speedModifier);
        }

        public RaiderWanderGoal(T entity, double speedModifier, float probability) {
            super(entity, speedModifier, probability);
        }

        public RaiderWanderGoal(T entity, double speedModifier, int interval, float probability) {
            super(entity, speedModifier, interval, probability);
        }

        @Override
        @Nullable
        protected Vec3 m_7037_() {
            ITrainable trainable;
            if (this.f_25725_.m_20072_()) {
                Vec3 vec3 = this.landRandomPos(15, 7);
                return vec3 == null ? this.defaultRandomPos() : vec3;
            }
            PathfinderMob vec3 = this.summonedEntity;
            if (vec3 instanceof ITrainable && (trainable = (ITrainable)vec3).isTraining()) {
                if (trainable.getTrainPos().isPresent()) {
                    vec3 = null;
                    int range = 4;
                    for (int i = 0; i < 10; ++i) {
                        BlockPos blockPos = trainable.getTrainPos().get().m_7918_(((RaiderServant)this.summonedEntity).m_217043_().m_216332_(-range, range), ((RaiderServant)this.summonedEntity).m_217043_().m_216332_(-range, range), ((RaiderServant)this.summonedEntity).m_217043_().m_216332_(-range, range));
                        BlockPos blockPos1 = LandRandomPos.m_148518_((PathfinderMob)this.summonedEntity, (BlockPos)blockPos);
                        if (blockPos1 == null) continue;
                        vec3 = Vec3.m_82539_((Vec3i)blockPos1);
                        break;
                    }
                    return vec3;
                }
            } else if (((RaiderServant)this.summonedEntity).getLeader() != null) {
                vec3 = null;
                int xz = 8;
                int y = 4;
                for (int i = 0; i < 10; ++i) {
                    BlockPos blockPos = ((RaiderServant)this.summonedEntity).getLeader().m_20183_().m_7918_(((RaiderServant)this.summonedEntity).m_217043_().m_216332_(-xz, xz), ((RaiderServant)this.summonedEntity).m_217043_().m_216332_(-y, y), ((RaiderServant)this.summonedEntity).m_217043_().m_216332_(-xz, xz));
                    BlockPos blockPos1 = LandRandomPos.m_148518_((PathfinderMob)this.summonedEntity, (BlockPos)blockPos);
                    if (blockPos1 == null) continue;
                    vec3 = Vec3.m_82539_((Vec3i)blockPos1);
                    break;
                }
                return vec3;
            }
            return super.m_7037_();
        }
    }
}

