/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.client.particles.DustCloudParticleOption;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.projectiles.SpellEntity;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class EarthFist
extends SpellEntity {
    private int warmupDelayTicks;
    private boolean sentSpikeEvent;
    private int lifeTicks = 30;
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState retreatAnimationState = new AnimationState();

    public EarthFist(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
        this.m_6210_();
    }

    public EarthFist(Level pLevel, LivingEntity pOwner) {
        this((EntityType)ModEntityType.EARTH_FIST.get(), pLevel);
        this.setOwner(pOwner);
    }

    public EarthFist(Level pLevel, double x, double y, double z, LivingEntity pOwner) {
        this((EntityType)ModEntityType.EARTH_FIST.get(), pLevel);
        this.setOwner(pOwner);
        this.m_6034_(x, y, z);
    }

    public EarthFist(Level pLevel, Vec3 vec3, LivingEntity pOwner) {
        this((EntityType)ModEntityType.EARTH_FIST.get(), pLevel);
        this.setOwner(pOwner);
        this.m_6034_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
    }

    public boolean m_5829_() {
        return true;
    }

    public void setWarmupDelayTicks(int warmupDelayTicks) {
        this.warmupDelayTicks = warmupDelayTicks;
    }

    public boolean isSentSpikeEvent() {
        return this.sentSpikeEvent;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            MobUtil.moveDownToGround(this);
            --this.warmupDelayTicks;
            if (this.warmupDelayTicks < 0) {
                if (!this.sentSpikeEvent) {
                    Level livingentity2;
                    this.f_19853_.m_7605_((Entity)this, (byte)4);
                    this.sentSpikeEvent = true;
                    this.m_6210_();
                    for (Level livingentity2 : this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82400_(0.25))) {
                        this.dealDamageTo((LivingEntity)livingentity2);
                    }
                    livingentity2 = this.f_19853_;
                    if (livingentity2 instanceof ServerLevel) {
                        Object option;
                        ServerLevel serverLevel = (ServerLevel)livingentity2;
                        BlockPos blockPos = BlockPos.m_274561_((double)this.m_20185_(), (double)(this.m_20186_() - 1.0), (double)this.m_20189_());
                        BlockState blockState = serverLevel.m_8055_(blockPos);
                        for (int i = 0; i < 8; ++i) {
                            option = new BlockParticleOption(ParticleTypes.f_123794_, blockState);
                            ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)option, this, 0.0, 1.0, 0.0, 1.5f);
                        }
                        Vector3f vector3f = new Vector3f((Vector3fc)Vec3.m_82501_((int)0x7F7D7D).m_252839_());
                        option = new DustCloudParticleOption(vector3f, 1.0f);
                        ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)option, this, 1.5f);
                    }
                }
                --this.lifeTicks;
                if (this.lifeTicks == 0) {
                    this.f_19853_.m_7605_((Entity)this, (byte)5);
                }
                if (this.lifeTicks <= -8) {
                    this.m_146870_();
                }
            } else {
                Level blockPos = this.f_19853_;
                if (blockPos instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)blockPos;
                    blockPos = BlockPos.m_274561_((double)this.m_20185_(), (double)(this.m_20186_() - 1.0), (double)this.m_20189_());
                    BlockParticleOption option = new BlockParticleOption(ParticleTypes.f_123794_, serverLevel.m_8055_((BlockPos)blockPos));
                    ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)option, this, 1.5f);
                }
            }
        }
    }

    private void dealDamageTo(LivingEntity target) {
        LivingEntity livingentity = this.m_269323_();
        float baseDamage = ((Double)SpellConfig.FangDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
        baseDamage += this.getExtraDamage();
        if (target.m_6084_() && !target.m_20147_()) {
            boolean hurt;
            if (livingentity == null) {
                hurt = target.m_6469_(this.m_269291_().m_269425_(), baseDamage);
            } else {
                if (target == livingentity) {
                    return;
                }
                if (MobUtil.areAllies((Entity)target, (Entity)livingentity)) {
                    return;
                }
                hurt = target.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)livingentity), baseDamage);
            }
            if (hurt) {
                MobUtil.push((Entity)target, 0.0, 1.0, 0.0);
            }
        }
    }

    public EntityDimensions m_6972_(Pose p_19975_) {
        if (!this.sentSpikeEvent) {
            return super.m_6972_(p_19975_).m_20388_(0.0f);
        }
        return super.m_6972_(p_19975_);
    }

    public void m_7822_(byte p_36935_) {
        super.m_7822_(p_36935_);
        if (p_36935_ == 4) {
            this.attackAnimationState.m_216977_(this.f_19797_);
            this.sentSpikeEvent = true;
            this.m_6210_();
            if (!this.m_20067_()) {
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.WALL_ERUPT.get(), this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.2f + 0.85f, false);
            }
        } else if (p_36935_ == 5) {
            this.attackAnimationState.m_216973_();
            this.retreatAnimationState.m_216977_(this.f_19797_);
        }
    }

    @Override
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

