/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.util;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.EntityFinder;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;

public class SummonCircle
extends Entity {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.m_135353_(SummonCircle.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public Entity entity;
    public boolean preMade;
    public boolean noPos;
    public boolean noSpin = false;
    public boolean noParticles = false;
    public int lifeSpan = 20;

    public SummonCircle(EntityType<?> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public SummonCircle(Level pLevel, Vec3 pPos, Entity pEntity, boolean preMade, boolean noPos, @Nullable LivingEntity pOwner) {
        this((EntityType)ModEntityType.SUMMON_CIRCLE.get(), pLevel);
        this.m_6034_(pPos.f_82479_, pPos.f_82480_, pPos.f_82481_);
        this.entity = pEntity;
        this.preMade = preMade;
        this.noPos = noPos;
        this.setTrueOwner(pOwner);
    }

    public SummonCircle(Level pLevel, BlockPos pPos, Entity pEntity, boolean preMade, boolean noPos, @Nullable LivingEntity pOwner) {
        this((EntityType)ModEntityType.SUMMON_CIRCLE.get(), pLevel);
        this.m_6034_(pPos.m_123341_(), pPos.m_123342_(), pPos.m_123343_());
        this.entity = pEntity;
        this.preMade = preMade;
        this.noPos = noPos;
        this.setTrueOwner(pOwner);
    }

    public float m_213856_() {
        return 1.0f;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER_UNIQUE_ID, Optional.empty());
    }

    protected void m_7378_(CompoundTag pCompound) {
        Entity entity = EntityType.m_20645_((CompoundTag)pCompound, (Level)this.f_19853_, p_58740_ -> p_58740_);
        if (entity != null) {
            this.entity = entity;
        }
        if (pCompound.m_128403_("Owner")) {
            this.setOwnerId(pCompound.m_128342_("Owner"));
        }
        this.preMade = pCompound.m_128471_("preMade");
        this.noPos = pCompound.m_128471_("noPos");
        if (pCompound.m_128441_("noSpin")) {
            this.setNoSpin(pCompound.m_128471_("noSpin"));
        }
        if (pCompound.m_128441_("noParticles")) {
            this.noParticles = pCompound.m_128471_("noParticles");
        }
        this.lifeSpan = pCompound.m_128451_("lifeSpan");
    }

    protected void m_7380_(CompoundTag pCompound) {
        if (this.entity != null) {
            this.entity.m_20223_(pCompound);
        }
        if (this.getOwnerId() != null) {
            pCompound.m_128362_("Owner", this.getOwnerId());
        }
        pCompound.m_128379_("preMade", this.preMade);
        pCompound.m_128379_("noPos", this.noPos);
        pCompound.m_128379_("noSpin", this.noSpin);
        pCompound.m_128379_("noParticles", this.noParticles);
        pCompound.m_128405_("lifeSpan", this.lifeSpan);
    }

    @Nullable
    public LivingEntity getTrueOwner() {
        try {
            UUID uuid = this.getOwnerId();
            return uuid == null ? null : EntityFinder.getLivingEntityByUuiD(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.f_19804_.m_135381_(OWNER_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    public void setTrueOwner(@Nullable LivingEntity livingEntity) {
        if (livingEntity != null) {
            this.setOwnerId(livingEntity.m_20148_());
        }
    }

    public void setLifeSpan(int lifeSpan) {
        this.lifeSpan = lifeSpan;
    }

    public void setNoSpin(boolean spin) {
        this.noSpin = spin;
        if (spin) {
            this.f_19853_.m_7605_((Entity)this, (byte)4);
        } else {
            this.f_19853_.m_7605_((Entity)this, (byte)5);
        }
    }

    public int getLifeSpan() {
        if (this.lifeSpan == 0) {
            return 20;
        }
        return this.lifeSpan;
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public void m_8119_() {
        Level level;
        super.m_8119_();
        if (!this.m_20068_()) {
            MobUtil.moveDownToGround(this);
        }
        if ((level = this.f_19853_) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            float f = 1.5f;
            float f5 = (float)Math.PI * f * f;
            if (this.f_19797_ == this.getLifeSpan()) {
                if (!this.noParticles) {
                    for (int j1 = 0; j1 < 16; ++j1) {
                        int k1 = 0;
                        while ((float)k1 < f5) {
                            float f6 = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                            float f7 = Mth.m_14116_((float)this.f_19796_.m_188501_()) * f;
                            float f8 = Mth.m_14089_((float)f6) * f7;
                            float f9 = Mth.m_14031_((float)f6) * f7;
                            serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123789_, this.m_20185_() + (double)f8, this.m_20186_(), this.m_20189_() + (double)f9, 0, 0.0, 0.5, 0.0, 0.5);
                            ++k1;
                        }
                    }
                }
                if (this.entity != null) {
                    if (this.noPos) {
                        this.entity.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                    }
                    if (this.preMade) {
                        Entity k1 = this.entity;
                        if (k1 instanceof TamableAnimal) {
                            TamableAnimal tamableAnimal = (TamableAnimal)k1;
                            if (this.getOwnerId() != null) {
                                tamableAnimal.m_21816_(this.getOwnerId());
                            }
                        }
                        if ((k1 = this.entity) instanceof IOwned) {
                            IOwned owned = (IOwned)k1;
                            if (this.getTrueOwner() != null) {
                                owned.setTrueOwner(this.getTrueOwner());
                            }
                        }
                        if ((k1 = this.entity) instanceof Mob) {
                            Mob mob1;
                            LivingEntity livingEntity;
                            Mob mob = (Mob)k1;
                            ForgeEventFactory.onFinalizeSpawn((Mob)mob, (ServerLevelAccessor)serverWorld, (DifficultyInstance)this.f_19853_.m_6436_(this.m_20183_()), (MobSpawnType)MobSpawnType.MOB_SUMMONED, null, null);
                            if (this.getTrueOwner() != null && (livingEntity = this.getTrueOwner()) instanceof Mob && (mob1 = (Mob)livingEntity).m_5448_() != null) {
                                mob.m_6710_(mob1.m_5448_());
                            }
                        }
                    }
                    serverWorld.m_7967_(this.entity);
                }
            }
        }
        if (this.f_19797_ >= this.getLifeSpan()) {
            this.m_5496_((SoundEvent)ModSounds.SUMMON_SPELL.get(), 1.0f, 1.0f);
            this.m_146870_();
        }
    }

    public void m_7822_(byte p_19882_) {
        if (p_19882_ == 4) {
            this.noSpin = true;
        } else if (p_19882_ == 5) {
            this.noSpin = false;
        } else {
            super.m_7822_(p_19882_);
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

