/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.compat.jei;

import com.Polarice3.Goety.api.ritual.IRitualType;
import com.Polarice3.Goety.api.ritual.RitualType;
import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.Polarice3.Goety.common.crafting.RitualRecipe;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.items.research.ResearchScroll;
import com.Polarice3.Goety.common.research.ResearchList;
import com.Polarice3.Goety.common.ritual.EnchantItemRitual;
import com.Polarice3.Goety.compat.jei.JeiRecipeTypes;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class ModRitualCategory
implements IRecipeCategory<RitualRecipe> {
    @Nullable
    private final String ritualType;
    private final IDrawable background;
    private final IDrawable arrow;
    private final Component localizedName;
    private final ItemStack darkAltar = new ItemStack((ItemLike)ModBlocks.DARK_ALTAR.get());
    private final ItemStack pedestals = new ItemStack((ItemLike)ModItems.PEDESTAL_DUMMY.get());
    private final int iconWidth = 16;
    private final int ritualCenterX;
    private final int ritualCenterY;
    private int recipeOutputOffsetX = 50;

    public ModRitualCategory(IGuiHelper guiHelper, @Nullable String ritualType) {
        this.ritualType = ritualType;
        this.background = guiHelper.createBlankDrawable(176, 140);
        this.ritualCenterX = this.background.getWidth() / 2 - this.iconWidth / 2 - 24;
        this.ritualCenterY = this.background.getHeight() / 2 - this.iconWidth / 2 + 10;
        this.localizedName = this.ritualType == null || Objects.equals(this.ritualType, "") ? Component.m_237115_((String)"goety.jei.ritual") : Component.m_237115_((String)("jei.goety.craftType." + ritualType)).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"goety.jei.ritualType"));
        this.darkAltar.m_41784_().m_128379_("RenderFull", true);
        this.pedestals.m_41784_().m_128379_("RenderFull", true);
        this.arrow = guiHelper.createDrawable(new ResourceLocation("goety", "textures/gui/jei/arrow.png"), 0, 0, 64, 46);
    }

    public RecipeType<RitualRecipe> getRecipeType() {
        if (this.ritualType == null || Objects.equals(this.ritualType, "")) {
            return JeiRecipeTypes.RITUAL;
        }
        return JeiRecipeTypes.getRitual(this.ritualType);
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setRecipe(IRecipeLayoutBuilder recipeLayout, RitualRecipe recipe, IFocusGroup ingredients) {
        this.recipeOutputOffsetX = 75;
        Ingredient activationItem = recipe.getActivationItem();
        if (recipe.getRitual() instanceof EnchantItemRitual) {
            activationItem = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42517_});
        }
        recipeLayout.addSlot(RecipeIngredientRole.INPUT, this.ritualCenterX, this.ritualCenterY - 15).addIngredients(activationItem);
        recipeLayout.addSlot(RecipeIngredientRole.CATALYST, this.ritualCenterX, this.ritualCenterY).addItemStack(this.darkAltar);
        int sacrificialCircleRadius = 30;
        int pedestalsPaddingVertical = 30;
        int pedestalsPaddingHorizontal = 15;
        List pedestalsPosition = Stream.of(new Vec3i(this.ritualCenterX, this.ritualCenterY - sacrificialCircleRadius, 0), new Vec3i(this.ritualCenterX + sacrificialCircleRadius, this.ritualCenterY, 0), new Vec3i(this.ritualCenterX, this.ritualCenterY + sacrificialCircleRadius, 0), new Vec3i(this.ritualCenterX - sacrificialCircleRadius, this.ritualCenterY, 0), new Vec3i(this.ritualCenterX + pedestalsPaddingHorizontal, this.ritualCenterY - sacrificialCircleRadius, 0), new Vec3i(this.ritualCenterX + sacrificialCircleRadius, this.ritualCenterY - pedestalsPaddingVertical, 0), new Vec3i(this.ritualCenterX - pedestalsPaddingHorizontal, this.ritualCenterY + sacrificialCircleRadius, 0), new Vec3i(this.ritualCenterX - sacrificialCircleRadius, this.ritualCenterY + pedestalsPaddingVertical, 0), new Vec3i(this.ritualCenterX - pedestalsPaddingHorizontal, this.ritualCenterY - sacrificialCircleRadius, 0), new Vec3i(this.ritualCenterX + sacrificialCircleRadius, this.ritualCenterY + pedestalsPaddingVertical, 0), new Vec3i(this.ritualCenterX + pedestalsPaddingHorizontal, this.ritualCenterY + sacrificialCircleRadius, 0), new Vec3i(this.ritualCenterX - sacrificialCircleRadius, this.ritualCenterY - pedestalsPaddingVertical, 0)).collect(Collectors.toList());
        for (int i = 0; i < recipe.m_7527_().size(); ++i) {
            Vec3i pos = (Vec3i)pedestalsPosition.get(i);
            recipeLayout.addSlot(RecipeIngredientRole.INPUT, pos.m_123341_(), pos.m_123342_() - 5).addIngredients((Ingredient)recipe.m_7527_().get(i));
            recipeLayout.addSlot(RecipeIngredientRole.RENDER_ONLY, pos.m_123341_(), pos.m_123342_()).addItemStack(this.pedestals);
        }
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        if (recipe.getRitual() instanceof EnchantItemRitual && recipe.getEnchantment() != null) {
            for (int i = 1; i <= recipe.getEnchantment().m_6586_(); ++i) {
                EnchantmentInstance enchantmentInstance = new EnchantmentInstance(recipe.getEnchantment(), i);
                results.add(EnchantedBookItem.m_41161_((EnchantmentInstance)enchantmentInstance));
            }
        } else {
            results.add(recipe.m_8043_(null));
        }
        recipeLayout.addSlot(RecipeIngredientRole.OUTPUT, this.ritualCenterX + this.recipeOutputOffsetX, this.ritualCenterY - 15).addItemStacks(results);
        recipeLayout.addSlot(RecipeIngredientRole.CATALYST, this.ritualCenterX + this.recipeOutputOffsetX, this.ritualCenterY).addItemStack(this.darkAltar);
        recipeLayout.addSlot(RecipeIngredientRole.RENDER_ONLY, 0, 0).addItemStack(this.getTypeIcon(recipe));
        ItemStack scrollStack = ItemStack.f_41583_;
        if (ResearchList.getResearch(recipe.getResearch()) != null) {
            for (Item item : ForgeRegistries.ITEMS) {
                if (!(item instanceof ResearchScroll)) continue;
                ResearchScroll scroll = (ResearchScroll)item;
                if (scroll.research != ResearchList.getResearch(recipe.getResearch())) continue;
                scrollStack = new ItemStack((ItemLike)scroll);
                break;
            }
        }
        if (!scrollStack.m_41619_()) {
            recipeLayout.addSlot(RecipeIngredientRole.RENDER_ONLY, 0, 16).addItemStack(scrollStack);
        }
    }

    public ItemStack getTypeIcon(RitualRecipe recipe) {
        ItemStack itemStack = new ItemStack((ItemLike)Items.f_41999_);
        for (IRitualType ritualType : RitualType.getAllRitualType()) {
            if (!recipe.getCraftType().equals(ritualType.getName())) continue;
            itemStack = ritualType.getJeiIcon();
        }
        return itemStack;
    }

    public void draw(RitualRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        RenderSystem.enableBlend();
        this.arrow.draw(stack, this.ritualCenterX + this.recipeOutputOffsetX - 20, this.ritualCenterY);
        RenderSystem.disableBlend();
        int infoTextX = this.background.getWidth() / 2;
        int infotextY = 0;
        int initial = 14;
        if (recipe.requiresSacrifice()) {
            this.drawStringCentered(stack, Minecraft.m_91087_().f_91062_, I18n.m_118938_((String)"jei.goety.sacrifice", (Object[])new Object[]{I18n.m_118938_((String)recipe.getEntityToSacrificeDisplayName(), (Object[])new Object[0])}), infoTextX, infotextY += initial);
        }
        int sequence = 9;
        if (recipe.getRitual() instanceof EnchantItemRitual) {
            this.drawStringCentered(stack, Minecraft.m_91087_().f_91062_, I18n.m_118938_((String)"jei.goety.xp", (Object[])new Object[]{recipe.getXPLevelCost()}), infoTextX, infotextY += infotextY == 0 ? initial : sequence);
        }
        if (recipe.getEnchantment() != null) {
            this.drawStringCentered(stack, Minecraft.m_91087_().f_91062_, I18n.m_118938_((String)"jei.goety.enchantment", (Object[])new Object[]{I18n.m_118938_((String)recipe.getEnchantment().m_44704_(), (Object[])new Object[0])}), infoTextX, infotextY += infotextY == 0 ? initial : sequence);
        }
        if (recipe.getEntityToSummon() != null) {
            this.drawStringCentered(stack, Minecraft.m_91087_().f_91062_, I18n.m_118938_((String)"jei.goety.summon", (Object[])new Object[]{I18n.m_118938_((String)recipe.getEntityToSummon().m_20675_(), (Object[])new Object[0])}), infoTextX, infotextY += infotextY == 0 ? initial : sequence);
        }
        if (recipe.getEntityToConvert() != null) {
            this.drawStringCentered(stack, Minecraft.m_91087_().f_91062_, I18n.m_118938_((String)"jei.goety.convert", (Object[])new Object[]{I18n.m_118938_((String)recipe.getEntityToConvertDisplayName(), (Object[])new Object[0])}), infoTextX, infotextY += infotextY == 0 ? initial : sequence);
        }
        if (recipe.getEntityToConvertInto() != null) {
            this.drawStringCentered(stack, Minecraft.m_91087_().f_91062_, I18n.m_118938_((String)"jei.goety.convertInto", (Object[])new Object[]{I18n.m_118938_((String)recipe.getEntityToConvertInto().m_20675_(), (Object[])new Object[0])}), infoTextX, infotextY += infotextY == 0 ? initial : sequence);
        }
        if (recipe.getCraftType() != null) {
            this.drawStringCentered(stack, Minecraft.m_91087_().f_91062_, I18n.m_118938_((String)"jei.goety.craftType", (Object[])new Object[0]) + I18n.m_118938_((String)("jei.goety.craftType." + I18n.m_118938_((String)recipe.getCraftType(), (Object[])new Object[0])), (Object[])new Object[0]), infoTextX, 5);
        }
        this.drawStringCentered(stack, Minecraft.m_91087_().f_91062_, I18n.m_118938_((String)"jei.goety.soulCost", (Object[])new Object[]{recipe.getSoulCost()}), infoTextX, 120);
        this.drawStringCentered(stack, Minecraft.m_91087_().f_91062_, I18n.m_118938_((String)"jei.goety.duration", (Object[])new Object[]{recipe.getDuration()}), infoTextX, 130);
    }

    protected int getStringCenteredMaxX(Font fontRenderer, String text, int x, int y) {
        int width = fontRenderer.m_92895_(text);
        int actualX = (int)((float)x - (float)width / 2.0f);
        return actualX + width;
    }

    protected void drawStringCentered(GuiGraphics matrixStack, Font fontRenderer, String text, int x, int y) {
        matrixStack.m_280056_(fontRenderer, text, (int)((float)x - (float)fontRenderer.m_92895_(text) / 2.0f), y, 0, false);
    }
}

