/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class CrossbowHelper {
    public static List<ItemStack> getChargedProjectiles(ItemStack p_40942_) {
        ListTag listtag;
        ArrayList list = Lists.newArrayList();
        CompoundTag compoundtag = p_40942_.m_41783_();
        if (compoundtag != null && compoundtag.m_128425_("ChargedProjectiles", 9) && (listtag = compoundtag.m_128437_("ChargedProjectiles", 10)) != null) {
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag1 = listtag.m_128728_(i);
                list.add(ItemStack.m_41712_((CompoundTag)compoundtag1));
            }
        }
        return list;
    }

    public static float[] getShotPitches(RandomSource p_220024_) {
        boolean flag = p_220024_.m_188499_();
        return new float[]{1.0f, CrossbowHelper.getRandomShotPitch(flag, p_220024_), CrossbowHelper.getRandomShotPitch(!flag, p_220024_)};
    }

    public static float getRandomShotPitch(boolean p_220026_, RandomSource p_220027_) {
        float f = p_220026_ ? 0.63f : 0.43f;
        return 1.0f / (p_220027_.m_188501_() * 0.5f + 1.8f) + f;
    }

    public static void performCustomShooting(Level level, LivingEntity shooter, InteractionHand hand, ItemStack crossbow, Projectile projectile, float velocity, float p_40893_) {
        CrossbowHelper.performCustomShooting(level, shooter, hand, crossbow, projectile, SoundEvents.f_11847_, velocity, p_40893_);
    }

    public static void performCustomShooting(Level level, LivingEntity shooter, InteractionHand hand, ItemStack crossbow, Projectile projectile, SoundEvent soundEvent, float velocity, float p_40893_) {
        Player player;
        if (shooter instanceof Player && ForgeEventFactory.onArrowLoose((ItemStack)crossbow, (Level)shooter.f_19853_, (Player)(player = (Player)shooter), (int)1, (boolean)true) < 0) {
            return;
        }
        List<ItemStack> list = CrossbowHelper.getChargedProjectiles(crossbow);
        float[] afloat = CrossbowHelper.getShotPitches(shooter.m_217043_());
        for (int i = 0; i < list.size(); ++i) {
            ItemStack itemstack = list.get(i);
            if (itemstack.m_41619_()) continue;
            if (i == 0) {
                CrossbowHelper.shootCustomProjectile(level, shooter, hand, crossbow, projectile, soundEvent, afloat[i], velocity, p_40893_, 0.0f);
                continue;
            }
            if (i == 1) {
                CrossbowHelper.shootCustomProjectile(level, shooter, hand, crossbow, projectile, soundEvent, afloat[i], velocity, p_40893_, -10.0f);
                continue;
            }
            if (i != 2) continue;
            CrossbowHelper.shootCustomProjectile(level, shooter, hand, crossbow, projectile, soundEvent, afloat[i], velocity, p_40893_, 10.0f);
        }
        CrossbowHelper.onCrossbowShot(level, shooter, crossbow);
    }

    public static void onCrossbowShot(Level p_40906_, LivingEntity p_40907_, ItemStack p_40908_) {
        if (p_40907_ instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)p_40907_;
            if (!p_40906_.f_46443_) {
                CriteriaTriggers.f_10555_.m_65462_(serverplayer, p_40908_);
            }
            serverplayer.m_36246_(Stats.f_12982_.m_12902_((Object)p_40908_.m_41720_()));
        }
        CrossbowHelper.clearChargedProjectiles(p_40908_);
    }

    public static void clearChargedProjectiles(ItemStack p_40944_) {
        CompoundTag compoundtag = p_40944_.m_41783_();
        if (compoundtag != null) {
            ListTag listtag = compoundtag.m_128437_("ChargedProjectiles", 9);
            listtag.clear();
            compoundtag.m_128365_("ChargedProjectiles", (Tag)listtag);
        }
    }

    public static void shootCustomProjectile(Level level, LivingEntity shooter, InteractionHand hand, ItemStack crossbow, Projectile projectile, SoundEvent soundEvent, float pitch, float velocity, float p_40903_, float p_40904_) {
        if (!level.f_46443_) {
            if (shooter instanceof CrossbowAttackMob) {
                CrossbowAttackMob crossbowattackmob = (CrossbowAttackMob)shooter;
                if (crossbowattackmob.m_5448_() != null) {
                    crossbowattackmob.m_5811_(crossbowattackmob.m_5448_(), crossbow, projectile, p_40904_);
                }
            } else {
                Vec3 vec31 = shooter.m_20289_(1.0f);
                Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(p_40904_ * ((float)Math.PI / 180)), vec31.f_82479_, vec31.f_82480_, vec31.f_82481_);
                Vec3 vec3 = shooter.m_20252_(1.0f);
                Vector3f vector3f = vec3.m_252839_().rotate((Quaternionfc)quaternionf);
                projectile.m_6686_((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), velocity, p_40903_);
            }
            crossbow.m_41622_(1, shooter, p_40858_ -> p_40858_.m_21190_(hand));
            level.m_7967_((Entity)projectile);
            level.m_6263_((Player)null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), soundEvent, SoundSource.PLAYERS, 1.0f, pitch);
        }
    }
}

