/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.utils;

import com.Polarice3.Goety.config.MobsConfig;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.NetherSpreaderUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FungusBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.Tags;
import org.apache.commons.lang3.mutable.MutableInt;

public interface NetherBehaviour {
    public static final NetherBehaviour DEFAULT = new NetherBehaviour(){

        @Override
        public boolean attemptSpreadVein(LevelAccessor p_222048_, BlockPos p_222049_, BlockState p_222050_, @Nullable Collection<Direction> p_222051_, boolean p_222052_) {
            if (p_222051_ == null) {
                return NetherBehaviour.super.attemptSpreadVein(p_222048_, p_222049_, p_222050_, p_222051_, p_222052_);
            }
            if (!p_222051_.isEmpty()) {
                return NetherBehaviour.super.attemptSpreadVein(p_222048_, p_222049_, p_222050_, p_222051_, p_222052_);
            }
            return NetherBehaviour.super.attemptSpreadVein(p_222048_, p_222049_, p_222050_, p_222051_, p_222052_);
        }

        @Override
        public int attemptUseCharge(NetherSpreaderUtil.ChargeCursor p_222054_, LevelAccessor p_222055_, BlockPos p_222056_, RandomSource p_222057_, NetherSpreaderUtil p_222058_, boolean p_222059_) {
            return p_222054_.getCharge();
        }

        @Override
        public int updateDecayDelay(int p_222061_) {
            return Math.max(p_222061_ - 1, 0);
        }
    };

    public static boolean regrowNether(LevelAccessor accessor, BlockPos blockPos, BlockState originalState) {
        IPlantable plantable;
        BlockState blockstate;
        BlockState above;
        block26: {
            block28: {
                block27: {
                    Level level;
                    Block block;
                    above = accessor.m_8055_(blockPos.m_7494_());
                    if ((originalState.m_204336_(BlockTags.f_13077_) || originalState.m_60734_() instanceof FungusBlock || above.m_60734_() instanceof FungusBlock) && (block = originalState.m_60734_()) instanceof BonemealableBlock) {
                        BonemealableBlock bonemealableBlock = (BonemealableBlock)block;
                        if (accessor instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)accessor;
                            if (serverLevel.f_46441_.m_188503_(16) == 0) {
                                if (originalState.m_60734_() instanceof FungusBlock) {
                                    bonemealableBlock.m_214148_(serverLevel, accessor.m_213780_(), blockPos, originalState);
                                } else if (above.m_60734_() instanceof FungusBlock) {
                                    bonemealableBlock.m_214148_(serverLevel, accessor.m_213780_(), blockPos.m_7494_(), originalState);
                                }
                                return true;
                            }
                            if (serverLevel.f_46441_.m_188503_(64) == 0) {
                                bonemealableBlock.m_214148_(serverLevel, accessor.m_213780_(), blockPos, originalState);
                                return true;
                            }
                        }
                    }
                    if (originalState.m_204336_(Tags.Blocks.ORES_IRON) || originalState.m_204336_(Tags.Blocks.ORES_GOLD)) {
                        blockstate = Blocks.f_49998_.m_49966_();
                        accessor.m_7731_(blockPos, blockstate, 3);
                        return true;
                    }
                    if (originalState.m_204336_(Tags.Blocks.ORES_COAL) || originalState.m_204336_(Tags.Blocks.ORES_COPPER)) {
                        blockstate = Blocks.f_50331_.m_49966_();
                        accessor.m_7731_(blockPos, blockstate, 3);
                        return true;
                    }
                    if (originalState.m_204336_(BlockTags.f_13105_)) {
                        blockstate = Blocks.f_50137_.m_49966_();
                        if (originalState.m_61138_((Property)RotatedPillarBlock.f_55923_)) {
                            blockstate = (BlockState)Blocks.f_50137_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)((Direction.Axis)originalState.m_61143_((Property)RotatedPillarBlock.f_55923_)));
                        }
                        accessor.m_7731_(blockPos, blockstate, 3);
                        accessor.m_46796_(2001, blockPos, Block.m_49956_((BlockState)blockstate));
                        NetherBehaviour.changeBiome(accessor, blockPos);
                        return true;
                    }
                    if (!(accessor instanceof Level) || !BlockFinder.canBeReplaced(level = (Level)accessor, blockPos) || originalState.m_60795_() || originalState.m_60734_() instanceof LiquidBlock || originalState.m_60734_() instanceof BaseFireBlock) break block26;
                    if (level.f_46441_.m_188501_() <= 0.15f && !(originalState.m_60734_() instanceof IPlantable)) break block27;
                    Block block2 = originalState.m_60734_();
                    if (!(block2 instanceof IPlantable)) break block28;
                    plantable = (IPlantable)block2;
                    if (Blocks.f_50134_.m_49966_().canSustainPlant((BlockGetter)accessor, blockPos.m_7495_(), Direction.UP, plantable)) break block28;
                }
                BlockState fire = BaseFireBlock.m_49245_((BlockGetter)accessor, (BlockPos)blockPos);
                accessor.m_7731_(blockPos, fire, 3);
                accessor.m_46796_(2001, blockPos, Block.m_49956_((BlockState)fire));
            }
            NetherBehaviour.changeBiome(accessor, blockPos);
            return true;
        }
        if (originalState.m_60713_(Blocks.f_49990_)) {
            blockstate = Blocks.f_50450_.m_49966_();
            accessor.m_7731_(blockPos, blockstate, 3);
            accessor.m_46796_(2001, blockPos, Block.m_49956_((BlockState)blockstate));
            NetherBehaviour.changeBiome(accessor, blockPos);
            return true;
        }
        if (originalState.m_60713_(Blocks.f_152537_)) {
            blockstate = Blocks.f_50137_.m_49966_();
            accessor.m_7731_(blockPos, blockstate, 3);
            accessor.m_46796_(2001, blockPos, Block.m_49956_((BlockState)blockstate));
            NetherBehaviour.changeBiome(accessor, blockPos);
            return true;
        }
        if (originalState.m_60734_() instanceof SnowyDirtBlock) {
            IPlantable plantable2;
            blockstate = Blocks.f_50699_.m_49966_();
            Holder holder = accessor.m_204166_(blockPos);
            if (!(holder.m_203656_(BiomeTags.f_207611_) || holder.m_203656_(Tags.Biomes.IS_SWAMP) || holder.m_203565_(Biomes.f_48200_))) {
                blockstate = Blocks.f_50134_.m_49966_();
            }
            accessor.m_7731_(blockPos, blockstate, 3);
            accessor.m_46796_(2001, blockPos, Block.m_49956_((BlockState)blockstate));
            Block block = above.m_60734_();
            if (block instanceof IPlantable && !blockstate.canSustainPlant((BlockGetter)accessor, blockPos, Direction.UP, plantable2 = (IPlantable)block)) {
                BlockState fire = BaseFireBlock.m_49245_((BlockGetter)accessor, (BlockPos)blockPos.m_7494_());
                accessor.m_7731_(blockPos.m_7494_(), fire, 3);
                accessor.m_46796_(2001, blockPos.m_7494_(), Block.m_49956_((BlockState)fire));
            }
            NetherBehaviour.changeBiome(accessor, blockPos);
            return true;
        }
        if (originalState.m_204336_(Tags.Blocks.STONE)) {
            blockstate = Blocks.f_50730_.m_49966_();
            accessor.m_7731_(blockPos, blockstate, 3);
            accessor.m_46796_(2001, blockPos, Block.m_49956_((BlockState)blockstate));
            NetherBehaviour.changeBiome(accessor, blockPos);
            return true;
        }
        if (originalState.m_60713_(Blocks.f_220864_) || originalState.m_204336_(Tags.Blocks.SAND)) {
            blockstate = Blocks.f_50135_.m_49966_();
            accessor.m_7731_(blockPos, blockstate, 3);
            accessor.m_46796_(2001, blockPos, Block.m_49956_((BlockState)blockstate));
            Block plantable2 = above.m_60734_();
            if (plantable2 instanceof IPlantable && !blockstate.canSustainPlant((BlockGetter)accessor, blockPos, Direction.UP, plantable = (IPlantable)plantable2)) {
                BlockState fire = BaseFireBlock.m_49245_((BlockGetter)accessor, (BlockPos)blockPos.m_7494_());
                accessor.m_7731_(blockPos.m_7494_(), fire, 3);
                accessor.m_46796_(2001, blockPos.m_7494_(), Block.m_49956_((BlockState)fire));
            }
            NetherBehaviour.changeBiome(accessor, blockPos);
            return true;
        }
        if (originalState.m_204336_(Tags.Blocks.SANDSTONE)) {
            blockstate = Blocks.f_50136_.m_49966_();
            accessor.m_7731_(blockPos, blockstate, 3);
            accessor.m_46796_(2001, blockPos, Block.m_49956_((BlockState)blockstate));
            Block fire = above.m_60734_();
            if (fire instanceof IPlantable && !blockstate.canSustainPlant((BlockGetter)accessor, blockPos, Direction.UP, plantable = (IPlantable)fire)) {
                fire = BaseFireBlock.m_49245_((BlockGetter)accessor, (BlockPos)blockPos.m_7494_());
                accessor.m_7731_(blockPos.m_7494_(), (BlockState)fire, 3);
                accessor.m_46796_(2001, blockPos.m_7494_(), Block.m_49956_((BlockState)fire));
            }
            NetherBehaviour.changeBiome(accessor, blockPos);
            return true;
        }
        if (originalState.m_204336_(ModTags.Blocks.NETHER_SPREAD_REPLACEABLE)) {
            blockstate = Blocks.f_50134_.m_49966_();
            accessor.m_7731_(blockPos, blockstate, 3);
            accessor.m_46796_(2001, blockPos, Block.m_49956_((BlockState)blockstate));
            Block fire = above.m_60734_();
            if (fire instanceof IPlantable && !blockstate.canSustainPlant((BlockGetter)accessor, blockPos, Direction.UP, plantable = (IPlantable)fire)) {
                fire = BaseFireBlock.m_49245_((BlockGetter)accessor, (BlockPos)blockPos.m_7494_());
                accessor.m_7731_(blockPos.m_7494_(), (BlockState)fire, 3);
                accessor.m_46796_(2001, blockPos.m_7494_(), Block.m_49956_((BlockState)fire));
            }
            NetherBehaviour.changeBiome(accessor, blockPos);
            return true;
        }
        return false;
    }

    public static void changeBiome(LevelAccessor levelAccessor, BlockPos blockPos) {
        if (((Boolean)MobsConfig.ObsidianMonolithBiome.get()).booleanValue()) {
            MutableInt mutableint = new MutableInt(0);
            BoundingBox boundingbox = new BoundingBox(blockPos.m_123341_() - 1, blockPos.m_123342_(), blockPos.m_123343_() - 1, blockPos.m_123341_() + 1, blockPos.m_123342_() + 20, blockPos.m_123343_() + 1);
            ArrayList<ChunkAccess> list = new ArrayList<ChunkAccess>();
            if (levelAccessor instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)levelAccessor;
                for (int k = SectionPos.m_123171_((int)boundingbox.m_162398_()); k <= SectionPos.m_123171_((int)boundingbox.m_162401_()); ++k) {
                    for (int l = SectionPos.m_123171_((int)boundingbox.m_162395_()); l <= SectionPos.m_123171_((int)boundingbox.m_162399_()); ++l) {
                        ChunkAccess chunkaccess = serverLevel.m_6522_(l, k, ChunkStatus.f_62326_, false);
                        list.add(chunkaccess);
                    }
                }
                for (ChunkAccess chunkaccess1 : list) {
                    chunkaccess1.m_183442_(NetherBehaviour.makeResolver(levelAccessor, mutableint, chunkaccess1, boundingbox), serverLevel.m_7726_().m_214994_().m_224579_());
                    chunkaccess1.m_8092_(true);
                }
                serverLevel.m_7726_().f_8325_.m_274524_(list);
            }
        }
    }

    private static BiomeResolver makeResolver(LevelAccessor levelAccessor, MutableInt p_262615_, ChunkAccess p_262698_, BoundingBox p_262622_) {
        return (p_262550_, p_262551_, p_262552_, p_262553_) -> {
            int i = QuartPos.m_175402_((int)p_262550_);
            int j = QuartPos.m_175402_((int)p_262551_);
            int k = QuartPos.m_175402_((int)p_262552_);
            Holder holder = p_262698_.m_203495_(p_262550_, p_262551_, p_262552_);
            if (p_262622_.m_260866_(i, j, k) && !holder.m_203656_(BiomeTags.f_207612_)) {
                Optional biomeHolder;
                p_262615_.increment();
                if ((holder.m_203656_(BiomeTags.f_207611_) || holder.m_203656_(Tags.Biomes.IS_SWAMP)) && (biomeHolder = levelAccessor.m_9598_().m_175515_(Registries.f_256952_).m_203636_(Biomes.f_48200_)).isPresent()) {
                    return (Holder)biomeHolder.get();
                }
                if (holder.m_203656_(Tags.Biomes.IS_SANDY) && (biomeHolder = levelAccessor.m_9598_().m_175515_(Registries.f_256952_).m_203636_(Biomes.f_48199_)).isPresent()) {
                    return (Holder)biomeHolder.get();
                }
                if (holder.m_203656_(Tags.Biomes.IS_MOUNTAIN) && (biomeHolder = levelAccessor.m_9598_().m_175515_(Registries.f_256952_).m_203636_(Biomes.f_48175_)).isPresent()) {
                    return (Holder)biomeHolder.get();
                }
                biomeHolder = levelAccessor.m_9598_().m_175515_(Registries.f_256952_).m_203636_(Biomes.f_48209_);
                if (biomeHolder.isPresent()) {
                    return (Holder)biomeHolder.get();
                }
            } else {
                return holder;
            }
            return holder;
        };
    }

    default public byte getNetherSpreadDelay() {
        return 1;
    }

    default public void onDischarged(LevelAccessor p_222026_, BlockState p_222027_, BlockPos p_222028_, RandomSource p_222029_) {
    }

    default public boolean depositCharge(LevelAccessor p_222031_, BlockPos p_222032_, RandomSource p_222033_) {
        return false;
    }

    default public boolean attemptSpreadVein(LevelAccessor p_222034_, BlockPos p_222035_, BlockState p_222036_, @Nullable Collection<Direction> p_222037_, boolean p_222038_) {
        return NetherBehaviour.regrowNether(p_222034_, p_222035_, p_222036_);
    }

    default public boolean canChangeBlockStateOnSpread() {
        return true;
    }

    default public int updateDecayDelay(int p_222045_) {
        return 1;
    }

    public int attemptUseCharge(NetherSpreaderUtil.ChargeCursor var1, LevelAccessor var2, BlockPos var3, RandomSource var4, NetherSpreaderUtil var5, boolean var6);
}

