/*
 * Decompiled with CFR 0.152.
 */
package krash220.xbob.loader.fabric;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import krash220.xbob.loader.utils.FabricQuiltUtils;
import krash220.xbob.loader.utils.VersionMapping;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MixinPlugin
implements IMixinConfigPlugin {
    public void onLoad(String mixinPackage) {
        String version = FabricQuiltUtils.getVersion();
        String lib = VersionMapping.get(version);
        String coreFile = "/META-INF/core/fabric" + lib + ".jar";
        FileSystem fs = null;
        try {
            URI uri = MixinPlugin.class.getResource("MixinPlugin.class").toURI();
            fs = FabricQuiltUtils.getFileSystem(uri);
        }
        catch (IOException | URISyntaxException uri) {
            // empty catch block
        }
        Path core = fs.getPath(coreFile, new String[0]);
        if (!Files.exists(core, new LinkOption[0])) {
            FabricQuiltUtils.displayError("Incompatible mod.", "[xbob] This mod do not support Minecraft " + version, true);
        }
        Map patchedClasses = null;
        try {
            Object transformer = FabricQuiltUtils.getGameTransformer();
            Field patched = transformer.getClass().getDeclaredField("patchedClasses");
            patched.setAccessible(true);
            patchedClasses = (Map)patched.get(transformer);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException transformer) {
            // empty catch block
        }
        if (patchedClasses == null) {
            FabricQuiltUtils.displayError("Incompatible mod.", "Unable to load this mod.", true);
        }
        try {
            ZipInputStream input = new ZipInputStream(Files.newInputStream(core, new OpenOption[0]));
            ZipEntry entry = input.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                if (name.endsWith(".class")) {
                    byte[] buf = new byte[4096];
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    int read = 0;
                    while ((read = input.read(buf)) > 0) {
                        bos.write(buf, 0, read);
                    }
                    patchedClasses.put(name.replace("/", ".").substring(0, name.length() - 6), bos.toByteArray());
                    bos.close();
                }
                input.closeEntry();
                entry = input.getNextEntry();
            }
            input.close();
        }
        catch (IOException e1) {
            FabricQuiltUtils.displayError("Incompatible mod.", "This mod is damaged.", true);
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

