/*
 * Decompiled with CFR 0.152.
 */
package krash220.xbob.loader.forge;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.ProviderNotFoundException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import krash220.xbob.loader.forge.ModPath;
import krash220.xbob.loader.utils.Jre8ZipFs;
import krash220.xbob.loader.utils.VersionMapping;
import net.minecraftforge.fml.loading.moddiscovery.ExplodedDirectoryLocator;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class ModLocator
extends ExplodedDirectoryLocator {
    public String name() {
        return "xbob modloader";
    }

    public void initArguments(Map<String, ?> arguments) {
        HashMap map = new HashMap(arguments);
        String version = (String)arguments.get("mcVersion");
        String lib = VersionMapping.get(version);
        URI uri = null;
        Path loader = null;
        try {
            uri = ModLocator.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            String path = uri.getPath();
            if (uri.getScheme().equals("union") && path.contains("#")) {
                path = path.substring(0, path.lastIndexOf("#"));
            }
            loader = new File(path).toPath();
            uri = URI.create("jar:" + new File(path).toURI().toURL());
            try {
                FileSystems.newFileSystem(uri, new HashMap());
            }
            catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {}
        }
        catch (IOException | URISyntaxException e) {
            return;
        }
        FileSystem fs = FileSystems.getFileSystem(uri);
        Path mod = fs.getPath("/mod.jar", new String[0]);
        Path core = fs.getPath("/META-INF/core/forge" + lib + ".jar", new String[0]);
        if (!Files.exists(mod, new LinkOption[0])) {
            throw new Error("[xbob] Missing mod.jar.");
        }
        if (!Files.exists(core, new LinkOption[0])) {
            throw new Error("[xbob] This mod do not support Minecraft " + arguments.get("mcVersion"));
        }
        try {
            mod = new ModPath(FileSystems.newFileSystem(mod, ((Object)((Object)this)).getClass().getClassLoader()).getPath("/", new String[0]), loader);
            core = new ModPath(FileSystems.newFileSystem(core, ((Object)((Object)this)).getClass().getClassLoader()).getPath("/", new String[0]), loader);
        }
        catch (IOException iOException) {
        }
        catch (ProviderNotFoundException e) {
            mod = new ModPath(Jre8ZipFs.newZipFs(mod).getPath("/", new String[0]), loader);
            core = new ModPath(Jre8ZipFs.newZipFs(core).getPath("/", new String[0]), loader);
        }
        if (VersionMapping.getNum(version) >= 11700) {
            map.put("explodedTargets", ImmutableList.of((Object)new ExplodedDirectoryLocator.ExplodedMod("xbob", (List)ImmutableList.of((Object)mod, (Object)core))));
        } else {
            map.put("explodedTargets", ImmutableList.of((Object)ImmutablePair.of((Object)mod, (Object)ImmutableList.of((Object)mod, (Object)core))));
        }
        super.initArguments(map);
    }
}

