/*
 * Decompiled with CFR 0.152.
 */
package krash220.xbob.loader.utils;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Paths;
import java.util.HashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.fabricmc.loader.impl.gui.FabricGuiEntry;
import org.quiltmc.loader.api.QuiltLoader;
import org.quiltmc.loader.impl.QuiltLoaderImpl;
import org.quiltmc.loader.impl.gui.QuiltGuiEntry;

public class FabricQuiltUtils {
    private static final boolean isQuilt;

    public static String getPlatform() {
        return isQuilt ? "Quilt" : "Fabric";
    }

    public static String getVersion() {
        if (isQuilt) {
            return QuiltLoaderImpl.INSTANCE.getGameProvider().getRawGameVersion();
        }
        return FabricLoaderImpl.INSTANCE.getGameProvider().getRawGameVersion();
    }

    public static void displayError(String main, String err, boolean exitAfter) {
        if (isQuilt) {
            QuiltGuiEntry.displayError((String)main, (Throwable)new RuntimeException(err), (boolean)true, (boolean)exitAfter);
        } else {
            FabricGuiEntry.displayError((String)main, (Throwable)new RuntimeException(err), (boolean)exitAfter);
        }
        throw new RuntimeException(err);
    }

    public static Object getGameTransformer() {
        if (isQuilt) {
            return QuiltLoaderImpl.INSTANCE.getGameProvider().getEntrypointTransformer();
        }
        return FabricLoaderImpl.INSTANCE.getGameProvider().getEntrypointTransformer();
    }

    public static EnvType getEnvironmentType() {
        if (isQuilt) {
            return QuiltLoaderImpl.INSTANCE.getEnvironmentType();
        }
        return FabricLoaderImpl.INSTANCE.getEnvironmentType();
    }

    public static FileSystem getFileSystem(URI uri) throws IOException {
        if (isQuilt) {
            return Paths.get(uri).getFileSystem();
        }
        return FileSystems.newFileSystem(uri, new HashMap());
    }

    public static File getConfigDir() {
        if (isQuilt) {
            return QuiltLoader.getConfigDir().toFile();
        }
        return FabricLoader.getInstance().getConfigDir().toFile();
    }

    static {
        boolean q = false;
        try {
            Class.forName("org.quiltmc.loader.api.QuiltLoader");
            q = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        isQuilt = q;
    }
}

